/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.locks;

import java.awt.AWTKeyStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.LockCCTProvider;
import org.netbeans.lib.profiler.results.locks.LockRuntimeCCTNode;
import org.netbeans.lib.profiler.ui.ResultsPanel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.locks.LockContentionTreeCellRenderer;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public class LockContentionPanel
extends ResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.locks.Bundle");
    private static final String ENABLE_LOCKS_MONITORING = messages.getString("LockContentionPanel_EnableLocksMonitoring");
    private static final String ENABLE_LOCKS_MONITORING_TOOLTIP = messages.getString("LockContentionPanel_EnableLocksMonitoringToolTip");
    private static final String NO_PROFILING = messages.getString("LockContentionPanel_NoProfiling");
    private static final String LOCKS_THREADS_COLUMN_NAME = messages.getString("LockContentionPanel_LocksThreadsColumnName");
    private static final String LOCKS_THREADS_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_LocksThreadsColumnToolTip");
    private static final String TIME_COLUMN_NAME = messages.getString("LockContentionPanel_TimeColumnName");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_TimeColumnToolTip");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("LockContentionPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_TimeRelColumnToolTip");
    private static final String WAITS_COLUMN_NAME = messages.getString("LockContentionPanel_WaitsColumnName");
    private static final String WAITS_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_WaitsColumnToolTip");
    private static final String DISPLAY_MODE = messages.getString("LockContentionPanel_DisplayMode");
    private static final String MODE_THREADS = messages.getString("LockContentionPanel_ModeThreads");
    private static final String MODE_MONITORS = messages.getString("LockContentionPanel_ModeMonitors");
    private final ProfilerToolbar toolbar;
    private final LocksTreeTableModel realTreeTableModel;
    private final ExtendedTreeTableModel treeTableModel;
    private final JTreeTable treeTable;
    private final JTreeTablePanel treeTablePanel;
    private final JComboBox modeCombo;
    private final JPopupMenu tablePopup;
    private final JPopupMenu cornerPopup;
    private boolean sortingOrder = false;
    private int sortingColumn = 1;
    private int columnCount;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private EnhancedTreeCellRenderer treeCellRenderer = new LockContentionTreeCellRenderer();
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean lockContentionEnabled;
    private final JPanel contentPanel;
    private final JPanel notificationPanel;
    private final JButton enableLockContentionButton;
    private final JLabel enableLockContentionLabel1;
    private final JLabel enableLockContentionLabel2;
    private LockRuntimeCCTNode root;
    private Listener cctListener;
    private long countsInMicrosec;

    public LockContentionPanel() {
        this.toolbar = ProfilerToolbar.create(true);
        JLabel jLabel = new JLabel(DISPLAY_MODE);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.toolbar.add(jLabel);
        this.modeCombo = new JComboBox(new Object[]{MODE_THREADS, MODE_MONITORS}){

            @Override
            protected void fireActionEvent() {
                super.fireActionEvent();
                LockContentionPanel.this.treeTable.clearSelection();
                LockContentionPanel.this.prepareResults();
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = this.getPreferredSize();
                dimension.width += 20;
                return dimension;
            }
        };
        this.modeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (MODE_THREADS.equals(object.toString())) {
                    defaultListCellRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
                } else if (MODE_MONITORS.equals(object.toString())) {
                    defaultListCellRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.WindowLocks"));
                }
                return defaultListCellRenderer;
            }
        });
        jLabel.setLabelFor(this.modeCombo);
        this.toolbar.add(this.modeCombo);
        this.initColumnsData();
        this.realTreeTableModel = new LocksTreeTableModel();
        this.treeTableModel = new ExtendedTreeTableModel(this.realTreeTableModel);
        this.treeTable = new JTreeTable(this.treeTableModel){

            @Override
            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < LockContentionPanel.this.treeTableModel.getColumnCount(); ++i) {
                    if (LockContentionPanel.this.treeTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.treeTable.getTree().setRootVisible(false);
        this.treeTable.getTree().setShowsRootHandles(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getTree().setLargeModel(true);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.clearBorders();
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBackground(this.treeTable.getBackground());
        UIUtils.decorateProfilerPanel(this.notificationPanel);
        CompoundBorder compoundBorder = new CompoundBorder(new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatToolBar.FlatMarginBorder());
        this.enableLockContentionLabel1 = new JLabel(ENABLE_LOCKS_MONITORING);
        this.enableLockContentionLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 3));
        this.enableLockContentionLabel1.setForeground(Color.DARK_GRAY);
        this.enableLockContentionButton = new JButton(Icons.getIcon((String)"ProfilerIcons.ViewLocks32"));
        this.enableLockContentionButton.setToolTipText(ENABLE_LOCKS_MONITORING_TOOLTIP);
        this.enableLockContentionButton.setContentAreaFilled(false);
        this.enableLockContentionButton.setMargin(new Insets(3, 3, 3, 3));
        this.enableLockContentionButton.setVerticalTextPosition(3);
        this.enableLockContentionButton.setHorizontalTextPosition(0);
        this.enableLockContentionButton.setRolloverEnabled(true);
        this.enableLockContentionButton.setBorder(compoundBorder);
        this.enableLockContentionButton.getAccessibleContext().setAccessibleName(ENABLE_LOCKS_MONITORING_TOOLTIP);
        this.enableLockContentionLabel2 = new JLabel(NO_PROFILING);
        this.enableLockContentionLabel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.enableLockContentionLabel2.setForeground(Color.DARK_GRAY);
        this.enableLockContentionLabel2.setVisible(false);
        this.notificationPanel.add(this.enableLockContentionLabel1);
        this.notificationPanel.add(this.enableLockContentionButton);
        this.notificationPanel.add(this.enableLockContentionLabel2);
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)this.notificationPanel, "DISABLED");
        this.contentPanel.add((Component)this.treeTablePanel, "ENABLED");
        this.add((Component)this.contentPanel, "Center");
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setDefaultSorting();
        this.prepareResults();
    }

    public void addSaveViewAction(AbstractAction abstractAction) {
        Component component = this.toolbar.add(abstractAction);
        this.toolbar.remove(component);
        this.toolbar.add(component, 0);
        this.toolbar.add(new JToolBar.Separator(), 1);
    }

    public void addExportAction(AbstractAction abstractAction) {
        Component component = this.toolbar.add(abstractAction);
        this.toolbar.remove(component);
        this.toolbar.add(component, 0);
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, string);
            }
        }
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = "   ";
        for (int i = 0; i < this.columnNames.length; ++i) {
            stringBuffer.append(string3).append(this.columnNames[i]).append(string3).append(string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        LockCCTNode lockCCTNode = null;
        String string5 = this.modeCombo.getSelectedItem().toString();
        if (MODE_THREADS.equals(string5)) {
            lockCCTNode = this.root.getThreads();
        } else if (MODE_MONITORS.equals(string5)) {
            lockCCTNode = this.root.getMonitors();
        }
        if (lockCCTNode != null) {
            lockCCTNode.sortChildren(this.getSortBy(this.sortingColumn), this.sortingOrder);
            for (int i = 0; i < lockCCTNode.getNChildren(); ++i) {
                LockCCTNode lockCCTNode2 = lockCCTNode.getChild(i);
                stringBuffer.append(string3).append(lockCCTNode2.getNodeName()).append(string3).append(string);
                stringBuffer.append(lockCCTNode2.getTimeInPerCent()).append(string);
                stringBuffer.append(this.getTimeInMillis(lockCCTNode2)).append(string);
                stringBuffer.append(lockCCTNode2.getWaits()).append(string2);
                if (lockCCTNode2.getNChildren() <= 0) continue;
                for (int j = 0; j < lockCCTNode2.getNChildren(); ++j) {
                    LockCCTNode lockCCTNode3 = lockCCTNode2.getChild(j);
                    stringBuffer.append(string3).append(string4).append(lockCCTNode3.getNodeName()).append(string3).append(string);
                    stringBuffer.append(lockCCTNode3.getTimeInPerCent()).append(string);
                    stringBuffer.append(this.getTimeInMillis(lockCCTNode3)).append(string);
                    stringBuffer.append(lockCCTNode3.getWaits()).append(string2);
                }
            }
        }
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        exportDataDumper.close();
    }

    private void exportXML(ExportDataDumper exportDataDumper, String string) {
        String string2;
        String string3;
        LockCCTNode lockCCTNode;
        String string4 = "\r\n";
        String string5 = "\"";
        String string6 = "   ";
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string4 + "<ExportedView Name=\"" + string + "\" type=\"" + "tree" + "\">" + string4 + "<tree>" + string4);
        LockRuntimeCCTNode lockRuntimeCCTNode = this.root;
        boolean bl = MODE_THREADS.equals(this.modeCombo.getSelectedItem().toString());
        if (bl) {
            lockCCTNode = lockRuntimeCCTNode.getThreads();
            string3 = "thread";
            string2 = "monitor";
        } else {
            lockCCTNode = lockRuntimeCCTNode.getMonitors();
            string2 = "thread";
            string3 = "monitor";
        }
        if (lockCCTNode != null) {
            lockCCTNode.sortChildren(this.getSortBy(this.sortingColumn), this.sortingOrder);
            for (int i = 0; i < lockCCTNode.getNChildren(); ++i) {
                LockCCTNode lockCCTNode2 = lockCCTNode.getChild(i);
                stringBuffer.append(string6).append("<").append(string3).append(">").append(string4);
                stringBuffer.append(string6).append(string6).append("<name>").append(string5).append(lockCCTNode2.getNodeName()).append(string5).append("</name>").append(string4);
                stringBuffer.append(string6).append(string6).append("<time_relative>").append(lockCCTNode2.getTimeInPerCent()).append("</time_relative>").append(string4);
                stringBuffer.append(string6).append(string6).append("<time>").append(this.getTimeInMillis(lockCCTNode2)).append("</time>").append(string4);
                stringBuffer.append(string6).append(string6).append("<waits>").append(lockCCTNode2.getWaits()).append("</waits>").append(string4);
                if (lockCCTNode2.getNChildren() > 0) {
                    for (int j = 0; j < lockCCTNode2.getNChildren(); ++j) {
                        LockCCTNode lockCCTNode3 = lockCCTNode2.getChild(j);
                        stringBuffer.append(string6).append(string6).append("<").append(string2).append(">").append(string4);
                        stringBuffer.append(string6).append(string6).append(string6).append("<name>").append(string5).append(lockCCTNode3.getNodeName()).append(string5).append("</name>").append(string4);
                        stringBuffer.append(string6).append(string6).append(string6).append("<time_relative>").append(lockCCTNode3.getTimeInPerCent()).append("</time_relative>").append(string4);
                        stringBuffer.append(string6).append(string6).append(string6).append("<time>").append(this.getTimeInMillis(lockCCTNode3)).append("</time>").append(string4);
                        stringBuffer.append(string6).append(string6).append(string6).append("<waits>").append(lockCCTNode3.getWaits()).append("</waits>").append(string4);
                        stringBuffer.append(string6).append(string6).append("</").append(string2).append(">").append(string4);
                    }
                }
                stringBuffer.append(string6).append("</").append(string3).append(">").append(string4);
            }
        }
        stringBuffer.append("</tree>").append(string4).append("</ExportedView>");
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        exportDataDumper.close();
    }

    private void exportHTML(ExportDataDumper exportDataDumper, String string) {
        int n;
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = "   ";
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        LockRuntimeCCTNode lockRuntimeCCTNode = this.root;
        LockCCTNode lockCCTNode = null;
        String string5 = this.modeCombo.getSelectedItem().toString();
        if (MODE_THREADS.equals(string5)) {
            lockCCTNode = lockRuntimeCCTNode.getThreads();
        } else if (MODE_MONITORS.equals(string5)) {
            lockCCTNode = lockRuntimeCCTNode.getMonitors();
        }
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append("<td>").append(this.columnNames[n]).append("</td>");
        }
        stringBuffer.append("</tr>");
        if (lockCCTNode != null) {
            lockCCTNode.sortChildren(this.getSortBy(this.sortingColumn), this.sortingOrder);
            for (n = 0; n < lockCCTNode.getNChildren(); ++n) {
                LockCCTNode lockCCTNode2 = lockCCTNode.getChild(n);
                stringBuffer.append("<tr><td><pre>").append(lockCCTNode2.getNodeName()).append("</pre></td>");
                stringBuffer.append("<td>").append(lockCCTNode2.getTimeInPerCent()).append("%</td>");
                stringBuffer.append("<td>").append(this.getTimeInMillis(lockCCTNode2)).append("</td>");
                stringBuffer.append("<td>").append(lockCCTNode2.getWaits()).append("</td></tr>").append(string2);
                if (lockCCTNode2.getNChildren() <= 0) continue;
                for (int i = 0; i < lockCCTNode2.getNChildren(); ++i) {
                    LockCCTNode lockCCTNode3 = lockCCTNode2.getChild(i);
                    stringBuffer.append("<tr><td><pre>").append(string4).append(lockCCTNode3.getNodeName()).append("</pre></td>");
                    stringBuffer.append("<td>").append(lockCCTNode3.getTimeInPerCent()).append("</td>");
                    stringBuffer.append("<td>").append(this.getTimeInMillis(lockCCTNode3)).append("</td>");
                    stringBuffer.append("<td>").append(lockCCTNode3.getWaits()).append("</td></tr>");
                }
            }
            stringBuffer.append("</table></BODY></HTML>");
        }
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        exportDataDumper.close();
    }

    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    public boolean hasView() {
        return this.modeCombo.isEnabled();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (!this.hasView()) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public void setSorting(int n, boolean bl) {
        this.setSorting(n, bl, false);
    }

    public void setSorting(int n, boolean bl, boolean bl2) {
        if (!bl2 && n == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = n;
            this.sortingOrder = bl;
        }
        if (bl2) {
            this.treeTable.setSortingColumn(this.treeTableModel.getVirtualColumn(n));
            this.treeTable.setSortingOrder(bl);
            this.treeTableModel.sortByColumn(n, bl);
        }
    }

    public int getSortingColumn() {
        return this.treeTableModel.getRealColumn(this.treeTable.getSortingColumn());
    }

    public boolean getSortingOrder() {
        return this.treeTable.getSortingOrder();
    }

    @Override
    public void prepareResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LockContentionPanel.this.modeCombo.setEnabled(LockContentionPanel.this.root != null);
                if (LockContentionPanel.this.root == null) {
                    return;
                }
                String string = LockContentionPanel.this.modeCombo.getSelectedItem().toString();
                LockCCTNode lockCCTNode = null;
                if (MODE_THREADS.equals(string)) {
                    lockCCTNode = LockContentionPanel.this.root.getThreads();
                } else if (MODE_MONITORS.equals(string)) {
                    lockCCTNode = LockContentionPanel.this.root.getMonitors();
                }
                lockCCTNode.sortChildren(LockContentionPanel.this.getSortBy(LockContentionPanel.this.sortingColumn), LockContentionPanel.this.sortingOrder);
                LockContentionPanel.this.treeTable.changeRoot((CCTNode)lockCCTNode);
            }
        });
    }

    public void profilingSessionFinished() {
        this.enableLockContentionButton.setEnabled(false);
        this.enableLockContentionButton.setVisible(false);
        this.enableLockContentionLabel1.setVisible(false);
        this.enableLockContentionLabel2.setVisible(true);
    }

    public void profilingSessionStarted() {
        ProfilingSessionStatus profilingSessionStatus = TargetAppRunner.getDefault().getProfilingSessionStatus();
        this.countsInMicrosec = profilingSessionStatus.timerCountsInSecond[0] / 1000000L;
        if (this.cctListener == null) {
            this.cctListener = new Listener();
            LockCCTProvider lockCCTProvider = (LockCCTProvider)Lookup.getDefault().lookup(LockCCTProvider.class);
            assert (lockCCTProvider != null);
            lockCCTProvider.addListener((CCTProvider.Listener)this.cctListener);
        } else {
            this.treeTableModel.setRoot(LockCCTNode.EMPTY);
            this.treeTable.clearSelection();
            this.treeTable.updateTreeTable();
        }
        this.enableLockContentionButton.setEnabled(true);
        this.enableLockContentionButton.setVisible(true);
        this.enableLockContentionLabel1.setVisible(true);
        this.enableLockContentionLabel2.setVisible(false);
    }

    public void lockContentionDisabled() {
        this.lockContentionEnabled = false;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "DISABLED");
    }

    public void lockContentionEnabled() {
        this.lockContentionEnabled = true;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "ENABLED");
    }

    public void addLockContentionListener(ActionListener actionListener) {
        this.enableLockContentionButton.addActionListener(actionListener);
    }

    public void removeLockContentionListener(ActionListener actionListener) {
        this.enableLockContentionButton.removeActionListener(actionListener);
    }

    private String getTimeInMillis(LockCCTNode lockCCTNode) {
        long l = lockCCTNode.getTime() / this.countsInMicrosec;
        return StringUtils.mcsTimeToString((long)l);
    }

    private void initColumnsData() {
        this.columnCount = 4;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = LOCKS_THREADS_COLUMN_NAME;
        this.columnToolTips[0] = LOCKS_THREADS_COLUMN_TOOLTIP;
        this.columnNames[1] = TIME_COLUMN_NAME;
        this.columnToolTips[1] = TIME_COLUMN_TOOLTIP;
        this.columnNames[2] = TIME_REL_COLUMN_NAME;
        this.columnToolTips[2] = TIME_REL_COLUMN_TOOLTIP;
        this.columnNames[3] = WAITS_COLUMN_NAME;
        this.columnToolTips[3] = WAITS_COLUMN_TOOLTIP;
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = new CustomBarCellRenderer(0L, 100L);
        this.columnWidths[1] = n;
        this.columnRenderers[2] = new LabelBracketTableCellRenderer(11);
        this.columnWidths[2] = n;
        this.columnRenderers[3] = new LabelTableCellRenderer(11);
    }

    private void setColumnsData() {
        this.treeTable.setTreeCellRenderer(this.treeCellRenderer);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realTreeTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realTreeTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.treeTable != null) {
                jCheckBoxMenuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.pack();
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                LockContentionPanel.this.sortingColumn = LockContentionPanel.this.treeTable.getSortingColumn();
                int n2 = LockContentionPanel.this.treeTableModel.getRealColumn(LockContentionPanel.this.sortingColumn);
                boolean bl2 = LockContentionPanel.this.treeTableModel.isRealColumnVisible(n);
                if (bl2 && n == n2) {
                    LockContentionPanel.this.sortingColumn = LockContentionPanel.this.sortingColumn + 1 == LockContentionPanel.this.treeTableModel.getColumnCount() ? LockContentionPanel.this.sortingColumn - 1 : LockContentionPanel.this.sortingColumn + 1;
                    n2 = LockContentionPanel.this.treeTableModel.getRealColumn(LockContentionPanel.this.sortingColumn);
                    bl = true;
                }
                LockContentionPanel.this.treeTableModel.setRealColumnVisibility(n, !bl2);
                LockContentionPanel.this.treeTable.createDefaultColumnsFromModel();
                LockContentionPanel.this.treeTable.updateTreeTableHeader();
                LockContentionPanel.this.sortingColumn = LockContentionPanel.this.treeTableModel.getVirtualColumn(n2);
                if (bl) {
                    LockContentionPanel.this.sortingOrder = LockContentionPanel.this.treeTableModel.getInitialSorting(LockContentionPanel.this.sortingColumn);
                    LockContentionPanel.this.treeTableModel.sortByColumn(LockContentionPanel.this.sortingColumn, LockContentionPanel.this.sortingOrder);
                    LockContentionPanel.this.treeTable.updateTreeTable();
                }
                LockContentionPanel.this.treeTable.setSortingColumn(LockContentionPanel.this.sortingColumn);
                LockContentionPanel.this.treeTable.setSortingOrder(LockContentionPanel.this.sortingOrder);
                LockContentionPanel.this.treeTable.getTableHeader().repaint();
                LockContentionPanel.this.setColumnsData();
            }
        });
    }

    public Component getToolbar() {
        return this.toolbar.getComponent();
    }

    private int getSortBy(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    private void showTablePopup(Component component, int n, int n2) {
        this.tablePopup.show(component, n, n2);
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = LockContentionPanel.this.treeTable.getSelectedRow()) != -1) {
                Rectangle rectangle = LockContentionPanel.this.treeTable.getCellRect(n, 0, true);
                LockContentionPanel.this.showTablePopup(LockContentionPanel.this.treeTable, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        private void updateSelection(int n) {
            LockContentionPanel.this.treeTable.requestFocusInWindow();
            if (n != -1) {
                LockContentionPanel.this.treeTable.setRowSelectionInterval(n, n);
            } else {
                LockContentionPanel.this.treeTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = LockContentionPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                LockContentionPanel.this.showTablePopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = LockContentionPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                LockContentionPanel.this.showTablePopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class LocksTreeTableModel
    extends AbstractTreeTableModel {
        private LocksTreeTableModel() {
            super((CCTNode)LockCCTNode.EMPTY, true, LockContentionPanel.this.sortingColumn, LockContentionPanel.this.sortingOrder);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return LockContentionPanel.this.columnCount;
        }

        @Override
        public String getColumnName(int n) {
            return LockContentionPanel.this.columnNames[n];
        }

        @Override
        public String getColumnToolTipText(int n) {
            return LockContentionPanel.this.columnToolTips[n];
        }

        @Override
        public boolean getInitialSorting(int n) {
            return n == 0;
        }

        @Override
        public boolean isLeaf(Object object) {
            return ((LockCCTNode)object).getNChildren() == 0;
        }

        @Override
        public Object getValueAt(Object object, int n) {
            LockCCTNode lockCCTNode = (LockCCTNode)object;
            switch (n) {
                case 0: {
                    return lockCCTNode;
                }
                case 1: {
                    return lockCCTNode.getTimeInPerCent();
                }
                case 2: {
                    return LockContentionPanel.this.getTimeInMillis(lockCCTNode) + " ms (" + LockContentionPanel.this.percentFormat.format(lockCCTNode.getTimeInPerCent() / 100.0) + ")";
                }
                case 3: {
                    return lockCCTNode.getWaits();
                }
            }
            return null;
        }

        @Override
        public void sortByColumn(int n, boolean bl) {
            LockContentionPanel.this.sortingColumn = n;
            LockContentionPanel.this.sortingOrder = bl;
            LockCCTNode lockCCTNode = (LockCCTNode)this.root;
            lockCCTNode.sortChildren(LockContentionPanel.this.getSortBy(n), bl);
        }
    }

    private class Listener
    implements LockCCTProvider.Listener {
        private Listener() {
        }

        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
            if (!bl && runtimeCCTNode instanceof LockRuntimeCCTNode) {
                LockContentionPanel.this.root = (LockRuntimeCCTNode)runtimeCCTNode;
                LockContentionPanel.this.prepareResults();
            }
        }

        public void cctReset() {
        }
    }
}

