/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDGlyphSetWidget;
import org.netbeans.api.visual.vmd.VMDMinimizeAbility;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

public class VMDNodeWidget
extends Widget
implements StateModel.Listener,
VMDMinimizeAbility {
    private Widget header;
    private ImageWidget minimizeWidget;
    private ImageWidget imageWidget;
    private LabelWidget nameWidget;
    private LabelWidget typeWidget;
    private VMDGlyphSetWidget glyphSetWidget;
    private SeparatorWidget pinsSeparator;
    private HashMap<String, Widget> pinCategoryWidgets = new HashMap();
    private StateModel stateModel = new StateModel(2);
    private Anchor nodeAnchor;
    private VMDColorScheme scheme;
    private WeakHashMap<Anchor, Anchor> proxyAnchorCache = new WeakHashMap();

    public VMDNodeWidget(Scene scene) {
        this(scene, VMDFactory.getOriginalScheme());
    }

    public VMDNodeWidget(Scene scene, VMDColorScheme vMDColorScheme) {
        super(scene);
        Widget widget;
        assert (vMDColorScheme != null);
        this.scheme = vMDColorScheme;
        this.nodeAnchor = new VMDNodeAnchor(this, true, vMDColorScheme);
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setMinimumSize(new Dimension(128, 8));
        this.header = new Widget(scene);
        this.header.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.CENTER, 8));
        this.addChild(this.header);
        boolean bl = vMDColorScheme.isNodeMinimizeButtonOnRight(this);
        this.minimizeWidget = new ImageWidget(scene, vMDColorScheme.getMinimizeWidgetImage(this));
        this.minimizeWidget.setCursor(Cursor.getPredefinedCursor(12));
        this.minimizeWidget.getActions().addAction(new ToggleMinimizedAction());
        if (!bl) {
            this.header.addChild(this.minimizeWidget);
        }
        this.imageWidget = new ImageWidget(scene);
        this.header.addChild(this.imageWidget);
        this.nameWidget = new LabelWidget(scene);
        this.nameWidget.setFont(scene.getDefaultFont().deriveFont(1));
        this.header.addChild(this.nameWidget);
        this.typeWidget = new LabelWidget(scene);
        this.typeWidget.setForeground(Color.BLACK);
        this.header.addChild(this.typeWidget);
        this.glyphSetWidget = new VMDGlyphSetWidget(scene);
        this.header.addChild(this.glyphSetWidget);
        if (bl) {
            widget = new Widget(scene);
            widget.setOpaque(false);
            this.header.addChild(widget, 1000);
            this.header.addChild(this.minimizeWidget);
        }
        this.pinsSeparator = new SeparatorWidget(scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.addChild(this.pinsSeparator);
        widget = new Widget(scene);
        this.addChild(widget);
        this.stateModel = new StateModel();
        this.stateModel.addListener(this);
        vMDColorScheme.installUI(this);
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    protected boolean isMinimizableWidget(Widget widget) {
        return true;
    }

    public boolean isMinimized() {
        return this.stateModel.getBooleanState();
    }

    public void setMinimized(boolean bl) {
        this.stateModel.setBooleanState(bl);
    }

    public void toggleMinimized() {
        this.stateModel.toggleBooleanState();
    }

    @Override
    public void stateChanged() {
        boolean bl = this.stateModel.getBooleanState();
        Rectangle rectangle = bl ? new Rectangle() : null;
        for (Widget widget : this.getChildren()) {
            if (widget == this.header || widget == this.pinsSeparator) continue;
            this.getScene().getSceneAnimator().animatePreferredBounds(widget, bl && this.isMinimizableWidget(widget) ? rectangle : null);
        }
        this.minimizeWidget.setImage(this.scheme.getMinimizeWidgetImage(this));
    }

    @Override
    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        this.scheme.updateUI(this, objectState, objectState2);
    }

    public void setNodeImage(Image image) {
        this.imageWidget.setImage(image);
        this.revalidate();
    }

    public String getNodeName() {
        return this.nameWidget.getLabel();
    }

    public void setNodeName(String string) {
        this.nameWidget.setLabel(string);
    }

    public void setNodeType(String string) {
        this.typeWidget.setLabel(string != null ? "[" + string + "]" : null);
    }

    public void attachPinWidget(Widget widget) {
        widget.setCheckClipping(true);
        this.addChild(widget);
        if (this.stateModel.getBooleanState() && this.isMinimizableWidget(widget)) {
            widget.setPreferredBounds(new Rectangle());
        }
    }

    public void setGlyphs(List<Image> list) {
        this.glyphSetWidget.setGlyphs(list);
    }

    public void setNodeProperties(Image image, String string, String string2, List<Image> list) {
        this.setNodeImage(image);
        this.setNodeName(string);
        this.setNodeType(string2);
        this.setGlyphs(list);
    }

    public LabelWidget getNodeNameWidget() {
        return this.nameWidget;
    }

    public Anchor getNodeAnchor() {
        return this.nodeAnchor;
    }

    public Anchor createAnchorPin(Anchor anchor) {
        Anchor anchor2 = this.proxyAnchorCache.get(anchor);
        if (anchor2 == null) {
            anchor2 = AnchorFactory.createProxyAnchor(this.stateModel, anchor, this.nodeAnchor);
            this.proxyAnchorCache.put(anchor, anchor2);
        }
        return anchor2;
    }

    private List<Widget> getPinWidgets() {
        ArrayList<Widget> arrayList = new ArrayList<Widget>(this.getChildren());
        arrayList.remove(this.header);
        arrayList.remove(this.pinsSeparator);
        return arrayList;
    }

    public void sortPins(HashMap<String, List<Widget>> hashMap) {
        String string;
        Object object;
        List<Widget> list = this.getPinWidgets();
        ArrayList<Widget> arrayList = new ArrayList<Widget>(list);
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!this.pinCategoryWidgets.containsValue(object)) continue;
            object2.remove();
        }
        object2 = new ArrayList<String>(this.pinCategoryWidgets.keySet());
        object = new ArrayList<String>(hashMap.keySet());
        Collections.sort(object);
        ArrayList<Widget> arrayList2 = new ArrayList<Widget>();
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string == null) continue;
            ((ArrayList)object2).remove(string);
            arrayList2.add(this.createPinCategoryWidget(string));
            List<Widget> list2 = hashMap.get(string);
            for (Widget widget : list2) {
                if (!arrayList.remove(widget)) continue;
                arrayList2.add(widget);
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList2.addAll(0, arrayList);
        }
        iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.pinCategoryWidgets.remove(string);
        }
        this.removeChildren(list);
        this.addChildren(arrayList2);
    }

    private Widget createPinCategoryWidget(String string) {
        Widget widget = this.pinCategoryWidgets.get(string);
        if (widget != null) {
            return widget;
        }
        Widget widget2 = this.scheme.createPinCategoryWidget(this, string);
        if (this.stateModel.getBooleanState()) {
            widget2.setPreferredBounds(new Rectangle());
        }
        this.pinCategoryWidgets.put(string, widget2);
        return widget2;
    }

    @Override
    public void collapseWidget() {
        this.stateModel.setBooleanState(true);
    }

    @Override
    public void expandWidget() {
        this.stateModel.setBooleanState(false);
    }

    public Widget getHeader() {
        return this.header;
    }

    public Widget getMinimizeButton() {
        return this.minimizeWidget;
    }

    public Widget getPinsSeparator() {
        return this.pinsSeparator;
    }

    private final class ToggleMinimizedAction
    extends WidgetAction.Adapter {
        private ToggleMinimizedAction() {
        }

        @Override
        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            if (widgetMouseEvent.getButton() == 1 || widgetMouseEvent.getButton() == 2) {
                VMDNodeWidget.this.stateModel.toggleBooleanState();
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }
    }
}

