/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.common.Function;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

public class AsyncService {
    private final ExecutorService service = Executors.newSingleThreadExecutor();

    public <P, T> Future<T> submit(final Callable<P> job, final Function<T, ? super P> uiUpdateJob) {
        return this.service.submit(new Callable<T>(){
            private T returnValue;

            @Override
            public T call() throws Exception {
                final Object p = job.call();
                DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            returnValue = uiUpdateJob.call(p);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return this.returnValue;
            }
        });
    }

    public <P, T> void submit(final Runnable job, final Runnable uiUpdateJob) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                job.run();
                DisplayToolkit.safeAsyncExec((Runnable)uiUpdateJob);
            }
        };
        try {
            this.service.submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        catch (NullPointerException e) {
            task.run();
        }
    }
}

