/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.view.toolbar.ContextsWriter;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportHelpContextsAction
extends Action {
    private final UserInterfaceContribution m_userInterfaceContribution;

    public ExportHelpContextsAction(UserInterfaceContribution uic) {
        super(Messages.EXPORT_HELP_CONTEXTS_ACTION_NAME);
        this.m_userInterfaceContribution = uic;
    }

    public void run() {
        InputDialog id;
        Shell shell = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText(Messages.EXPORT_HELP_CONTEXTS_ACTION_FILE_DIALOG_TEXT);
        fd.setFileName("contexts.xml");
        String result = fd.open();
        if (result != null && (id = new InputDialog(shell, Messages.EXPORT_HELP_CONTEXTS_ACTION_BUNDLE_SELECTION_TITLE, Messages.EXPORT_HELP_CONTEXTS_ACTION_BUNDLE_SELECTION_TEXT, "com.jrockit.mc.myplugin", null)).open() == 0) {
            ExportHelpContextsAction.write(this.m_userInterfaceContribution, new File(result), id.getValue());
        }
    }

    private static void write(UserInterfaceContribution uic, File file, String pluginId) {
        ContextsWriter cw = null;
        try {
            try {
                cw = new ContextsWriter(file, pluginId);
                cw.write(uic);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(cw);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)cw);
    }
}

