/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.view.DesignView;
import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public final class DesignModeAction
extends Action {
    private static final ImageDescriptor PLAY = UIPlugin.getDefault().getMCImageDescriptor("play.gif");
    private static final ImageDescriptor STOP = UIPlugin.getDefault().getMCImageDescriptor("stop.gif");
    private final DesignView view;
    private DesignerTab tab;

    public DesignModeAction(DesignView view) {
        super("Design Mode On/Off");
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("play.gif"));
        this.view = view;
        this.update();
    }

    public void run() {
        if (this.tab != null) {
            this.tab.setDesignMode(!this.tab.isInDesignMode());
            this.view.showPageForTab(this.tab);
            this.update();
        }
    }

    public void setTab(DesignerTab tab) {
        this.tab = tab;
        this.update();
    }

    private void update() {
        this.setEnabled(this.tab != null);
        this.setImageDescriptor(this.tab != null && this.tab.isInDesignMode() ? PLAY : STOP);
        this.setToolTipText(this.getTooltip());
    }

    private String getTooltip() {
        if (this.tab == null) {
            return "An editor supporting design mode must be active";
        }
        if (this.tab.isInDesignMode()) {
            return "Save the design for the '" + this.tab.getTitle() + "' tab and exit design mode";
        }
        return "Open the '" + this.tab.getTitle() + "' tab in design mode";
    }
}

