/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.components;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public final class ComponentTypeDescriptorCategory {
    private final String m_name;
    private final String m_identifier;
    private final String m_imageIdentifier;
    private final List<ComponentTypeDescriptor> m_children = new ArrayList<ComponentTypeDescriptor>();

    ComponentTypeDescriptorCategory(String name, String identifier, String iconIdentifier) {
        this.m_name = name;
        this.m_identifier = identifier;
        this.m_imageIdentifier = iconIdentifier;
    }

    public String getName() {
        return this.m_name;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public Image getIcon() {
        return ComponentsPlugin.getDefault().getImage(this.m_imageIdentifier);
    }

    public ImageDescriptor getImageDescriptor() {
        return ComponentsPlugin.getDefault().getMCImageDescriptor(this.m_imageIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentTypeDescriptor> getComponentTypeDescriptors() {
        List<ComponentTypeDescriptor> list = this.m_children;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<ComponentTypeDescriptor>(this.m_children));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addComponentTypeDescriptor(ComponentTypeDescriptor typeDescriptor) {
        List<ComponentTypeDescriptor> list = this.m_children;
        synchronized (list) {
            this.m_children.add(typeDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeComponentTypeDescriptor(ComponentTypeDescriptor typeDescriptor) {
        List<ComponentTypeDescriptor> list = this.m_children;
        synchronized (list) {
            this.m_children.add(typeDescriptor);
        }
    }

    public boolean isContainer() {
        return "container".equals(this.getIdentifier());
    }
}

