/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.threads;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import com.jrockit.mc.console.ui.tabs.threads.ThreadModelException;
import com.jrockit.mc.console.ui.tabs.threads.ThreadsModel;
import com.jrockit.mc.console.ui.tabs.threads.TraceMMXBeanMethodField;
import com.jrockit.mc.ui.fields.AbstractFieldTreeContentProvider;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class StackTraceContentProvider
extends AbstractFieldTreeContentProvider {
    public static final int FIELD_COUNT;
    public static final Field FIELD_STACK_TRACE;
    private final ThreadsModel m_threadsModel;

    static {
        FIELD_STACK_TRACE = new TraceMMXBeanMethodField(0);
        FIELD_COUNT = 1;
        FieldToolkit.initializeFields((String)"com.jrockit.mc.console.ui.messages.internal.fields", StackTraceContentProvider.class);
    }

    public StackTraceContentProvider(ThreadsModel threadsModel) {
        this.m_threadsModel = threadsModel;
    }

    public Object[] getRowChildren(Object parentElement) {
        if (parentElement instanceof IStructuredSelection) {
            return this.getElements(parentElement);
        }
        if (parentElement instanceof ThreadInfoCompositeSupport) {
            return ((ThreadInfoCompositeSupport)parentElement).getStackTrace();
        }
        return new Object[0];
    }

    public static long[] extractThreadIDsFromSelection(IStructuredSelection selection) {
        ArrayList<Long> threadIDs = new ArrayList<Long>();
        for (ThreadInfoCompositeSupport tics : selection) {
            Long id = tics.getThreadId();
            if (id == null) continue;
            threadIDs.add(id);
        }
        long[] threadIDArray = new long[threadIDs.size()];
        int n = 0;
        while (n < threadIDArray.length) {
            threadIDArray[n] = (Long)threadIDs.get(n);
            ++n;
        }
        return threadIDArray;
    }

    public Object[] getRowElements(Object inputElement) {
        if (inputElement instanceof IStructuredSelection) {
            long[] threadIDArray = StackTraceContentProvider.extractThreadIDsFromSelection((IStructuredSelection)inputElement);
            try {
                return this.m_threadsModel.getThreadInfo(threadIDArray, Integer.MAX_VALUE);
            }
            catch (ThreadModelException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE, e);
            }
        }
        return new Object[0];
    }

    protected Object[] getColumnObject(Object object) {
        Object[] result = new Object[FIELD_COUNT];
        result[StackTraceContentProvider.FIELD_STACK_TRACE.INDEX] = object;
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected boolean hasRowChildren(Object element) {
        return this.getRowChildren(element).length > 0;
    }
}

