/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.DynamicLinker;
import jdk.internal.dynalink.DynamicLinkerFactory;
import jdk.internal.dynalink.beans.BeansLinker;
import jdk.internal.dynalink.beans.StaticClass;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.RuntimeCallSite;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.BoundDynamicMethod;
import jdk.nashorn.internal.runtime.linker.BoundDynamicMethodLinker;
import jdk.nashorn.internal.runtime.linker.JSObjectLinker;
import jdk.nashorn.internal.runtime.linker.JavaSuperAdapter;
import jdk.nashorn.internal.runtime.linker.JavaSuperAdapterLinker;
import jdk.nashorn.internal.runtime.linker.LinkerCallSite;
import jdk.nashorn.internal.runtime.linker.NashornBeansLinker;
import jdk.nashorn.internal.runtime.linker.NashornBottomLinker;
import jdk.nashorn.internal.runtime.linker.NashornLinker;
import jdk.nashorn.internal.runtime.linker.NashornPrimitiveLinker;
import jdk.nashorn.internal.runtime.linker.NashornStaticClassLinker;
import jdk.nashorn.internal.runtime.linker.ReflectionCheckLinker;
import jdk.nashorn.internal.runtime.options.Options;

public final class Bootstrap {
    public static final CompilerConstants.Call BOOTSTRAP = CompilerConstants.staticCallNoLookup(Bootstrap.class, "bootstrap", CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE);
    private static final DynamicLinker dynamicLinker;

    private Bootstrap() {
    }

    public static boolean isCallable(Object obj) {
        if (obj == ScriptRuntime.UNDEFINED || obj == null) {
            return false;
        }
        return obj instanceof ScriptFunction || obj instanceof JSObject && ((JSObject)obj).isFunction() || Bootstrap.isDynamicMethod(obj) || Bootstrap.isFunctionalInterfaceObject(obj) || obj instanceof StaticClass;
    }

    public static boolean isDynamicMethod(Object obj) {
        return obj instanceof BoundDynamicMethod || BeansLinker.isDynamicMethod(obj);
    }

    public static boolean isFunctionalInterfaceObject(Object obj) {
        return !JSType.isPrimitive(obj) && NashornBottomLinker.getFunctionalInterfaceMethod(obj.getClass()) != null;
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String opDesc, MethodType type, int flags) {
        return dynamicLinker.link(LinkerCallSite.newLinkerCallSite(lookup, opDesc, type, flags));
    }

    public static CallSite runtimeBootstrap(MethodHandles.Lookup lookup, String initialName, MethodType type) {
        return new RuntimeCallSite(type, initialName);
    }

    public static MethodHandle createDynamicInvoker(String opDesc, Class<?> rtype, Class<?> ... ptypes) {
        return Bootstrap.createDynamicInvoker(opDesc, MethodType.methodType(rtype, ptypes));
    }

    public static MethodHandle createDynamicInvoker(String opDesc, MethodType type) {
        return Bootstrap.bootstrap(MethodHandles.publicLookup(), opDesc, type, 0).dynamicInvoker();
    }

    public static Object bindDynamicMethod(Object dynamicMethod, Object boundThis) {
        return new BoundDynamicMethod(dynamicMethod, boundThis);
    }

    public static Object createSuperAdapter(Object adapter) {
        return new JavaSuperAdapter(adapter);
    }

    public static void checkReflectionAccess(Class<?> clazz, boolean isStatic) {
        ReflectionCheckLinker.checkReflectionAccess(clazz, isStatic);
    }

    public static LinkerServices getLinkerServices() {
        return dynamicLinker.getLinkerServices();
    }

    static GuardedInvocation asType(GuardedInvocation inv, LinkerServices linkerServices, CallSiteDescriptor desc) {
        return inv == null ? null : inv.asType(linkerServices, desc.getMethodType());
    }

    static {
        DynamicLinkerFactory factory = new DynamicLinkerFactory();
        NashornBeansLinker nashornBeansLinker = new NashornBeansLinker();
        JSObjectLinker jsObjectLinker = new JSObjectLinker(nashornBeansLinker);
        factory.setPrioritizedLinkers(new NashornLinker(), new NashornPrimitiveLinker(), new NashornStaticClassLinker(), new BoundDynamicMethodLinker(), new JavaSuperAdapterLinker(), jsObjectLinker, new ReflectionCheckLinker());
        factory.setFallbackLinkers(nashornBeansLinker, new NashornBottomLinker());
        factory.setSyncOnRelink(true);
        int relinkThreshold = Options.getIntProperty("nashorn.unstable.relink.threshold", -1);
        if (relinkThreshold > -1) {
            factory.setUnstableRelinkThreshold(relinkThreshold);
        }
        factory.setClassLoader(Bootstrap.class.getClassLoader());
        dynamicLinker = factory.createLinker();
    }
}

