/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.arrays.ByteBufferArrayData;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.FrozenArrayFilter;
import jdk.nashorn.internal.runtime.arrays.IntArrayData;
import jdk.nashorn.internal.runtime.arrays.LongArrayData;
import jdk.nashorn.internal.runtime.arrays.NoTypeArrayData;
import jdk.nashorn.internal.runtime.arrays.NumberArrayData;
import jdk.nashorn.internal.runtime.arrays.ObjectArrayData;
import jdk.nashorn.internal.runtime.arrays.SealedArrayFilter;
import jdk.nashorn.internal.runtime.arrays.SparseArrayData;

public abstract class ArrayData {
    protected static final int CHUNK_SIZE = 16;
    protected static final int CHUNK_MASK = 15;
    public static final ArrayData EMPTY_ARRAY = new NoTypeArrayData();
    private long length;

    protected ArrayData(long length) {
        this.length = length;
    }

    public static ArrayData initialArray() {
        return new IntArrayData();
    }

    public static ArrayData allocate(int length) {
        if (length == 0) {
            return new IntArrayData();
        }
        if ((long)length >= 524288L) {
            return new SparseArrayData(EMPTY_ARRAY, length);
        }
        return new DeletedRangeArrayFilter(new IntArrayData(length), 0L, length - 1);
    }

    public static ArrayData allocate(Object array) {
        Class<?> clazz = array.getClass();
        if (clazz == int[].class) {
            return new IntArrayData((int[])array, ((int[])array).length);
        }
        if (clazz == long[].class) {
            return new LongArrayData((long[])array, ((long[])array).length);
        }
        if (clazz == double[].class) {
            return new NumberArrayData((double[])array, ((double[])array).length);
        }
        return new ObjectArrayData((Object[])array, ((Object[])array).length);
    }

    public static ArrayData allocate(int[] array) {
        return new IntArrayData(array, array.length);
    }

    public static ArrayData allocate(long[] array) {
        return new LongArrayData(array, array.length);
    }

    public static ArrayData allocate(double[] array) {
        return new NumberArrayData(array, array.length);
    }

    public static ArrayData allocate(Object[] array) {
        return new ObjectArrayData(array, array.length);
    }

    public static ArrayData allocate(ByteBuffer buf) {
        return new ByteBufferArrayData(buf);
    }

    public static ArrayData freeze(ArrayData underlying) {
        return new FrozenArrayFilter(underlying);
    }

    public static ArrayData seal(ArrayData underlying) {
        return new SealedArrayFilter(underlying);
    }

    public final long length() {
        return this.length;
    }

    public abstract ArrayData copy();

    public abstract Object[] asObjectArray();

    public Object asArrayOfType(Class<?> componentType) {
        return JSType.convertArray(this.asObjectArray(), componentType);
    }

    public void setLength(long length) {
        this.length = length;
    }

    public abstract void shiftLeft(int var1);

    public abstract ArrayData shiftRight(int var1);

    public abstract ArrayData ensure(long var1);

    public abstract ArrayData shrink(long var1);

    public abstract ArrayData set(int var1, Object var2, boolean var3);

    public abstract ArrayData set(int var1, int var2, boolean var3);

    public abstract ArrayData set(int var1, long var2, boolean var4);

    public abstract ArrayData set(int var1, double var2, boolean var4);

    public ArrayData setEmpty(int index) {
        return this;
    }

    public ArrayData setEmpty(long lo, long hi) {
        return this;
    }

    public abstract int getInt(int var1);

    public abstract long getLong(int var1);

    public abstract double getDouble(int var1);

    public abstract Object getObject(int var1);

    public abstract boolean has(int var1);

    public boolean canDelete(int index, boolean strict) {
        return true;
    }

    public boolean canDelete(long fromIndex, long toIndex, boolean strict) {
        return true;
    }

    public PropertyDescriptor getDescriptor(Global global, int index) {
        return global.newDataDescriptor(this.getObject(index), true, true, true);
    }

    public abstract ArrayData delete(int var1);

    public abstract ArrayData delete(long var1, long var3);

    protected abstract ArrayData convert(Class<?> var1);

    public ArrayData push(boolean strict, Object ... items) {
        if (items.length == 0) {
            return this;
        }
        Class<?> widest = ArrayData.widestType(items);
        ArrayData newData = this.convert(widest);
        long pos = newData.length();
        for (Object item : items) {
            newData = newData.ensure(pos);
            newData.set((int)pos++, item, strict);
        }
        return newData;
    }

    public abstract Object pop();

    public abstract ArrayData slice(long var1, long var3);

    public ArrayData fastSplice(int start, int removed, int added) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    static Class<?> widestType(Object ... items) {
        assert (items.length > 0);
        Class widest = Integer.class;
        for (Object item : items) {
            Class<?> itemClass;
            Class<?> clazz = itemClass = item == null ? null : item.getClass();
            if (itemClass == Long.class) {
                if (widest != Integer.class) continue;
                widest = Long.class;
                continue;
            }
            if (itemClass == Double.class) {
                if (widest != Integer.class && widest != Long.class) continue;
                widest = Double.class;
                continue;
            }
            if (item instanceof Number) continue;
            widest = Object.class;
            break;
        }
        return widest;
    }

    protected static int nextSize(int size) {
        if (size == 0) {
            return 16;
        }
        int i = size;
        while ((i & 0xF) != 0) {
            ++i;
        }
        return i << 1;
    }

    public long nextIndex(long index) {
        return index + 1L;
    }

    static Object invoke(MethodHandle mh, Object arg) {
        try {
            return mh.invoke(arg);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

