/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import jdk.internal.dynalink.support.NameCodec;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.FunctionSignature;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.CompiledFunction;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.ScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.scripts.JS;

public final class RecompilableScriptFunctionData
extends ScriptFunctionData
implements Serializable {
    private transient FunctionNode functionNode;
    private transient Source source;
    private final int lineNumber;
    private MethodLocator methodLocator;
    private final long token;
    private final PropertyMap allocatorMap;
    private transient CodeInstaller<ScriptEnvironment> installer;
    private final String allocatorClassName;
    private transient MethodHandle allocator;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle PARAM_TYPE_GUARD = RecompilableScriptFunctionData.findOwnMH("paramTypeGuard", Boolean.TYPE, Type[].class, Object[].class);
    private static final MethodHandle ENSURE_INT = RecompilableScriptFunctionData.findOwnMH("ensureInt", Integer.TYPE, Object.class);
    private static final long serialVersionUID = 4914839316174633726L;

    public RecompilableScriptFunctionData(FunctionNode functionNode, CodeInstaller<ScriptEnvironment> installer, String allocatorClassName, PropertyMap allocatorMap) {
        super(RecompilableScriptFunctionData.functionName(functionNode), functionNode.getParameters().size(), RecompilableScriptFunctionData.getFlags(functionNode));
        this.functionNode = functionNode;
        this.source = functionNode.getSource();
        this.lineNumber = functionNode.getLineNumber();
        this.token = RecompilableScriptFunctionData.tokenFor(functionNode);
        this.installer = installer;
        this.allocatorClassName = allocatorClassName;
        this.allocatorMap = allocatorMap;
        if (!functionNode.isLazy()) {
            this.methodLocator = new MethodLocator(functionNode);
        }
    }

    @Override
    String toSource() {
        if (this.source != null && this.token != 0L) {
            return this.source.getString(Token.descPosition(this.token), Token.descLength(this.token));
        }
        return "function " + (this.name == null ? "" : this.name) + "() { [native code] }";
    }

    public void setCodeAndSource(Map<String, Class<?>> code, Source source) {
        this.source = source;
        if (this.methodLocator != null) {
            this.methodLocator.setClass(code.get(this.methodLocator.getClassName()));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.source != null) {
            sb.append(this.source.getName()).append(':').append(this.lineNumber).append(' ');
        }
        return sb.toString() + super.toString();
    }

    private static String functionName(FunctionNode fn) {
        if (fn.isAnonymous()) {
            return "";
        }
        FunctionNode.Kind kind = fn.getKind();
        if (kind == FunctionNode.Kind.GETTER || kind == FunctionNode.Kind.SETTER) {
            String name = NameCodec.decode(fn.getIdent().getName());
            return name.substring(4);
        }
        return fn.getIdent().getName();
    }

    private static long tokenFor(FunctionNode fn) {
        int position = Token.descPosition(fn.getFirstToken());
        int length = Token.descPosition(fn.getLastToken()) - position + Token.descLength(fn.getLastToken());
        return Token.toDesc(TokenType.FUNCTION, position, length);
    }

    private static int getFlags(FunctionNode functionNode) {
        int flags = 4;
        if (functionNode.isStrict()) {
            flags |= 1;
        }
        if (functionNode.needsCallee()) {
            flags |= 8;
        }
        if (functionNode.usesThis() || functionNode.hasEval()) {
            flags |= 0x10;
        }
        return flags;
    }

    @Override
    ScriptObject allocate(PropertyMap map) {
        try {
            this.ensureHasAllocator();
            return this.allocator == null ? null : this.allocator.invokeExact(map);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void ensureHasAllocator() throws ClassNotFoundException {
        if (this.allocator == null && this.allocatorClassName != null) {
            this.allocator = Lookup.MH.findStatic(LOOKUP, Context.forStructureClass(this.allocatorClassName), CompilerConstants.ALLOCATE.symbolName(), Lookup.MH.type(ScriptObject.class, PropertyMap.class));
        }
    }

    @Override
    PropertyMap getAllocatorMap() {
        return this.allocatorMap;
    }

    @Override
    protected void ensureCompiled() {
        if (this.functionNode != null && this.functionNode.isLazy()) {
            Compiler.LOG.info("Trampoline hit: need to do lazy compilation of '", this.functionNode.getName(), "'");
            Compiler compiler = new Compiler(this.installer);
            this.functionNode = compiler.compile(this.functionNode);
            assert (!this.functionNode.isLazy());
            compiler.install(this.functionNode);
            this.methodLocator = new MethodLocator(this.functionNode);
            this.flags = RecompilableScriptFunctionData.getFlags(this.functionNode);
        }
        if (this.functionNode != null) {
            this.methodLocator.setClass(this.functionNode.getCompileUnit().getCode());
        }
    }

    @Override
    protected synchronized void ensureCodeGenerated() {
        if (!this.code.isEmpty()) {
            return;
        }
        this.ensureCompiled();
        assert (this.functionNode == null || this.functionNode.hasState(FunctionNode.CompilationState.EMITTED)) : this.functionNode.getName() + " " + this.functionNode.getState() + " " + Debug.id(this.functionNode);
        this.addCode(this.functionNode);
        if (this.functionNode != null && !this.functionNode.canSpecialize()) {
            this.functionNode = null;
            this.installer = null;
        }
    }

    private MethodHandle addCode(FunctionNode fn) {
        return this.addCode(fn, null, null, null);
    }

    private MethodHandle addCode(FunctionNode fn, MethodType runtimeType, MethodHandle guard, MethodHandle fallback) {
        assert (this.methodLocator != null);
        MethodHandle target = this.methodLocator.getMethodHandle();
        MethodType targetType = this.methodLocator.getMethodType();
        for (int i = 0; i < targetType.parameterCount(); ++i) {
            if (targetType.parameterType(i) != Integer.TYPE) continue;
            target = Lookup.MH.filterArguments(target, i, ENSURE_INT);
        }
        MethodHandle mh = target;
        if (guard != null) {
            mh = Lookup.MH.guardWithTest(Lookup.MH.asCollector(guard, Object[].class, target.type().parameterCount()), Lookup.MH.asType(target, fallback.type()), fallback);
        }
        CompiledFunction cf = new CompiledFunction(runtimeType == null ? targetType : runtimeType, mh);
        this.code.add(cf);
        return cf.getInvoker();
    }

    private static Type runtimeType(Object arg) {
        if (arg == null) {
            return Type.OBJECT;
        }
        Class<?> clazz = arg.getClass();
        assert (!clazz.isPrimitive()) : "always boxed";
        if (clazz == Double.class) {
            return JSType.isRepresentableAsInt((Double)arg) ? Type.INT : Type.NUMBER;
        }
        if (clazz == Integer.class) {
            return Type.INT;
        }
        if (clazz == Long.class) {
            return Type.LONG;
        }
        if (clazz == String.class) {
            return Type.STRING;
        }
        return Type.OBJECT;
    }

    private static boolean canCoerce(Object arg, Type type) {
        Type argType = RecompilableScriptFunctionData.runtimeType(arg);
        if (Type.widest(argType, type) == type || arg == ScriptRuntime.UNDEFINED) {
            return true;
        }
        System.err.println(arg + " does not fit in " + argType + " " + type + " " + arg.getClass());
        new Throwable().printStackTrace();
        return false;
    }

    private static boolean paramTypeGuard(Type[] paramTypes, Object ... args) {
        int start;
        int length = args.length;
        assert (args.length >= paramTypes.length);
        for (int i = start = args.length - paramTypes.length; i < args.length; ++i) {
            Object arg = args[i];
            if (RecompilableScriptFunctionData.canCoerce(arg, paramTypes[i - start])) continue;
            return false;
        }
        return true;
    }

    private static int ensureInt(Object arg) {
        if (arg instanceof Number) {
            return ((Number)arg).intValue();
        }
        if (arg instanceof Undefined) {
            return 0;
        }
        throw new AssertionError(arg);
    }

    private static MethodType runtimeType(MethodType callSiteType, Object[] args) {
        int start;
        if (args == null) {
            return callSiteType;
        }
        Class[] paramTypes = new Class[callSiteType.parameterCount()];
        for (int i = start = args.length - callSiteType.parameterCount(); i < args.length; ++i) {
            paramTypes[i - start] = RecompilableScriptFunctionData.runtimeType(args[i]).getTypeClass();
        }
        return Lookup.MH.type((Class<?>)callSiteType.returnType(), paramTypes);
    }

    private static ArrayList<Type> runtimeType(MethodType mt) {
        ArrayList<Type> type = new ArrayList<Type>();
        for (int i = 0; i < mt.parameterCount(); ++i) {
            type.add(Type.typeFor(mt.parameterType(i)));
        }
        return type;
    }

    @Override
    synchronized MethodHandle getBestInvoker(MethodType callSiteType, Object[] args) {
        int i;
        MethodType runtimeType = RecompilableScriptFunctionData.runtimeType(callSiteType, args);
        assert (runtimeType.parameterCount() == callSiteType.parameterCount());
        MethodHandle mh = super.getBestInvoker(runtimeType, args);
        if (this.functionNode == null || !this.functionNode.canSpecialize()) {
            return mh;
        }
        if (!this.code.isLessSpecificThan(runtimeType)) {
            return mh;
        }
        FunctionNode snapshot = this.functionNode.getSnapshot();
        assert (snapshot != null);
        LinkedList<Type> compileTimeArgs = new LinkedList<Type>();
        for (i = callSiteType.parameterCount() - 1; i >= 0 && compileTimeArgs.size() < snapshot.getParameters().size(); --i) {
            compileTimeArgs.addFirst(Type.typeFor(callSiteType.parameterType(i)));
        }
        MethodHandle guard = null;
        ArrayList<Type> runtimeParamTypes = RecompilableScriptFunctionData.runtimeType(runtimeType);
        while (runtimeParamTypes.size() > this.functionNode.getParameters().size()) {
            runtimeParamTypes.remove(0);
        }
        for (i = 0; i < compileTimeArgs.size(); ++i) {
            Type rparam = Type.typeFor(runtimeType.parameterType(i));
            Type cparam = (Type)compileTimeArgs.get(i);
            if (!cparam.isObject() || rparam.isObject() || guard != null) continue;
            guard = Lookup.MH.insertArguments(PARAM_TYPE_GUARD, 0, new Object[]{runtimeParamTypes.toArray(new Type[runtimeParamTypes.size()])});
        }
        Compiler.LOG.info("Callsite specialized ", this.name, " runtimeType=", runtimeType, " parameters=", snapshot.getParameters(), " args=", Arrays.asList(args));
        assert (snapshot != this.functionNode);
        Compiler compiler = new Compiler(this.installer);
        FunctionNode compiledSnapshot = compiler.compile(snapshot.setHints(null, new Compiler.Hints(runtimeParamTypes.toArray(new Type[runtimeParamTypes.size()]))));
        compiler.install(compiledSnapshot);
        return this.addCode(compiledSnapshot, runtimeType, guard, mh);
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), RecompilableScriptFunctionData.class, name, Lookup.MH.type(rtype, types));
    }

    private static class MethodLocator
    implements Serializable {
        private transient Class<?> clazz;
        private final String className;
        private final String methodName;
        private final MethodType methodType;
        private static final long serialVersionUID = -5420835725902966692L;

        MethodLocator(FunctionNode functionNode) {
            this.className = functionNode.getCompileUnit().getUnitClassName();
            this.methodName = functionNode.getName();
            this.methodType = new FunctionSignature(functionNode).getMethodType();
            assert (this.className != null);
            assert (this.methodName != null);
        }

        void setClass(Class<?> clazz) {
            if (!JS.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
            this.clazz = clazz;
        }

        String getClassName() {
            return this.className;
        }

        MethodType getMethodType() {
            return this.methodType;
        }

        MethodHandle getMethodHandle() {
            return Lookup.MH.findStatic(LOOKUP, this.clazz, this.methodName, this.methodType);
        }
    }
}

