/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.SwitchPoint;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyHashMap;
import jdk.nashorn.internal.runtime.PropertyListeners;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.scripts.JO;

public final class PropertyMap
implements Iterable<Object>,
Serializable {
    public static final int NOT_EXTENSIBLE = 1;
    public static final int CONTAINS_ARRAY_KEYS = 2;
    private int flags;
    private transient PropertyHashMap properties;
    private int fieldCount;
    private int fieldMaximum;
    private int spillLength;
    private String className;
    private transient HashMap<String, SwitchPoint> protoGetSwitches;
    private transient WeakHashMap<Property, SoftReference<PropertyMap>> history;
    private transient WeakHashMap<PropertyMap, SoftReference<PropertyMap>> protoHistory;
    private transient PropertyListeners listeners;
    private static final long serialVersionUID = -7041836752008732533L;
    private static int count;
    private static int clonedCount;
    private static int duplicatedCount;
    private static int historyHit;
    private static int protoInvalidations;
    private static int protoHistoryHit;
    private static int setProtoNewMapCount;

    private PropertyMap(PropertyHashMap properties, String className, int fieldCount, int fieldMaximum, int spillLength, boolean containsArrayKeys) {
        this.properties = properties;
        this.className = className;
        this.fieldCount = fieldCount;
        this.fieldMaximum = fieldMaximum;
        this.spillLength = spillLength;
        if (containsArrayKeys) {
            this.setContainsArrayKeys();
        }
        if (Context.DEBUG) {
            ++count;
        }
    }

    private PropertyMap(PropertyMap propertyMap, PropertyHashMap properties) {
        this.properties = properties;
        this.flags = propertyMap.flags;
        this.spillLength = propertyMap.spillLength;
        this.fieldCount = propertyMap.fieldCount;
        this.fieldMaximum = propertyMap.fieldMaximum;
        this.listeners = propertyMap.listeners;
        if (Context.DEBUG) {
            ++count;
            ++clonedCount;
        }
    }

    private PropertyMap(PropertyMap propertyMap) {
        this(propertyMap, propertyMap.properties);
    }

    public PropertyMap duplicate() {
        if (Context.DEBUG) {
            ++duplicatedCount;
        }
        return new PropertyMap(this.properties, this.className, 0, 0, 0, this.containsArrayKeys());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.properties.getProperties());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Property[] props = (Property[])in.readObject();
        this.properties = PropertyHashMap.EMPTY_HASHMAP.immutableAdd(props);
        assert (this.className != null);
        Class<?> structure = Context.forStructureClass(this.className);
        for (Property prop : props) {
            prop.initMethodHandles(structure);
        }
    }

    public static PropertyMap newMap(Collection<Property> properties, String className, int fieldCount, int fieldMaximum, int spillLength) {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP.immutableAdd(properties);
        return new PropertyMap(newProperties, className, fieldCount, fieldMaximum, spillLength, false);
    }

    public static PropertyMap newMap(Collection<Property> properties) {
        return properties == null || properties.isEmpty() ? PropertyMap.newMap() : PropertyMap.newMap(properties, JO.class.getName(), 0, 0, 0);
    }

    public static PropertyMap newMap() {
        return new PropertyMap(PropertyHashMap.EMPTY_HASHMAP, JO.class.getName(), 0, 0, 0, false);
    }

    public int size() {
        return this.properties.size();
    }

    public PropertyListeners getListeners() {
        return this.listeners;
    }

    public void addListener(String key, PropertyMap listenerMap) {
        if (listenerMap != this) {
            this.listeners = PropertyListeners.addListener(this.listeners, key, listenerMap);
        }
    }

    public void propertyAdded(Property property) {
        this.invalidateProtoGetSwitchPoint(property);
        if (this.listeners != null) {
            this.listeners.propertyAdded(property);
        }
    }

    public void propertyDeleted(Property property) {
        this.invalidateProtoGetSwitchPoint(property);
        if (this.listeners != null) {
            this.listeners.propertyDeleted(property);
        }
    }

    public void propertyModified(Property oldProperty, Property newProperty) {
        this.invalidateProtoGetSwitchPoint(oldProperty);
        if (this.listeners != null) {
            this.listeners.propertyModified(oldProperty, newProperty);
        }
    }

    public void protoChanged() {
        this.invalidateAllProtoGetSwitchPoints();
        if (this.listeners != null) {
            this.listeners.protoChanged();
        }
    }

    public synchronized SwitchPoint getSwitchPoint(String key) {
        SwitchPoint switchPoint;
        if (this.protoGetSwitches == null) {
            this.protoGetSwitches = new HashMap();
        }
        if ((switchPoint = this.protoGetSwitches.get(key)) == null) {
            switchPoint = new SwitchPoint();
            this.protoGetSwitches.put(key, switchPoint);
        }
        return switchPoint;
    }

    synchronized void invalidateProtoGetSwitchPoint(Property property) {
        String key;
        SwitchPoint sp;
        if (this.protoGetSwitches != null && (sp = this.protoGetSwitches.get(key = property.getKey())) != null) {
            this.protoGetSwitches.remove(key);
            if (Context.DEBUG) {
                ++protoInvalidations;
            }
            SwitchPoint.invalidateAll(new SwitchPoint[]{sp});
        }
    }

    synchronized void invalidateAllProtoGetSwitchPoints() {
        if (this.protoGetSwitches != null && !this.protoGetSwitches.isEmpty()) {
            if (Context.DEBUG) {
                protoInvalidations += this.protoGetSwitches.size();
            }
            SwitchPoint.invalidateAll(this.protoGetSwitches.values().toArray(new SwitchPoint[this.protoGetSwitches.values().size()]));
            this.protoGetSwitches.clear();
        }
    }

    PropertyMap addPropertyBind(AccessorProperty property, Object bindTo) {
        return this.addPropertyNoHistory(new AccessorProperty(property, bindTo));
    }

    public PropertyMap addPropertyNoHistory(Property property) {
        if (this.listeners != null) {
            this.listeners.propertyAdded(property);
        }
        PropertyHashMap newProperties = this.properties.immutableAdd(property);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        if (!property.isSpill()) {
            newMap.fieldCount = Math.max(newMap.fieldCount, property.getSlot() + 1);
        }
        if (ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(property.getKey()))) {
            newMap.setContainsArrayKeys();
        }
        newMap.spillLength += property.getSpillCount();
        return newMap;
    }

    public PropertyMap addProperty(Property property) {
        PropertyMap newMap;
        if (this.listeners != null) {
            this.listeners.propertyAdded(property);
        }
        if ((newMap = this.checkHistory(property)) == null) {
            PropertyHashMap newProperties = this.properties.immutableAdd(property);
            newMap = new PropertyMap(this, newProperties);
            this.addToHistory(property, newMap);
            if (!property.isSpill()) {
                newMap.fieldCount = Math.max(newMap.fieldCount, property.getSlot() + 1);
            }
            if (ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(property.getKey()))) {
                newMap.setContainsArrayKeys();
            }
            newMap.spillLength += property.getSpillCount();
        }
        return newMap;
    }

    public PropertyMap deleteProperty(Property property) {
        if (this.listeners != null) {
            this.listeners.propertyDeleted(property);
        }
        PropertyMap newMap = this.checkHistory(property);
        String key = property.getKey();
        if (newMap == null && this.properties.containsKey(key)) {
            PropertyHashMap newProperties = this.properties.immutableRemove(key);
            newMap = new PropertyMap(this, newProperties);
            this.addToHistory(property, newMap);
        }
        return newMap;
    }

    PropertyMap replaceProperty(Property oldProperty, Property newProperty) {
        boolean sameType;
        if (this.listeners != null) {
            this.listeners.propertyModified(oldProperty, newProperty);
        }
        PropertyHashMap newProperties = this.properties.immutableAdd(newProperty);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        boolean bl = sameType = oldProperty.getClass() == newProperty.getClass();
        assert (sameType || oldProperty instanceof AccessorProperty && newProperty instanceof UserAccessorProperty) : "arbitrary replaceProperty attempted";
        newMap.flags = this.flags;
        newMap.spillLength = this.spillLength + (sameType ? 0 : newProperty.getSpillCount());
        return newMap;
    }

    public UserAccessorProperty newUserAccessors(String key, int propertyFlags) {
        int oldSpillLength = this.spillLength;
        int getterSlot = oldSpillLength++;
        int setterSlot = oldSpillLength++;
        return new UserAccessorProperty(key, propertyFlags, getterSlot, setterSlot);
    }

    public Property findProperty(String key) {
        return this.properties.find(key);
    }

    public PropertyMap addAll(PropertyMap other) {
        assert (this != other) : "adding property map to itself";
        Property[] otherProperties = other.properties.getProperties();
        PropertyHashMap newProperties = this.properties.immutableAdd(otherProperties);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        for (Property property : otherProperties) {
            if (ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(property.getKey()))) {
                newMap.setContainsArrayKeys();
            }
            newMap.spillLength += property.getSpillCount();
        }
        return newMap;
    }

    public Property[] getProperties() {
        return this.properties.getProperties();
    }

    PropertyMap preventExtensions() {
        PropertyMap newMap = new PropertyMap(this);
        newMap.flags |= 1;
        return newMap;
    }

    PropertyMap seal() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP;
        for (Property oldProperty : this.properties.getProperties()) {
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(4));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 1;
        return newMap;
    }

    PropertyMap freeze() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP;
        for (Property oldProperty : this.properties.getProperties()) {
            int propertyFlags = 4;
            if (!(oldProperty instanceof UserAccessorProperty)) {
                propertyFlags |= 1;
            }
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(propertyFlags));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 1;
        return newMap;
    }

    private boolean anyConfigurable() {
        for (Property property : this.properties.getProperties()) {
            if (!property.isConfigurable()) continue;
            return true;
        }
        return false;
    }

    private boolean allFrozen() {
        for (Property property : this.properties.getProperties()) {
            if (!(property instanceof UserAccessorProperty) && property.isWritable()) {
                return false;
            }
            if (!property.isConfigurable()) continue;
            return false;
        }
        return true;
    }

    private PropertyMap checkProtoHistory(PropertyMap parentMap) {
        SoftReference<PropertyMap> weakMap;
        PropertyMap cachedMap = this.protoHistory != null ? ((weakMap = this.protoHistory.get(parentMap)) != null ? weakMap.get() : null) : null;
        if (Context.DEBUG && cachedMap != null) {
            ++protoHistoryHit;
        }
        return cachedMap;
    }

    private void addToProtoHistory(PropertyMap parentMap, PropertyMap newMap) {
        if (this.protoHistory == null) {
            this.protoHistory = new WeakHashMap();
        }
        this.protoHistory.put(parentMap, new SoftReference<PropertyMap>(newMap));
    }

    private void addToHistory(Property property, PropertyMap newMap) {
        if (!this.properties.isEmpty()) {
            if (this.history == null) {
                this.history = new WeakHashMap();
            }
            this.history.put(property, new SoftReference<PropertyMap>(newMap));
        }
    }

    private PropertyMap checkHistory(Property property) {
        if (this.history != null) {
            PropertyMap historicMap;
            SoftReference<PropertyMap> ref = this.history.get(property);
            PropertyMap propertyMap = historicMap = ref == null ? null : ref.get();
            if (historicMap != null) {
                if (Context.DEBUG) {
                    ++historyHit;
                }
                return historicMap;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        boolean isFirst = true;
        for (Property property : this.properties.values()) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(ScriptRuntime.safeToString(property.getKey()));
            Class<?> ctype = property.getCurrentType();
            sb.append(" <").append(property.getClass().getSimpleName()).append(':').append(ctype == null ? "undefined" : ctype.getSimpleName()).append('>');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<Object> iterator() {
        return new PropertyMapIterator(this);
    }

    public final boolean containsArrayKeys() {
        return (this.flags & 2) != 0;
    }

    private void setContainsArrayKeys() {
        this.flags |= 2;
    }

    boolean isExtensible() {
        return (this.flags & 1) == 0;
    }

    boolean isSealed() {
        return !this.isExtensible() && !this.anyConfigurable();
    }

    boolean isFrozen() {
        return !this.isExtensible() && this.allFrozen();
    }

    int getFieldCount() {
        return this.fieldCount;
    }

    int getFieldMaximum() {
        return this.fieldMaximum;
    }

    int getSpillLength() {
        return this.spillLength;
    }

    public PropertyMap changeProto(ScriptObject newProto) {
        PropertyMap parentMap = newProto == null ? null : newProto.getMap();
        PropertyMap nextMap = this.checkProtoHistory(parentMap);
        if (nextMap != null) {
            return nextMap;
        }
        if (Context.DEBUG) {
            ++setProtoNewMapCount;
        }
        PropertyMap newMap = new PropertyMap(this);
        this.addToProtoHistory(parentMap, newMap);
        return newMap;
    }

    public static int getCount() {
        return count;
    }

    public static int getClonedCount() {
        return clonedCount;
    }

    public static int getDuplicatedCount() {
        return duplicatedCount;
    }

    public static int getHistoryHit() {
        return historyHit;
    }

    public static int getProtoInvalidations() {
        return protoInvalidations;
    }

    public static int getProtoHistoryHit() {
        return protoHistoryHit;
    }

    public static int getSetProtoNewMapCount() {
        return setProtoNewMapCount;
    }

    private static class PropertyMapIterator
    implements Iterator<Object> {
        final Iterator<Property> iter;
        Property property;

        PropertyMapIterator(PropertyMap propertyMap) {
            this.iter = Arrays.asList(propertyMap.properties.getProperties()).iterator();
            this.property = this.iter.hasNext() ? this.iter.next() : null;
            this.skipNotEnumerable();
        }

        private void skipNotEnumerable() {
            while (this.property != null && !this.property.isEnumerable()) {
                this.property = this.iter.hasNext() ? this.iter.next() : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.property != null;
        }

        @Override
        public Object next() {
            if (this.property == null) {
                throw new NoSuchElementException();
            }
            String key = this.property.getKey();
            this.property = this.iter.next();
            this.skipNotEnumerable();
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

