/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.SharedScopeCall;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.WithNode;

final class CodeGeneratorLexicalContext
extends LexicalContext {
    private int dynamicScopeCount;
    private final Map<SharedScopeCall, SharedScopeCall> scopeCalls = new HashMap<SharedScopeCall, SharedScopeCall>();
    private final Deque<CompileUnit> compileUnits = new ArrayDeque<CompileUnit>();
    private final Deque<MethodEmitter> methodEmitters = new ArrayDeque<MethodEmitter>();
    private final Deque<Node> discard = new ArrayDeque<Node>();
    private int[] nextFreeSlots = new int[16];
    private int nextFreeSlotsSize;

    CodeGeneratorLexicalContext() {
    }

    @Override
    public <T extends LexicalContextNode> T push(T node) {
        if (this.isDynamicScopeBoundary(node)) {
            ++this.dynamicScopeCount;
        }
        return super.push(node);
    }

    @Override
    public <T extends LexicalContextNode> T pop(T node) {
        T popped = super.pop(node);
        if (this.isDynamicScopeBoundary(popped)) {
            --this.dynamicScopeCount;
        }
        if (node instanceof Block) {
            --this.nextFreeSlotsSize;
        }
        return popped;
    }

    private boolean isDynamicScopeBoundary(LexicalContextNode node) {
        if (node instanceof Block) {
            return !this.isEmpty() && this.peek() instanceof WithNode;
        }
        if (node instanceof FunctionNode) {
            return CodeGeneratorLexicalContext.isFunctionDynamicScope((FunctionNode)node);
        }
        return false;
    }

    boolean inDynamicScope() {
        return this.dynamicScopeCount > 0;
    }

    static boolean isFunctionDynamicScope(FunctionNode fn) {
        return fn.hasEval() && !fn.isStrict();
    }

    MethodEmitter pushMethodEmitter(MethodEmitter newMethod) {
        this.methodEmitters.push(newMethod);
        return newMethod;
    }

    MethodEmitter popMethodEmitter(MethodEmitter oldMethod) {
        assert (this.methodEmitters.peek() == oldMethod);
        this.methodEmitters.pop();
        return this.methodEmitters.isEmpty() ? null : this.methodEmitters.peek();
    }

    CompileUnit pushCompileUnit(CompileUnit newUnit) {
        this.compileUnits.push(newUnit);
        return newUnit;
    }

    CompileUnit popCompileUnit(CompileUnit oldUnit) {
        assert (this.compileUnits.peek() == oldUnit);
        this.compileUnits.pop();
        return this.compileUnits.isEmpty() ? null : this.compileUnits.peek();
    }

    boolean hasCompileUnits() {
        return !this.compileUnits.isEmpty();
    }

    Collection<SharedScopeCall> getScopeCalls() {
        return Collections.unmodifiableCollection(this.scopeCalls.values());
    }

    SharedScopeCall getScopeCall(CompileUnit unit, Symbol symbol, Type valueType, Type returnType, Type[] paramTypes, int flags) {
        SharedScopeCall scopeCall = new SharedScopeCall(symbol, valueType, returnType, paramTypes, flags);
        if (this.scopeCalls.containsKey(scopeCall)) {
            return this.scopeCalls.get(scopeCall);
        }
        scopeCall.setClassAndName(unit, this.getCurrentFunction().uniqueName(":scopeCall"));
        this.scopeCalls.put(scopeCall, scopeCall);
        return scopeCall;
    }

    SharedScopeCall getScopeGet(CompileUnit unit, Type type, Symbol symbol, int flags) {
        SharedScopeCall scopeCall = new SharedScopeCall(symbol, type, type, null, flags);
        if (this.scopeCalls.containsKey(scopeCall)) {
            return this.scopeCalls.get(scopeCall);
        }
        scopeCall.setClassAndName(unit, this.getCurrentFunction().uniqueName(":scopeCall"));
        this.scopeCalls.put(scopeCall, scopeCall);
        return scopeCall;
    }

    void nextFreeSlot(Block block) {
        boolean isFunctionBody = this.isFunctionBody();
        int nextFreeSlot = isFunctionBody ? 0 : this.nextFreeSlots[this.nextFreeSlotsSize - 1];
        if (this.nextFreeSlotsSize == this.nextFreeSlots.length) {
            int[] newNextFreeSlots = new int[this.nextFreeSlotsSize * 2];
            System.arraycopy(this.nextFreeSlots, 0, newNextFreeSlots, 0, this.nextFreeSlotsSize);
            this.nextFreeSlots = newNextFreeSlots;
        }
        this.nextFreeSlots[this.nextFreeSlotsSize++] = CodeGeneratorLexicalContext.assignSlots(block, nextFreeSlot);
    }

    private static int assignSlots(Block block, int firstSlot) {
        int nextSlot = firstSlot;
        for (Symbol symbol : block.getSymbols()) {
            if (!symbol.hasSlot()) continue;
            symbol.setSlot(nextSlot);
            nextSlot += symbol.slotCount();
        }
        return nextSlot;
    }

    void pushDiscard(Node node) {
        this.discard.push(node);
    }

    Node popDiscard() {
        return this.discard.pop();
    }

    Node getCurrentDiscard() {
        return this.discard.peek();
    }

    int quickSlot(Symbol symbol) {
        int quickSlot = this.nextFreeSlots[this.nextFreeSlotsSize - 1];
        this.nextFreeSlots[this.nextFreeSlotsSize - 1] = quickSlot + symbol.slotCount();
        return quickSlot;
    }
}

