/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.p2;

import com.jrockit.mc.rcp.application.ApplicationPlugin;
import com.jrockit.mc.rcp.application.p2.UpdateSiteURLToolkit;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public final class P2Toolkit {
    public static void addRepositories(IProvisioningAgent agent) {
        P2Toolkit.addExperimentalRepository(agent);
        if (P2Toolkit.isOnOracleNetwork()) {
            ApplicationPlugin.getLogger().log(Level.INFO, "Detected Oracle Network - attempting to enable Oracle Internal Update Site.");
            P2Toolkit.addInternalRepository(agent);
        }
    }

    private static void addInternalRepository(IProvisioningAgent agent) {
        P2Toolkit.addRepository(agent, UpdateSiteURLToolkit.getInternalUpdateSite());
    }

    private static boolean isOnOracleNetwork() {
        return UpdateSiteURLToolkit.isOnOracleNetwork();
    }

    private static void addExperimentalRepository(IProvisioningAgent agent) {
        P2Toolkit.addRepository(agent, UpdateSiteURLToolkit.getExperimentalUpdateSite());
    }

    private static void addRepository(IProvisioningAgent agent, String repo) {
        URI repoUri;
        try {
            repoUri = new URI(repo);
        }
        catch (URISyntaxException e) {
            ApplicationPlugin.getLogger().log(Level.WARNING, "Failed to add update site due to malformed URI!", e);
            return;
        }
        ProvisioningUI ui = ProvUIActivator.getDefault().getProvisioningUI();
        IArtifactRepositoryManager artifactManager = ProvUI.getArtifactRepositoryManager((ProvisioningSession)ui.getSession());
        artifactManager.addRepository(repoUri);
        IMetadataRepositoryManager metadataManager = ProvUI.getMetadataRepositoryManager((ProvisioningSession)ui.getSession());
        metadataManager.addRepository(repoUri);
    }
}

