/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.commands.CommandsPlugin;
import com.jrockit.mc.rcp.application.ApplicationActionBarAdvisor;
import com.jrockit.mc.rcp.application.ApplicationPlugin;
import com.jrockit.mc.rcp.application.MissionControlEditorDropAdapter;
import com.jrockit.mc.rcp.logging.LoggingToolkit;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.traymanager.TrayManager;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.part.EditorInputTransfer;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private IApplicationContext m_applicationContext;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        try {
            UIPlugin.getDefault().setTrayManager(new TrayManager(configurer.getWorkbenchConfigurer().getWorkbench()));
        }
        catch (UnsupportedOperationException e) {
            ApplicationPlugin.getLogger().log(Level.WARNING, "Could not set TrayManager.", e);
        }
    }

    public ApplicationWorkbenchWindowAdvisor(IApplicationContext applicationContext, IWorkbenchWindowConfigurer configurer) {
        this(configurer);
        this.m_applicationContext = applicationContext;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public boolean preWindowShellClose() {
        TrayManager manager = UIPlugin.getDefault().getTrayManager();
        if (manager != null) {
            if (manager.getMinimizeToTrayOnClose() && manager.minimizeToTray()) {
                return false;
            }
            manager.dispose();
        }
        return true;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(false);
        configurer.addEditorAreaTransfer((Transfer)LocalSelectionTransfer.getTransfer());
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new MissionControlEditorDropAdapter(configurer.getWindow()));
        configurer.setInitialSize(new Point(1400, 850));
    }

    public void postWindowOpen() {
        this.executeCommands();
        this.removeUnwantedPreferencesPages();
    }

    private void removeUnwantedPreferencesPages() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode root = this.getRoot(pm);
        this.removePrefsPage(root, "org.eclipse.equinox.security.ui.category");
    }

    private IPreferenceNode getRoot(PreferenceManager pm) {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("getRoot", null);
            m.setAccessible(true);
            return (IPreferenceNode)m.invoke((Object)pm, new Object[0]);
        }
        catch (Exception e) {
            LoggingToolkit.getLogger().log(Level.WARNING, "Could not get the root node for the preferences, and will not be able to prune unwanted prefs pages.", e);
            return null;
        }
    }

    private void removePrefsPage(IPreferenceNode root, String id) {
        IPreferenceNode[] iPreferenceNodeArray = root.getSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode node = iPreferenceNodeArray[n2];
            this.logPrefsNode(node);
            if (node.getId().equals(id)) {
                root.remove(node);
                LoggingToolkit.getLogger().log(Level.INFO, String.format("Removed preference page %s (ID:%s)", node.getLabelText(), node.getId()));
            } else {
                this.removePrefsPage(node, id);
            }
            ++n2;
        }
    }

    private void logPrefsNode(IPreferenceNode node) {
        LoggingToolkit.getLogger().log(Level.FINE, String.format("Prefs node: %s %s", node.getLabelText(), node.getId()));
    }

    private void executeCommands() {
        Map arguments = this.m_applicationContext.getArguments();
        String[] appArguments = (String[])arguments.get("application.args");
        if (appArguments.length > 0) {
            this.execute(this.buildCommandText(appArguments).split(";"));
        }
    }

    private void execute(String[] commands) {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            try {
                CommandsPlugin.getDefault().execute(command, System.out);
            }
            catch (ParseException e) {
                ApplicationPlugin.getLogger().log(Level.WARNING, e.getMessage());
            }
            ++n2;
        }
    }

    private String buildCommandText(String[] appArguments) {
        StringBuilder builder = new StringBuilder();
        int n = 0;
        while (n < appArguments.length) {
            String arg = appArguments[n];
            if (arg.startsWith("-")) {
                if (n != 0) {
                    builder.append(';');
                }
                builder.append(arg.substring(1));
            } else {
                builder.append(" \"");
                builder.append(arg);
                builder.append('\"');
            }
            ++n;
        }
        return builder.toString();
    }
}

