/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.form;

import com.jrockit.mc.console.ui.diagnostic.DiagnosticPlugin;
import com.jrockit.mc.console.ui.diagnostic.form.Messages;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.rjmx.services.IDiagnosticCommandService;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.services.IllegalOperandException;
import com.jrockit.mc.rjmx.ui.operations.ExecuteOperationForm;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DiagnosticTab
extends ConsoleTab {
    private IOperation helpOperation;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        if (this.getConnectionHandle().hasService(IDiagnosticCommandService.class)) {
            try {
                this.loadOperations(managedForm);
            }
            catch (Exception e) {
                this.presentErrorMessage(managedForm);
            }
        } else {
            this.presentErrorMessage(managedForm);
        }
    }

    private void presentErrorMessage(IManagedForm managedForm) {
        DiagnosticPlugin.getDefault().getLogger().log(Level.WARNING, Messages.DiagnosticTab_MESSAGE_DIAGNOSTIC_COMMANDS_NOT_SUPPORTED);
        this.disableForm(managedForm, Messages.DiagnosticTab_MESSAGE_DIAGNOSTIC_COMMANDS_NOT_SUPPORTED);
    }

    private void loadOperations(IManagedForm managedForm) throws Exception {
        IDiagnosticCommandService diagCommandService = (IDiagnosticCommandService)this.getConnectionHandle().getServiceOrDummy(IDiagnosticCommandService.class);
        Collection operations = diagCommandService.getOperations();
        this.helpOperation = this.findHelpOperation(operations);
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout(MCLayoutFactory.createFormPageLayout());
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)DiagnosticPlugin.getDefault().getMCDialogSettings(), (String)"execute_diagnostic_form");
        ExecuteOperationForm operationsForm = new ExecuteOperationForm(form.getBody(), managedForm, managedForm.getToolkit(), "console.diagnostic.commands.section", false, true, settings, this.createHelpProvider());
        operationsForm.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        operationsForm.setOperations(operations);
    }

    private IOperation findHelpOperation(Collection<? extends IOperation> operations) {
        for (IOperation iOperation : operations) {
            if (!iOperation.getName().equals("help")) continue;
            return iOperation;
        }
        return null;
    }

    private ExecuteOperationForm.HelpProvider createHelpProvider() {
        return new ExecuteOperationForm.HelpProvider(){

            public Callable<?> getHelpInvocator(IOperation operation) {
                try {
                    return DiagnosticTab.this.helpOperation.getInvocator(new Object[]{null, operation.getName()});
                }
                catch (IllegalOperandException e) {
                    return null;
                }
            }
        };
    }
}

