/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import sun.misc.Unsafe;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    final Sync sync;
    private static final Unsafe UNSAFE;
    private static final long TID_OFFSET;

    public ReentrantReadWriteLock() {
        this(false);
    }

    public ReentrantReadWriteLock(boolean bl) {
        this.sync = bl ? new FairSync() : new NonfairSync();
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    @Override
    public WriteLock writeLock() {
        return this.writerLock;
    }

    @Override
    public ReadLock readLock() {
        return this.readerLock;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    protected Collection<Thread> getQueuedWriterThreads() {
        return this.sync.getExclusiveQueuedThreads();
    }

    protected Collection<Thread> getQueuedReaderThreads() {
        return this.sync.getSharedQueuedThreads();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        int n = this.sync.getCount();
        int n2 = Sync.exclusiveCount(n);
        int n3 = Sync.sharedCount(n);
        return super.toString() + "[Write locks = " + n2 + ", Read locks = " + n3 + "]";
    }

    static final long getThreadId(Thread thread) {
        return UNSAFE.getLongVolatile(thread, TID_OFFSET);
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            TID_OFFSET = UNSAFE.objectFieldOffset(clazz.getDeclaredField("tid"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return this.hasQueuedPredecessors();
        }

        @Override
        final boolean readerShouldBlock() {
            return this.hasQueuedPredecessors();
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return false;
        }

        @Override
        final boolean readerShouldBlock() {
            return this.apparentlyFirstQueuedIsExclusive();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            this.sync = reentrantReadWriteLock.sync;
        }

        @Override
        public void lock() {
            this.sync.acquireShared(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireSharedInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            return this.sync.tryReadLock();
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
        }

        @Override
        public void unlock() {
            this.sync.releaseShared(1);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int n = this.sync.getReadLockCount();
            return super.toString() + "[Read locks = " + n + "]";
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        private transient ThreadLocalHoldCounter readHolds = new ThreadLocalHoldCounter();
        private transient HoldCounter cachedHoldCounter;
        private transient Thread firstReader = null;
        private transient int firstReaderHoldCount;

        static int sharedCount(int n) {
            return n >>> 16;
        }

        static int exclusiveCount(int n) {
            return n & 0xFFFF;
        }

        Sync() {
            this.setState(this.getState());
        }

        abstract boolean readerShouldBlock();

        abstract boolean writerShouldBlock();

        @Override
        protected final boolean tryRelease(int n) {
            boolean bl;
            if (!this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n2 = this.getState() - n;
            boolean bl2 = bl = Sync.exclusiveCount(n2) == 0;
            if (bl) {
                this.setExclusiveOwnerThread(null);
            }
            this.setState(n2);
            return bl;
        }

        @Override
        protected final boolean tryAcquire(int n) {
            Thread thread = Thread.currentThread();
            int n2 = this.getState();
            int n3 = Sync.exclusiveCount(n2);
            if (n2 != 0) {
                if (n3 == 0 || thread != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (n3 + Sync.exclusiveCount(n) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(n2 + n);
                return true;
            }
            if (this.writerShouldBlock() || !this.compareAndSetState(n2, n2 + n)) {
                return false;
            }
            this.setExclusiveOwnerThread(thread);
            return true;
        }

        @Override
        protected final boolean tryReleaseShared(int n) {
            int n2;
            int n3;
            Thread thread = Thread.currentThread();
            if (this.firstReader == thread) {
                if (this.firstReaderHoldCount == 1) {
                    this.firstReader = null;
                } else {
                    --this.firstReaderHoldCount;
                }
            } else {
                HoldCounter holdCounter = this.cachedHoldCounter;
                if (holdCounter == null || holdCounter.tid != ReentrantReadWriteLock.getThreadId(thread)) {
                    holdCounter = (HoldCounter)this.readHolds.get();
                }
                if ((n3 = holdCounter.count) <= 1) {
                    this.readHolds.remove();
                    if (n3 <= 0) {
                        throw this.unmatchedUnlockException();
                    }
                }
                --holdCounter.count;
            }
            while (!this.compareAndSetState(n2 = this.getState(), n3 = n2 - 65536)) {
            }
            return n3 == 0;
        }

        private IllegalMonitorStateException unmatchedUnlockException() {
            return new IllegalMonitorStateException("attempt to unlock read lock, not locked by current thread");
        }

        @Override
        protected final int tryAcquireShared(int n) {
            Thread thread = Thread.currentThread();
            int n2 = this.getState();
            if (Sync.exclusiveCount(n2) != 0 && this.getExclusiveOwnerThread() != thread) {
                return -1;
            }
            int n3 = Sync.sharedCount(n2);
            if (!this.readerShouldBlock() && n3 < 65535 && this.compareAndSetState(n2, n2 + 65536)) {
                if (n3 == 0) {
                    this.firstReader = thread;
                    this.firstReaderHoldCount = 1;
                } else if (this.firstReader == thread) {
                    ++this.firstReaderHoldCount;
                } else {
                    HoldCounter holdCounter = this.cachedHoldCounter;
                    if (holdCounter == null || holdCounter.tid != ReentrantReadWriteLock.getThreadId(thread)) {
                        this.cachedHoldCounter = holdCounter = (HoldCounter)this.readHolds.get();
                    } else if (holdCounter.count == 0) {
                        this.readHolds.set(holdCounter);
                    }
                    ++holdCounter.count;
                }
                return 1;
            }
            return this.fullTryAcquireShared(thread);
        }

        final int fullTryAcquireShared(Thread thread) {
            int n;
            HoldCounter holdCounter = null;
            do {
                if (Sync.exclusiveCount(n = this.getState()) != 0) {
                    if (this.getExclusiveOwnerThread() != thread) {
                        return -1;
                    }
                } else if (this.readerShouldBlock() && this.firstReader != thread) {
                    if (holdCounter == null && ((holdCounter = this.cachedHoldCounter) == null || holdCounter.tid != ReentrantReadWriteLock.getThreadId(thread))) {
                        holdCounter = (HoldCounter)this.readHolds.get();
                        if (holdCounter.count == 0) {
                            this.readHolds.remove();
                        }
                    }
                    if (holdCounter.count == 0) {
                        return -1;
                    }
                }
                if (Sync.sharedCount(n) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(n, n + 65536));
            if (Sync.sharedCount(n) == 0) {
                this.firstReader = thread;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == thread) {
                ++this.firstReaderHoldCount;
            } else {
                if (holdCounter == null) {
                    holdCounter = this.cachedHoldCounter;
                }
                if (holdCounter == null || holdCounter.tid != ReentrantReadWriteLock.getThreadId(thread)) {
                    holdCounter = (HoldCounter)this.readHolds.get();
                } else if (holdCounter.count == 0) {
                    this.readHolds.set(holdCounter);
                }
                ++holdCounter.count;
                this.cachedHoldCounter = holdCounter;
            }
            return 1;
        }

        final boolean tryWriteLock() {
            Thread thread = Thread.currentThread();
            int n = this.getState();
            if (n != 0) {
                int n2 = Sync.exclusiveCount(n);
                if (n2 == 0 || thread != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (n2 == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (!this.compareAndSetState(n, n + 1)) {
                return false;
            }
            this.setExclusiveOwnerThread(thread);
            return true;
        }

        final boolean tryReadLock() {
            int n;
            int n2;
            Thread thread = Thread.currentThread();
            do {
                if (Sync.exclusiveCount(n2 = this.getState()) != 0 && this.getExclusiveOwnerThread() != thread) {
                    return false;
                }
                n = Sync.sharedCount(n2);
                if (n != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(n2, n2 + 65536));
            if (n == 0) {
                this.firstReader = thread;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == thread) {
                ++this.firstReaderHoldCount;
            } else {
                HoldCounter holdCounter = this.cachedHoldCounter;
                if (holdCounter == null || holdCounter.tid != ReentrantReadWriteLock.getThreadId(thread)) {
                    this.cachedHoldCounter = holdCounter = (HoldCounter)this.readHolds.get();
                } else if (holdCounter.count == 0) {
                    this.readHolds.set(holdCounter);
                }
                ++holdCounter.count;
            }
            return true;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return Sync.exclusiveCount(this.getState()) == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getReadLockCount() {
            return Sync.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return Sync.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            if (this.getReadLockCount() == 0) {
                return 0;
            }
            Thread thread = Thread.currentThread();
            if (this.firstReader == thread) {
                return this.firstReaderHoldCount;
            }
            HoldCounter holdCounter = this.cachedHoldCounter;
            if (holdCounter != null && holdCounter.tid == ReentrantReadWriteLock.getThreadId(thread)) {
                return holdCounter.count;
            }
            int n = ((HoldCounter)this.readHolds.get()).count;
            if (n == 0) {
                this.readHolds.remove();
            }
            return n;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.readHolds = new ThreadLocalHoldCounter();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }

        static final class HoldCounter {
            int count = 0;
            final long tid = ReentrantReadWriteLock.getThreadId(Thread.currentThread());

            HoldCounter() {
            }
        }

        static final class ThreadLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            ThreadLocalHoldCounter() {
            }

            @Override
            public HoldCounter initialValue() {
                return new HoldCounter();
            }
        }
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            this.sync = reentrantReadWriteLock.sync;
        }

        @Override
        public void lock() {
            this.sync.acquire(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            return this.sync.tryWriteLock();
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.sync.tryAcquireNanos(1, timeUnit.toNanos(l));
        }

        @Override
        public void unlock() {
            this.sync.release(1);
        }

        @Override
        public Condition newCondition() {
            return this.sync.newCondition();
        }

        public String toString() {
            Thread thread = this.sync.getOwner();
            return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
        }

        public boolean isHeldByCurrentThread() {
            return this.sync.isHeldExclusively();
        }

        public int getHoldCount() {
            return this.sync.getWriteHoldCount();
        }
    }
}

