/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.modules.autoupdate.services.DependencyAggregator;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.ModuleCache;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.KeyStoreProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Places;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utilities {
    public static final String UNSIGNED = "UNSIGNED";
    public static final String N_A = "N/A";
    public static final String TRUSTED = "TRUSTED";
    public static final String UNTRUSTED = "UNTRUSTED";
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    public static final String JAR_EXTENSION = ".jar";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    public static final String ATTR_ESSENTIAL = "AutoUpdate-Essential-Module";
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";
    private static final String USER_KS_KEY = "userKS";
    private static final String USER_KS_FILE_NAME = "user.ks";
    private static final String KS_USER_PASSWORD = "open4user";
    private static Lookup.Result<KeyStoreProvider> result;
    private static final Logger err;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private static Reference<Map<ModuleInfo, Set<UpdateElement>>> cachedInfo2RequestedReference;
    private static Reference<Set<ModuleInfo>> cachedInfosReference;
    private static Reference<Set<UpdateElement>> cachedResultReference;
    private static String productVersion;

    private Utilities() {
    }

    public static Collection<KeyStore> getKeyStore() {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookupResult(KeyStoreProvider.class);
            result.addLookupListener((LookupListener)new KeyStoreProviderListener());
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>();
        for (KeyStoreProvider keyStoreProvider : collection) {
            KeyStore keyStore = keyStoreProvider.getKeyStore();
            if (keyStore == null) continue;
            arrayList.add(keyStore);
        }
        return arrayList;
    }

    public static String verifyCertificates(Collection<Certificate> collection, Collection<Certificate> collection2) {
        if (collection == null) {
            return N_A;
        }
        if (!collection.isEmpty()) {
            HashSet<Certificate> hashSet = new HashSet<Certificate>(collection2);
            hashSet.retainAll(collection);
            if (!hashSet.isEmpty()) {
                return TRUSTED;
            }
            return UNTRUSTED;
        }
        return UNSIGNED;
    }

    public static Collection<Certificate> getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (String string : Collections.list(keyStore.aliases())) {
            arrayList.add(keyStore.getCertificate(string));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Certificate> getNbmCertificates(File file) throws IOException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        JarFile jarFile = new JarFile(file);
        boolean bl = true;
        try {
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                Utilities.verifyEntry(jarFile, jarEntry);
                if (jarEntry.getName().startsWith("META-INF/")) continue;
                bl = false;
                if (jarEntry.getCertificates() == null) continue;
                hashSet.addAll(Arrays.asList(jarEntry.getCertificates()));
            }
        }
        finally {
            jarFile.close();
        }
        return bl ? null : hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = jarFile.getInputStream(jarEntry);
            byte[] byArray = new byte[8192];
            while (inputStream.read(byArray, 0, byArray.length) != -1) {
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static File getInstallLater(File file) {
        File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "install_later.xml");
        return file2;
    }

    public static void deleteAllDoLater() {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            for (File file2 : Utilities.findDoLater(file)) {
                file2.delete();
            }
        }
    }

    private static Collection<File> findDoLater(File file) {
        if (!file.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        if (Utilities.getInstallLater(file).exists()) {
            hashSet.add(Utilities.getInstallLater(file));
        }
        if (ModuleDeactivator.getDeactivateLater(file).exists()) {
            hashSet.add(ModuleDeactivator.getDeactivateLater(file));
        }
        return hashSet;
    }

    public static void writeInstallLater(Map<UpdateElementImpl, File> map) {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            Utilities.writeInstallLaterToCluster(file, map);
        }
    }

    private static void writeInstallLaterToCluster(File file, Map<UpdateElementImpl, File> map) {
        Document document = XMLUtil.createDocument((String)"installed_modules", null, null, null);
        Element element = document.getDocumentElement();
        if (map.isEmpty()) {
            return;
        }
        boolean bl = true;
        for (UpdateElementImpl updateElementImpl : map.keySet()) {
            File file2 = map.get(updateElementImpl);
            if (!file.equals(file2)) continue;
            Element element2 = document.createElement("module");
            element2.setAttribute("codename", updateElementImpl.getCodeName());
            element2.setAttribute(ATTR_NAME, updateElementImpl.getDisplayName());
            element2.setAttribute(ATTR_SPEC_VERSION, updateElementImpl.getSpecificationVersion().toString());
            element2.setAttribute(ATTR_SIZE, Long.toString(updateElementImpl.getDownloadSize()));
            element2.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), updateElementImpl.getInstallInfo().getDistribution()).getName());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getInstallLater(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXMLDocumentToFile(Document document, File file) {
        document.getDocumentElement().normalize();
        file.getParentFile().mkdirs();
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = null;
        try {
            try {
                XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                outputStream = new FileOutputStream(file);
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public static void writeDeactivateLater(Collection<File> collection) {
        File file = InstallManager.getUserDir();
        assert (file != null && file.exists()) : "Userdir " + file + " found and exists.";
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getDeactivateLater(file));
    }

    public static void writeFileMarkedForDelete(Collection<File> collection) {
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getControlFileForMarkedForDelete(InstallManager.getUserDir()));
    }

    public static void writeFileMarkedForDisable(Collection<File> collection) {
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getControlFileForMarkedForDisable(InstallManager.getUserDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMarkedFilesToFile(Collection<File> collection, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        if (file.exists()) {
            stringBuilder.append(ModuleDeactivator.readStringFromFile(file));
        }
        for (File object2 : collection) {
            stringBuilder.append(object2.getAbsolutePath());
            stringBuilder.append(UpdateTracking.PATH_SEPARATOR);
        }
        if (stringBuilder == null || stringBuilder.length() == 0) {
            return;
        }
        file.getParentFile().mkdirs();
        assert (file.getParentFile().exists() && file.getParentFile().isDirectory()) : "Parent of " + file + " exists and is directory.";
        Object object3 = null;
        OutputStream outputStream = null;
        try {
            FileOutputStream fileOutputStream;
            block12: {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    object3 = new ByteArrayInputStream(stringBuilder.toString().getBytes());
                    FileUtil.copy((InputStream)object3, (OutputStream)fileOutputStream);
                    if (object3 == null) break block12;
                }
                catch (Throwable iOException) {
                    if (object3 != null) {
                        ((InputStream)object3).close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw iOException;
                }
                ((InputStream)object3).close();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static void writeAdditionalInformation(Map<UpdateElementImpl, File> map) {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            Utilities.writeAdditionalInformationToCluster(file, map);
        }
    }

    public static File locateUpdateTracking(ModuleInfo moduleInfo) {
        String string = "update_tracking/" + moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, moduleInfo.getCodeNameBase(), false);
    }

    public static String readSourceFromUpdateTracking(ModuleInfo moduleInfo) {
        Node node;
        String string = null;
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && (node = Utilities.getModuleConfiguration(file)) != null) {
            Node node2 = node.getAttributes().getNamedItem("origin");
            assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_ORIGIN attribute.";
            if (!"updater".equals(node2.getNodeValue()) && !"installer".equals(node2.getNodeValue())) {
                string = node2.getNodeValue();
            }
        }
        return string;
    }

    public static Date readInstallTimeFromUpdateTracking(ModuleInfo moduleInfo) {
        Node node;
        Date date = null;
        String string = null;
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && (node = Utilities.getModuleConfiguration(file)) != null) {
            Node node2 = node.getAttributes().getNamedItem("install_time");
            assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_INSTALL attribute.";
            string = node2.getNodeValue();
        }
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                date = new Date(l);
            }
            catch (NumberFormatException numberFormatException) {
                Utilities.getLogger().log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUpdateOfUpdaterJar(JarEntry jarEntry, JarFile jarFile, File file) {
        String string = jarEntry.getName();
        String string2 = string.contains("/") ? string.substring(string.lastIndexOf("/") + 1) : string;
        File file2 = new File(file, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater" + UpdateTracking.FILE_SEPARATOR + string2);
        file2.getParentFile().mkdirs();
        assert (file2.getParentFile().exists() && file2.getParentFile().isDirectory()) : "Parent of " + file2 + " exists and is directory.";
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file2);
                inputStream = jarFile.getInputStream(jarEntry);
                FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                jarFile.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.getLogger().log(Level.SEVERE, fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
    }

    static void cleanUpdateOfUpdaterJar() {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            File file2 = new File(file, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater");
            if (!file2.exists() || !file2.isDirectory()) continue;
            for (File file3 : file2.listFiles()) {
                file3.delete();
            }
            file2.delete();
        }
    }

    static Module toModule(UpdateUnit updateUnit) {
        return Utilities.getModuleInstance(updateUnit.getCodeName(), null);
    }

    public static Module toModule(String string, SpecificationVersion specificationVersion) {
        return Utilities.getModuleInstance(string, specificationVersion);
    }

    public static Module toModule(ModuleInfo moduleInfo) {
        Module module = Utilities.getModuleInstance(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion());
        if (module == null && moduleInfo instanceof Module) {
            module = (Module)moduleInfo;
        }
        return module;
    }

    public static boolean isFixed(ModuleInfo moduleInfo) {
        Module module = Utilities.toModule(moduleInfo);
        assert (!moduleInfo.isEnabled() || module != null) : "Module found for enabled " + moduleInfo;
        return module == null ? false : module.isFixed();
    }

    public static boolean isValid(ModuleInfo moduleInfo) {
        Module module = Utilities.toModule(moduleInfo);
        assert (!moduleInfo.isEnabled() || module != null) : "Module found for enabled " + moduleInfo;
        return module == null ? false : module.isValid();
    }

    static UpdateUnit toUpdateUnit(Module module) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(module.getCodeNameBase());
    }

    static UpdateUnit toUpdateUnit(String string) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(string);
    }

    public static Set<UpdateElement> findRequiredUpdateElements(UpdateElement updateElement, Collection<ModuleInfo> collection, Set<Dependency> set, boolean bl, Collection<UpdateElement> collection2) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        switch (updateElement.getUpdateUnit().getType()) {
            case KIT_MODULE: 
            case MODULE: {
                Set<UpdateElement> set2;
                Set<Dependency> set3;
                int n;
                boolean bl2 = collection2 != null && !collection2.isEmpty();
                ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)Trampoline.API.impl(updateElement);
                Set<Dependency> set4 = new HashSet<Dependency>(moduleUpdateElementImpl.getModuleInfo().getDependencies());
                HashSet<ModuleInfo> hashSet2 = new HashSet<ModuleInfo>(collection);
                int n2 = n = moduleUpdateElementImpl.getType().equals((Object)UpdateManager.TYPE.KIT_MODULE) ? 2 : 1;
                boolean bl3 = bl && n2 > 0;
                HashSet<Dependency> hashSet3 = new HashSet<Dependency>();
                while (true) {
                    set3 = Utilities.processDependencies(set4, hashSet, hashSet2, set, updateElement, bl3, collection2, bl2);
                    set3.removeAll(hashSet3);
                    if (set3.isEmpty()) break;
                    hashSet3.addAll(set3);
                    set4 = set3;
                }
                set3 = new HashSet<Dependency>();
                HashSet<ModuleInfo> hashSet4 = new HashSet<ModuleInfo>(hashSet2);
                n2 = n;
                boolean bl4 = bl3 = bl && n2 > 0;
                while (hashSet.addAll(set2 = Utilities.handleBackwardCompatability(hashSet4, set3, bl3))) {
                    if (!set3.isEmpty()) {
                        set.addAll(set3);
                        break;
                    }
                    for (UpdateElement updateElement2 : set2) {
                        hashSet4.add(((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2)).getModuleInfo());
                    }
                    bl3 = bl3 && n2-- > 0;
                }
                if (set3.isEmpty()) break;
                set.addAll(set3);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)Trampoline.API.impl(updateElement);
                boolean bl5 = bl;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : featureUpdateElementImpl.getContainedModuleElements()) {
                    hashSet.addAll(Utilities.findRequiredUpdateElements(moduleUpdateElementImpl.getUpdateElement(), collection, set, bl5, collection2));
                }
                break;
            }
            case CUSTOM_HANDLED_COMPONENT: {
                Utilities.getLogger().log(Level.INFO, "CUSTOM_HANDLED_COMPONENT doesn't care about required elements.");
                break;
            }
            default: {
                assert (false) : "Not implement for type " + updateElement.getUpdateUnit() + " of UpdateElement " + updateElement;
                break;
            }
        }
        return hashSet;
    }

    private static Set<UpdateElement> handleBackwardCompatability4ModuleInfo(ModuleInfo moduleInfo, Set<ModuleInfo> set, Set<Dependency> set2, boolean bl) {
        Object object;
        if (cachedInfo2RequestedReference != null && cachedInfo2RequestedReference.get() != null && (object = cachedInfo2RequestedReference.get().get(moduleInfo)) != null) {
            return object;
        }
        object = UpdateManagerImpl.getInstance().getUpdateUnit(moduleInfo.getCodeNameBase());
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        if (object == null) {
            return hashSet;
        }
        UpdateElement updateElement = ((UpdateUnit)object).getInstalled();
        if (updateElement == null) {
            return hashSet;
        }
        HashSet hashSet2 = new HashSet();
        hashSet2.addAll(Dependency.create((int)1, (String)moduleInfo.getCodeName()));
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(moduleInfo.getProvides()));
        TreeSet<String> treeSet2 = new TreeSet<String>(Arrays.asList(((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement)).getModuleInfo().getProvides()));
        treeSet2.removeAll(treeSet);
        for (String string : treeSet2) {
            if (string.startsWith("org.openide.modules.os")) continue;
            hashSet2.addAll(Dependency.create((int)5, (String)string));
            hashSet2.addAll(Dependency.create((int)6, (String)string));
        }
        for (String string : hashSet2) {
            DependencyAggregator dependencyAggregator = DependencyAggregator.getAggregator((Dependency)string);
            int n = string.getType();
            String string2 = string.getName();
            for (ModuleInfo moduleInfo2 : dependencyAggregator.getDependening()) {
                Module module = Utilities.getModuleInstance(moduleInfo2.getCodeNameBase(), moduleInfo2.getSpecificationVersion());
                if (module == null || !module.getProblems().isEmpty()) continue;
                for (Dependency dependency : module.getDependencies()) {
                    Set<Dependency> set3;
                    UpdateUnit updateUnit;
                    if (n != dependency.getType() || !string2.equals(dependency.getName()) || DependencyChecker.checkDependencyModule(dependency, moduleInfo) || (updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(module.getCodeNameBase())).getAvailableUpdates().isEmpty()) continue;
                    UpdateElement updateElement2 = updateUnit.getAvailableUpdates().get(0);
                    ModuleInfo moduleInfo3 = ((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2)).getModuleInfo();
                    Set<Dependency> set4 = new HashSet<Dependency>(moduleInfo3.getDependencies());
                    HashSet<ModuleInfo> hashSet3 = new HashSet<ModuleInfo>(set);
                    while (!(set3 = Utilities.processDependencies(set4, hashSet, hashSet3, set2, updateElement2, bl, null, false)).isEmpty()) {
                        set4 = set3;
                    }
                    hashSet.add(updateElement2);
                }
            }
        }
        if (cachedInfo2RequestedReference == null || cachedInfo2RequestedReference.get() == null) {
            cachedInfo2RequestedReference = new WeakReference(new HashMap());
        }
        cachedInfo2RequestedReference.get().put(moduleInfo, hashSet);
        return hashSet;
    }

    private static Set<UpdateElement> handleBackwardCompatability(Set<ModuleInfo> set, Set<Dependency> set2, boolean bl) {
        if (cachedInfosReference != null && cachedInfosReference.get() != null && cachedInfosReference.get().equals(set) && cachedResultReference != null && cachedResultReference.get() != null) {
            return cachedResultReference.get();
        }
        cachedInfosReference = new WeakReference<Set<ModuleInfo>>(set);
        err.finest("calling handleBackwardCompatability(size: " + set.size() + ")");
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (ModuleInfo moduleInfo : set) {
            hashSet.addAll(Utilities.handleBackwardCompatability4ModuleInfo(moduleInfo, set, set2, bl));
        }
        cachedResultReference = new WeakReference(hashSet);
        return hashSet;
    }

    private static Set<Dependency> processDependencies(Set<Dependency> set, Set<UpdateElement> set2, Set<ModuleInfo> set3, Set<Dependency> set4, UpdateElement updateElement, boolean bl, Collection<UpdateElement> collection, boolean bl2) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        AutomaticDependencies.Report report = AutomaticDependencies.getDefault().refineDependenciesAndReport(updateElement.getCodeName(), set);
        if (report.isModified()) {
            err.fine(report.toString());
        }
        for (Dependency dependency : set) {
            Collection<UpdateElement> collection2;
            if (7 == dependency.getType() && bl2 || (collection2 = Utilities.handleDependency(updateElement, dependency, set3, set4, bl)) == null) continue;
            if (7 == dependency.getType() && collection != null) {
                collection.addAll(collection2);
            }
            for (UpdateElement updateElement2 : collection2) {
                ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2);
                set3.add(moduleUpdateElementImpl.getModuleInfo());
                set2.add(updateElement2);
                hashSet.addAll(moduleUpdateElementImpl.getModuleInfo().getDependencies());
            }
        }
        hashSet.removeAll(set);
        return hashSet;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Collection<UpdateElement> handleDependency(UpdateElement var0, Dependency var1_1, Collection<ModuleInfo> var2_2, Set<Dependency> var3_3, boolean var4_4) {
        var5_5 = new HashSet<UpdateElement>();
        switch (var1_1.getType()) {
            case 3: {
                if (DependencyChecker.matchDependencyJava(var1_1)) break;
                var3_3.add(var1_1);
                break;
            }
            case 2: {
                if (DependencyChecker.matchPackageDependency(var1_1)) break;
                var3_3.add(var1_1);
                break;
            }
            case 1: {
                var6_6 = DependencyAggregator.getRequested(var1_1);
                if (!Utilities.$assertionsDisabled && var6_6 != null && !var6_6.isEmpty() && var6_6.size() != 1) {
                    throw new AssertionError((Object)(var1_1 + " returns null, empty or only once module, but returns " + var6_6));
                }
                var7_7 = false;
                v0 = var8_8 = var6_6 == null || var6_6.isEmpty() != false ? null : var6_6.iterator().next();
                if (var8_8 == null) ** GOTO lbl40
                var9_9 = var4_4;
                if (var9_9 && (Utilities.isFirstClassModule(var0) || var8_8.getType() == UpdateManager.TYPE.KIT_MODULE)) {
                    var9_9 = false;
                }
                if (var8_8.getInstalled() != null) {
                    var10_12 = Trampoline.API.impl(var8_8.getInstalled());
                    var7_7 = DependencyChecker.checkDependencyModule(var1_1, ((ModuleUpdateElementImpl)var10_12).getModuleInfo());
                }
                if (!var7_7) {
                    var10_12 = var2_2.iterator();
                    while (var10_12.hasNext()) {
                        var11_15 /* !! */  = (ModuleInfo)var10_12.next();
                        if (!DependencyChecker.checkDependencyModule(var1_1, var11_15 /* !! */ )) continue;
                        var7_7 = true;
                        break;
                    }
                }
                if (!var9_9 && var7_7) ** GOTO lbl44
                v1 = var10_12 = var8_8.getAvailableUpdates().isEmpty() != false ? null : var8_8.getAvailableUpdates().get(0);
                if (var10_12 != null && DependencyChecker.checkDependencyModule(var1_1, var13_21 = (var12_18 = (ModuleUpdateElementImpl)(var11_15 /* !! */  = Trampoline.API.impl((UpdateElement)var10_12))).getModuleInfo()) && !var2_2.contains(var13_21)) {
                    var5_5.add((UpdateElement)var10_12);
                    var7_7 = true;
                }
                ** GOTO lbl44
lbl40:
                // 2 sources

                for (ModuleInfo var10_13 : var2_2) {
                    if (!DependencyChecker.checkDependencyModule(var1_1, var10_13)) continue;
                    var7_7 = true;
                    break;
                }
lbl44:
                // 4 sources

                if (var7_7) break;
                var3_3.add(var1_1);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if ("org.openide.modules.ModuleFormat1".equals(var1_1.getName()) || "org.openide.modules.ModuleFormat2".equals(var1_1.getName())) break;
                var9_11 = DependencyAggregator.getRequested(var1_1);
                var10_14 = false;
                if (var9_11 != null && !var9_11.isEmpty()) ** GOTO lbl58
                for (ModuleInfo var12_19 : var2_2) {
                    if (!Arrays.asList(var12_19.getProvides()).contains(var1_1.getName())) continue;
                    var10_14 = true;
                    ** GOTO lbl64
                }
                ** GOTO lbl64
lbl58:
                // 1 sources

                var10_14 = true;
                for (UpdateUnit var12_20 : var9_11) {
                    if (var12_20.getAvailableUpdates().isEmpty()) continue;
                    var5_5.add(var12_20.getAvailableUpdates().get(0));
                }
lbl64:
                // 3 sources

                if (var10_14 || 7 == var1_1.getType()) break;
                var3_3.add(var1_1);
            }
        }
        return var5_5;
    }

    static Set<String> getBrokenDependencies(UpdateElement updateElement, List<ModuleInfo> list) {
        assert (updateElement != null) : "UpdateElement cannot be null";
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        Utilities.findRequiredUpdateElements(updateElement, list, hashSet, false, new HashSet<UpdateElement>());
        for (ModuleInfo object : list) {
            Object object2;
            TreeSet<String> treeSet;
            Object object32;
            UpdateElement updateElement2;
            UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(object.getCodeNameBase());
            if (updateUnit == null || (updateElement2 = updateUnit.getInstalled()) == null || !updateUnit.getAvailableUpdates().isEmpty() && list.contains(object32 = ((ModuleUpdateElementImpl)Trampoline.API.impl((UpdateElement)((Object)(treeSet = updateUnit.getAvailableUpdates().get(0))))).getModuleInfo())) continue;
            for (Object object32 : Dependency.create((int)1, (String)object.getCodeName())) {
                object2 = DependencyAggregator.getAggregator((Dependency)object32);
                for (ModuleInfo moduleInfo : ((DependencyAggregator)object2).getDependening()) {
                    Module module = Utilities.getModuleInstance(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion());
                    if (module == null || !module.getProblems().isEmpty()) continue;
                    for (Object object4 : module.getDependencies()) {
                        if (!object2.equals(DependencyAggregator.getAggregator((Dependency)object4)) || DependencyChecker.checkDependencyModule((Dependency)object4, object)) continue;
                        hashSet.add((Dependency)object4);
                    }
                }
            }
            treeSet = new TreeSet<String>(Arrays.asList(object.getProvides()));
            object32 = new TreeSet<String>(Arrays.asList(((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2)).getModuleInfo().getProvides()));
            object32.removeAll(treeSet);
            object2 = object32.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                HashSet hashSet2 = new HashSet(Dependency.create((int)5, (String)string));
                hashSet2.addAll(Dependency.create((int)6, (String)string));
                for (Dependency dependency : hashSet2) {
                    Object object4;
                    object4 = DependencyAggregator.getAggregator(dependency);
                    for (ModuleInfo moduleInfo : ((DependencyAggregator)object4).getDependening()) {
                        Module module = Utilities.getModuleInstance(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion());
                        if (module == null || !module.getProblems().isEmpty()) continue;
                        for (Dependency dependency2 : module.getDependencies()) {
                            if (!object4.equals(DependencyAggregator.getAggregator(dependency2))) continue;
                            hashSet.add(dependency2);
                        }
                    }
                }
            }
        }
        HashSet hashSet2 = new HashSet(hashSet.size());
        for (Dependency dependency : hashSet) {
            hashSet2.add(dependency.toString());
        }
        return hashSet2;
    }

    static Set<String> getBrokenDependenciesInInstalledModules(UpdateElement updateElement) {
        assert (updateElement != null) : "UpdateElement cannot be null";
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (ModuleInfo object : Utilities.getModuleInfos(Collections.singleton(updateElement))) {
            hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(object, InstalledModuleProvider.getInstalledModules().values(), new HashSet<ModuleInfo>()));
        }
        HashSet hashSet2 = new HashSet();
        for (Dependency dependency : hashSet) {
            hashSet2.add(dependency.toString());
        }
        return hashSet2;
    }

    private static List<ModuleInfo> getModuleInfos(Collection<UpdateElement> collection) {
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>(collection.size());
        for (UpdateElement updateElement : collection) {
            if (updateElement.getUpdateUnit() != null && updateElement.getUpdateUnit().isPending()) continue;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            arrayList.addAll(updateElementImpl.getModuleInfos());
        }
        return arrayList;
    }

    private static Module getModuleInstance(String string, SpecificationVersion specificationVersion) {
        ModuleInfo moduleInfo = ModuleCache.getInstance().find(string);
        if (moduleInfo instanceof Module) {
            Module module = (Module)moduleInfo;
            if (specificationVersion == null) {
                err.log(Level.FINE, "no module {0} for null version", module);
                return module;
            }
            SpecificationVersion specificationVersion2 = module.getSpecificationVersion();
            if (specificationVersion2 == null) {
                err.log(Level.FINER, "No version for {0}", module);
                return null;
            }
            int n = specificationVersion2.compareTo((Object)specificationVersion);
            err.log(Level.FINER, "Comparing versions: {0}.compareTo({1}) = {2}", new Object[]{specificationVersion2, specificationVersion, n});
            return n >= 0 ? module : null;
        }
        return null;
    }

    public static boolean isAutomaticallyEnabled(String string) {
        Module module = Utilities.getModuleInstance(string, null);
        return module != null ? module.isAutoload() || module.isEager() || module.isFixed() : false;
    }

    public static ModuleInfo takeModuleInfo(UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        assert (updateElementImpl instanceof ModuleUpdateElementImpl);
        return ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo();
    }

    public static String getProductVersion() {
        if (productVersion == null) {
            String string = System.getProperty("netbeans.buildnumber");
            productVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)string);
        }
        return productVersion;
    }

    private static Node getModuleConfiguration(File file) {
        Document document;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            InputSource inputSource = new InputSource(bufferedInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            Utilities.getLogger().log(Level.INFO, "SAXException when reading " + file, sAXException);
            return null;
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, "IOException when reading " + file, iOException);
            return null;
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain <module> element.";
        if (document.getDocumentElement() == null) {
            return null;
        }
        return Utilities.getModuleElement(document.getDocumentElement());
    }

    private static Node getModuleElement(Element element) {
        Node node = null;
        assert ("module".equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList nodeList = element.getElementsByTagName("module_version");
        for (int i = 0; i < nodeList.getLength() && (node = Utilities.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private static Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem("last");
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private static File getAdditionalInformation(File file) {
        File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "additional_information.xml");
        return file2;
    }

    private static void writeAdditionalInformationToCluster(File file, Map<UpdateElementImpl, File> map) {
        if (map.isEmpty()) {
            return;
        }
        Document document = XMLUtil.createDocument((String)"module_additional", null, null, null);
        Element element = document.getDocumentElement();
        boolean bl = true;
        for (UpdateElementImpl updateElementImpl : map.keySet()) {
            File file2 = map.get(updateElementImpl);
            if (!file.equals(file2)) continue;
            Element element2 = document.createElement("module");
            element2.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), updateElementImpl.getInstallInfo().getDistribution()).getName());
            element2.setAttribute("source-display-name", updateElementImpl.getSource());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getAdditionalInformation(file));
    }

    public static UpdateItem createUpdateItem(UpdateItemImpl updateItemImpl) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.createUpdateItem(updateItemImpl);
    }

    public static UpdateItemImpl getUpdateItemImpl(UpdateItem updateItem) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.impl(updateItem);
    }

    public static boolean canDisable(Module module) {
        return module != null && module.isEnabled() && !Utilities.isEssentialModule((ModuleInfo)module) && !module.isAutoload() && !module.isEager();
    }

    public static boolean canEnable(Module module) {
        return module != null && !module.isEnabled() && !module.isAutoload() && !module.isEager();
    }

    public static boolean isElementInstalled(UpdateElement updateElement) {
        assert (updateElement != null) : "Invalid call isElementInstalled with null parameter.";
        if (updateElement == null) {
            return false;
        }
        return updateElement.equals(updateElement.getUpdateUnit().getInstalled());
    }

    public static boolean isKitModule(ModuleInfo moduleInfo) {
        return Main.getModuleSystem().isShowInAutoUpdateClient(moduleInfo);
    }

    public static boolean isEssentialModule(ModuleInfo moduleInfo) {
        Object object = moduleInfo.getAttribute(ATTR_ESSENTIAL);
        return Utilities.isFixed(moduleInfo) || object != null && Boolean.parseBoolean(object.toString());
    }

    public static boolean isFirstClassModule(UpdateElement updateElement) {
        String string = updateElement.getCodeName();
        String string2 = System.getProperty(PLUGIN_MANAGER_FIRST_CLASS_MODULES);
        if (string2 == null || string2.length() == 0) {
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            return updateElementImpl.isPreferredUpdate();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().trim().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return err;
    }

    public static Set<Module> findRequiredModules(Module module, ModuleManager moduleManager, Map<Module, Set<Module>> map) {
        Set set;
        if (map != null) {
            set = map.get(module);
            if (set == null) {
                set = moduleManager.getModuleInterdependencies(module, false, false, true);
                map.put(module, set);
            }
        } else {
            set = moduleManager.getModuleInterdependencies(module, false, false, true);
        }
        return set;
    }

    public static Set<Module> findDependingModules(Module module, ModuleManager moduleManager, Map<Module, Set<Module>> map) {
        Set<Module> set;
        if (map != null) {
            set = map.get(module);
            if (set == null) {
                set = Utilities.filterDependingOnOtherProvider(module, moduleManager.getModuleInterdependencies(module, true, false, true));
                map.put(module, set);
            }
        } else {
            set = Utilities.filterDependingOnOtherProvider(module, moduleManager.getModuleInterdependencies(module, true, false, true));
        }
        return set;
    }

    private static Set<Module> filterDependingOnOtherProvider(Module module, Set<Module> set) {
        HashSet<Module> hashSet = new HashSet<Module>();
        for (String string : module.getProvides()) {
            for (Module module2 : set) {
                for (Dependency dependency : module2.getDependencies()) {
                    if (dependency.getType() != 5 && dependency.getType() != 6 || !string.equals(dependency.getName())) continue;
                    assert (UpdateManagerImpl.getInstance().getInstalledProviders(string).contains(module)) : "Provides of token " + string + " " + UpdateManagerImpl.getInstance().getInstalledProviders(string) + " contains " + module;
                    if (UpdateManagerImpl.getInstance().getInstalledProviders(string).size() <= 1) continue;
                    hashSet.add(module2);
                }
            }
        }
        set.removeAll(hashSet);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.parse(string);
        }
    }

    public static boolean canWriteInCluster(File file) {
        assert (file != null) : "dir cannot be null";
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, UPDATE_DIR);
            File file3 = new File(file, DOWNLOAD_DIR);
            File file4 = file3.exists() ? file3 : (file2.exists() ? file2 : file);
            if (file4.canWrite() && file4.canRead()) {
                boolean bl = Utilities.canWrite(file4);
                Utilities.getLogger().log(Level.FINE, "Can write into {0}? {1}", new Object[]{file4, bl});
                return bl;
            }
            Utilities.getLogger().log(Level.FINE, "Can write into {0}? {1}", new Object[]{file4, file4.canWrite()});
            return file4.canWrite();
        }
        file.mkdirs();
        Utilities.getLogger().log(Level.FINE, "Can write into new cluster {0}? {1}", new Object[]{file, file.canWrite()});
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        if (org.openide.util.Utilities.isWindows()) {
            if (file.isFile()) {
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file, true);
                    Utilities.getLogger().log(Level.FINE, "{0} has write permission", file);
                }
                catch (IOException iOException) {
                    Utilities.getLogger().log(Level.FINE, file + " has no write permission", iOException);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                return true;
            }
            try {
                File file2 = File.createTempFile("dummy", null, file);
                file2.delete();
                Utilities.getLogger().log(Level.FINE, "{0} has write permission", file);
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.FINE, file + " has no write permission", iOException);
                return false;
            }
            return true;
        }
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore() {
        String string = Utilities.getPreferences().get(USER_KS_KEY, null);
        if (string == null) {
            return null;
        }
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            File file = new File(Utilities.getCacheDirectory(), string);
            if (!file.exists()) {
                KeyStore keyStore2 = null;
                return keyStore2;
            }
            inputStream = new BufferedInputStream(new FileInputStream(file));
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(inputStream, KS_USER_PASSWORD.toCharArray());
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKeyStore(KeyStore keyStore) {
        OutputStream outputStream = null;
        try {
            File file = new File(Utilities.getCacheDirectory(), USER_KS_FILE_NAME);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            keyStore.store(outputStream, KS_USER_PASSWORD.toCharArray());
            Utilities.getPreferences().put(USER_KS_KEY, USER_KS_FILE_NAME);
        }
        catch (KeyStoreException keyStoreException) {
            Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    public static void addCertificates(Collection<Certificate> collection) {
        KeyStore keyStore = Utilities.loadKeyStore();
        if (keyStore == null) {
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, KS_USER_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
                return;
            }
            catch (CertificateException certificateException) {
                Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
                return;
            }
        }
        for (Certificate certificate : collection) {
            try {
                if (keyStore.getCertificateAlias(certificate) != null) continue;
                String string = null;
                for (int i = 0; i < 9999 && keyStore.containsAlias(string = "genAlias" + i); ++i) {
                }
                if (string == null) {
                    Utilities.getLogger().log(Level.INFO, "Too many certificates with {0}", certificate);
                }
                keyStore.setCertificateEntry(string, certificate);
            }
            catch (KeyStoreException keyStoreException) {
                Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
            }
        }
        Utilities.storeKeyStore(keyStore);
    }

    public static void writeFirstClassModule(String string) {
        if (string == null) {
            Utilities.getPreferences().put(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
            return;
        }
        String string2 = Utilities.getPreferences().get(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
        string2 = string2.isEmpty() ? string : string2 + "," + string;
        Utilities.getPreferences().put(PLUGIN_MANAGER_FIRST_CLASS_MODULES, string2);
    }

    private static File getCacheDirectory() {
        return Places.getCacheSubdirectory((String)"catalogcache");
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static {
        err = Logger.getLogger(Utilities.class.getName());
        cachedInfo2RequestedReference = null;
        cachedInfosReference = null;
        cachedResultReference = null;
        productVersion = null;
    }

    private static class KeyStoreProviderListener
    implements LookupListener {
        private KeyStoreProviderListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Utilities.result = null;
        }
    }
}

