/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.openide.loaders.AWTTask;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.openide.awt.AcceleratorBinding;
import org.openide.awt.Actions;
import org.openide.awt.DynaMenuModel;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class MenuBar
extends JMenuBar
implements Externalizable {
    private MenuBarFolder menuBarFolder;
    static final long serialVersionUID = -4721949937356581268L;

    public MenuBar() {
    }

    public MenuBar(DataFolder dataFolder) {
        this();
        DataFolder dataFolder2 = dataFolder;
        if (dataFolder2 == null) {
            FileObject fileObject = FileUtil.getConfigRoot();
            FileObject fileObject2 = null;
            try {
                fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)"Menu");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (fileObject2 == null) {
                throw new IllegalStateException("No Menu/");
            }
            dataFolder2 = DataFolder.findFolder(fileObject2);
        }
        this.startLoading(dataFolder2);
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuBar.this.updateUI();
                }
            });
        }
        if (dataFolder != null) {
            this.getAccessibleContext().setAccessibleDescription(dataFolder.getName());
        }
    }

    @Override
    public boolean isOpaque() {
        if (null != UIManager.get("NbMainWindow.showCustomBackground")) {
            return !UIManager.getBoolean("NbMainWindow.showCustomBackground");
        }
        return super.isOpaque();
    }

    @Override
    public void updateUI() {
        if (EventQueue.isDispatchThread()) {
            super.updateUI();
            boolean bl = "GTK".equals(UIManager.getLookAndFeel().getID());
            if (!bl) {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    @Override
    public int getMenuCount() {
        if (this.menuBarFolder != null && !Thread.holdsLock(this.getTreeLock())) {
            this.menuBarFolder.waitFinished();
        }
        return super.getMenuCount();
    }

    @Override
    public void addImpl(Component component, Object object, int n) {
        if (Utilities.isMac() && Boolean.getBoolean("apple.laf.useScreenMenuBar") && !(component instanceof JMenu)) {
            return;
        }
        super.addImpl(component, object, n);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (Utilities.isMac()) {
            boolean bl2;
            int n2 = keyEvent.getModifiers();
            boolean bl3 = (n2 & 2) != 0;
            boolean bl4 = bl2 = (n2 & 8) != 0;
            if (bl2) {
                return false;
            }
            if (bl2 && !bl3) {
                n2 &= 0xFFFFFFF7;
                n2 &= 0xFFFFFDFF;
                n2 |= 2;
                n2 |= 0x80;
            } else if (!bl2 && bl3) {
                n2 &= 0xFFFFFFFD;
                n2 &= 0xFFFFFF7F;
                n2 |= 8;
                n2 |= 0x200;
            } else if (!bl2 && !bl3) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            MarkedKeyEvent markedKeyEvent = new MarkedKeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), n2, keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
            KeyStroke keyStroke2 = null;
            if (null != keyStroke) {
                keyStroke2 = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke((int)keyStroke.getKeyChar(), n2) : KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n2, !keyStroke.isOnKeyRelease());
            }
            boolean bl5 = super.processKeyBinding(keyStroke2, markedKeyEvent, n, bl);
            if (markedKeyEvent.isConsumed()) {
                keyEvent.consume();
            }
            return bl5;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void waitFinished() {
        this.menuBarFolder.instanceFinished();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.menuBarFolder.getFolder());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.startLoading((DataFolder)objectInput.readObject());
    }

    void startLoading(DataFolder dataFolder) {
        this.menuBarFolder = new MenuBarFolder(dataFolder);
    }

    static void allInstances(InstanceCookie[] instanceCookieArray, List<Object> list) {
        Exception exception = null;
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Object object;
            Exception exception2 = null;
            try {
                object = instanceCookieArray[i].instanceCreate();
                if (object == LazyMenu.SEPARATOR) {
                    object = new JSeparator();
                }
                list.add(object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception2 = classNotFoundException;
            }
            catch (IOException iOException) {
                exception2 = iOException;
            }
            if (exception2 == null) continue;
            object = exception2;
            while (true) {
                if (((Throwable)object).getCause() == null) {
                    if (object instanceof ClassNotFoundException) {
                        exception2 = new ClassNotFoundException(((Throwable)object).getMessage(), exception);
                        exception2.setStackTrace(((Throwable)object).getStackTrace());
                        break;
                    }
                    ((Throwable)object).initCause(exception);
                    break;
                }
                object = ((Throwable)object).getCause();
            }
            exception = exception2;
        }
        if (exception != null) {
            Exceptions.printStackTrace(exception);
        }
    }

    static {
        try {
            Class.forName(AcceleratorBinding.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }

    private static final class LazySeparator
    extends JSeparator
    implements Runnable {
        @Override
        public void updateUI() {
            if (EventQueue.isDispatchThread()) {
                super.updateUI();
            } else {
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.updateUI();
        }
    }

    private static class LazyMenu
    extends JMenu
    implements NodeListener,
    Runnable,
    ChangeListener {
        static final JSeparator SEPARATOR = new LazySeparator();
        final DataFolder master;
        final boolean icon;
        final MenuFolder slave;
        final DynaMenuModel dynaModel;
        private boolean selected = false;

        public LazyMenu(DataFolder dataFolder, boolean bl) {
            Enumeration enumeration;
            this.master = dataFolder;
            this.icon = bl;
            this.dynaModel = new DynaMenuModel();
            this.slave = new MenuFolder();
            this.setName(dataFolder.getName());
            FileObject fileObject = dataFolder.getPrimaryFile();
            Object object = fileObject.getAttribute("property-prefix");
            if (object instanceof String) {
                enumeration = fileObject.getAttributes();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.startsWith((String)object)) continue;
                    this.putClientProperty(string.substring(((String)object).length()), fileObject.getAttribute(string));
                }
            }
            enumeration = this.master.getNodeDelegate();
            enumeration.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)enumeration));
            Mutex.EVENT.readAccess((Runnable)this);
            this.getModel().addChangeListener(this);
        }

        @Override
        public void updateUI() {
            if (EventQueue.isDispatchThread()) {
                super.updateUI();
            } else {
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        @Override
        public int getItemCount() {
            this.conditionalInitialize();
            return super.getItemCount();
        }

        @Override
        public int getMenuComponentCount() {
            this.conditionalInitialize();
            return super.getMenuComponentCount();
        }

        @Override
        public Component[] getMenuComponents() {
            this.conditionalInitialize();
            return super.getMenuComponents();
        }

        private void conditionalInitialize() {
            if (Thread.holdsLock(this.getTreeLock())) {
                return;
            }
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                    if (!"com.apple.laf.AquaRootPaneUI".equals(stackTraceElement.getClassName())) continue;
                    if ("windowDeactivated".equals(stackTraceElement.getMethodName())) {
                        return;
                    }
                    if (!"windowActivated".equals(stackTraceElement.getMethodName())) continue;
                    return;
                }
            }
            this.doInitialize();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (Utilities.isMac()) {
                boolean bl2;
                int n2 = keyEvent.getModifiers();
                boolean bl3 = (n2 & 2) != 0;
                boolean bl4 = bl2 = (n2 & 8) != 0;
                if (bl2 && keyEvent instanceof MarkedKeyEvent) {
                    n2 &= 0xFFFFFFFD;
                    n2 &= 0xFFFFFF7F;
                    n2 |= 8;
                    MarkedKeyEvent markedKeyEvent = new MarkedKeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), n2 |= 0x200, keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
                    KeyStroke keyStroke2 = null;
                    if (null != keyStroke) {
                        keyStroke2 = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke((int)keyStroke.getKeyChar(), n2) : KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n2, !keyStroke.isOnKeyRelease());
                    }
                    boolean bl5 = super.processKeyBinding(keyStroke2, markedKeyEvent, n, bl);
                    if (markedKeyEvent.isConsumed()) {
                        keyEvent.consume();
                    }
                    return bl5;
                }
                if (!bl2) {
                    return super.processKeyBinding(keyStroke, keyEvent, n, bl);
                }
                return false;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        private void updateProps() {
            assert (EventQueue.isDispatchThread());
            this.getModel().removeChangeListener(this);
            if (this.master.isValid()) {
                Node node = this.master.getNodeDelegate();
                Mnemonics.setLocalizedText((AbstractButton)this, (String)node.getDisplayName());
                if (this.icon) {
                    this.setIcon(new ImageIcon(node.getIcon(1)));
                }
            } else {
                this.setText(this.master.getName());
                this.setIcon(null);
            }
            this.getModel().addChangeListener(this);
        }

        @Override
        public void run() {
            if (this.master == null) {
                return;
            }
            this.updateUI();
            this.updateProps();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName()) || "icon".equals(propertyChangeEvent.getPropertyName())) {
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (Utilities.isMac()) {
                if (this.selected) {
                    this.selected = false;
                } else {
                    this.selected = true;
                    this.doInitialize();
                    this.dynaModel.checkSubmenu(this);
                }
            }
        }

        @Override
        public void setPopupMenuVisible(boolean bl) {
            boolean bl2;
            if (!Utilities.isMac() && bl != (bl2 = this.isPopupMenuVisible()) && bl) {
                this.doInitialize();
                this.dynaModel.checkSubmenu(this);
            }
            super.setPopupMenuVisible(bl);
        }

        private void doInitialize() {
            if (this.slave != null) {
                this.slave.waitFinishedSuper();
            }
        }

        static {
            new DynaMenuModel();
        }

        private class MenuFolder
        extends FolderInstance {
            private Map<Object, FileObject> cookiesToFiles;

            public MenuFolder() {
                super(LazyMenu.this.master);
                this.cookiesToFiles = new HashMap<Object, FileObject>();
                DataObjectAccessor.DEFAULT.precreateInstances(this);
            }

            @Override
            public String instanceName() {
                return LazyMenu.class.getName();
            }

            public Class instanceClass() {
                return JMenu.class;
            }

            @Override
            public Object instanceCreate() throws IOException, ClassNotFoundException {
                return LazyMenu.this;
            }

            @Override
            public void waitFinished() {
            }

            void waitFinishedSuper() {
                super.waitFinished();
            }

            @Override
            protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
                Object object = instanceCookie.instanceClass().equals(JSeparator.class) ? SEPARATOR : super.instanceForCookie(dataObject, instanceCookie);
                this.cookiesToFiles.put(object, dataObject.getPrimaryFile());
                return object;
            }

            @Override
            protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
                Class clazz = instanceCookie.instanceClass();
                boolean bl = Action.class.isAssignableFrom(clazz);
                if (bl) {
                    instanceCookie.instanceCreate();
                }
                boolean bl2 = Presenter.Menu.class.isAssignableFrom(clazz) || JMenuItem.class.isAssignableFrom(clazz) || JSeparator.class.isAssignableFrom(clazz) || bl;
                return bl2 ? instanceCookie : null;
            }

            @Override
            protected InstanceCookie acceptFolder(DataFolder dataFolder) {
                boolean bl = dataFolder.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null;
                return new LazyMenu((DataFolder)dataFolder, (boolean)bl).slave;
            }

            @Override
            protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
                LazyMenu lazyMenu = LazyMenu.this;
                assert (EventQueue.isDispatchThread()) : Thread.currentThread().getName();
                LinkedList<Object> linkedList = new LinkedList<Object>();
                MenuBar.allInstances(instanceCookieArray, linkedList);
                if (linkedList.isEmpty()) {
                    JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(DataObject.class, (String)"CTL_EmptyMenu"));
                    jMenuItem.setEnabled(false);
                    lazyMenu.add(jMenuItem);
                }
                lazyMenu.dynaModel.loadSubmenu(linkedList, lazyMenu, true, this.cookiesToFiles);
                return lazyMenu;
            }

            @Override
            protected Task postCreationTask(Runnable runnable) {
                return new AWTTask(runnable, this);
            }
        }
    }

    private static final class MarkedKeyEvent
    extends KeyEvent {
        MarkedKeyEvent(Component component, int n, long l, int n2, int n3, char c, int n4) {
            super(component, n, l, n2, n3, c, n4);
        }
    }

    private final class MenuBarFolder
    extends FolderInstance {
        private ArrayList<Component> managed;
        private Map<Object, DataObject> cookiesToObjects;

        public MenuBarFolder(DataFolder dataFolder) {
            super(dataFolder);
            this.cookiesToObjects = new HashMap<Object, DataObject>();
            DataObjectAccessor.DEFAULT.precreateInstances(this);
            new DynaMenuModel();
            this.recreate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            Object object = MenuBar.this.getTreeLock();
            synchronized (object) {
                Iterator<Component> iterator = this.getManaged().iterator();
                while (iterator.hasNext()) {
                    MenuBar.this.remove(iterator.next());
                }
                this.getManaged().clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addComponent(Component component) {
            Object object = MenuBar.this.getTreeLock();
            synchronized (object) {
                MenuBar.this.add(component, this.getManaged().size());
                this.getManaged().add(component);
            }
        }

        @Override
        public String instanceName() {
            return MenuBar.class.getName();
        }

        public Class instanceClass() {
            return MenuBar.class;
        }

        @Override
        protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Object object = super.instanceForCookie(dataObject, instanceCookie);
            this.cookiesToObjects.put(object, dataObject);
            return object;
        }

        @Override
        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz = instanceCookie.instanceClass();
            boolean bl = Component.class.isAssignableFrom(clazz) || Presenter.Toolbar.class.isAssignableFrom(clazz) || Action.class.isAssignableFrom(clazz);
            return bl ? instanceCookie : null;
        }

        @Override
        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return new LazyMenu((DataFolder)dataFolder, (boolean)false).slave;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            MenuBar.allInstances(instanceCookieArray, linkedList);
            MenuBar menuBar = MenuBar.this;
            if (linkedList.equals(Arrays.asList(menuBar.getComponents()))) {
                return menuBar;
            }
            this.cleanUp();
            try {
                for (Object e : linkedList) {
                    Component component = this.convertToComponent(e);
                    if (component == null) continue;
                    this.addComponent(component);
                }
            }
            finally {
                this.cookiesToObjects.clear();
            }
            menuBar.validate();
            menuBar.repaint();
            return menuBar;
        }

        private Component convertToComponent(Object object) {
            Component component = null;
            if (object instanceof Component) {
                component = (Component)object;
            } else if (object instanceof Presenter.Toolbar) {
                DataObject dataObject = this.cookiesToObjects.get(object);
                if (object instanceof Action && dataObject != null) {
                    AcceleratorBinding.setAccelerator((Action)((Action)object), (FileObject)dataObject.getPrimaryFile());
                }
                component = ((Presenter.Toolbar)object).getToolbarPresenter();
            } else if (object instanceof Action) {
                Action action = (Action)object;
                JButton jButton = new JButton();
                Actions.connect((AbstractButton)jButton, (Action)action);
                component = jButton;
            }
            if (component instanceof JButton) {
                ((JButton)component).setBorderPainted(false);
                ((JButton)component).setMargin(new Insets(0, 2, 0, 2));
            }
            return component;
        }

        DataFolder getFolder() {
            return this.folder;
        }

        @Override
        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable, this);
        }

        private ArrayList<Component> getManaged() {
            assert (Thread.holdsLock(MenuBar.this.getTreeLock()));
            if (this.managed == null) {
                this.managed = new ArrayList();
            }
            return this.managed;
        }
    }
}

