/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.templates.TemplateRegistration;
import org.netbeans.api.templates.TemplateRegistrations;
import org.openide.WizardDescriptor;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class TemplateProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(TemplateRegistration.class.getCanonicalName(), TemplateRegistrations.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(TemplateRegistration.class)) {
            annotation = element.getAnnotation(TemplateRegistration.class);
            if (annotation == null) continue;
            this.process(element, (TemplateRegistration)annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(TemplateRegistrations.class)) {
            annotation = element.getAnnotation(TemplateRegistrations.class);
            if (annotation == null) continue;
            for (TemplateRegistration templateRegistration : annotation.value()) {
                this.process(element, templateRegistration);
            }
        }
        return true;
    }

    private void process(Element element, TemplateRegistration templateRegistration) throws LayerGenerationException {
        String string;
        LayerBuilder layerBuilder = this.layer(new Element[]{element});
        if (!templateRegistration.id().isEmpty()) {
            if (templateRegistration.content().length > 0) {
                throw new LayerGenerationException("Cannot specify both id and content", element, this.processingEnv, (Annotation)templateRegistration);
            }
            string = templateRegistration.id();
        } else if (templateRegistration.content().length > 0) {
            string = TemplateProcessor.basename(templateRegistration.content()[0]);
        } else if (element.getKind() == ElementKind.CLASS) {
            string = ((TypeElement)element).getQualifiedName().toString().replace('.', '-');
        } else if (element.getKind() == ElementKind.METHOD) {
            string = ((TypeElement)element.getEnclosingElement()).getQualifiedName().toString().replace('.', '-') + '-' + element.getSimpleName();
        } else {
            throw new LayerGenerationException("cannot use @Template on a package without specifying content", element, this.processingEnv, (Annotation)templateRegistration);
        }
        String string2 = "Templates/" + templateRegistration.folder() + '/';
        LayerBuilder.File file = layerBuilder.file(string2 + string);
        file.boolvalue("template", true);
        file.position(templateRegistration.position());
        if (!templateRegistration.displayName().isEmpty()) {
            file.bundlevalue("displayName", templateRegistration.displayName());
        }
        if (!templateRegistration.iconBase().isEmpty()) {
            layerBuilder.validateResource(templateRegistration.iconBase(), element, (Annotation)templateRegistration, "iconBase", true);
            file.stringvalue("iconBase", templateRegistration.iconBase());
        } else if (templateRegistration.content().length == 0) {
            throw new LayerGenerationException("Must specify iconBase if content is not specified", element, this.processingEnv, (Annotation)templateRegistration);
        }
        if (!templateRegistration.description().isEmpty()) {
            file.urlvalue("instantiatingWizardURL", this.contentURI(element, templateRegistration.description(), layerBuilder, templateRegistration, "description"));
        }
        if (element.getKind() != ElementKind.PACKAGE) {
            file.instanceAttribute("instantiatingIterator", WizardDescriptor.InstantiatingIterator.class);
        }
        if (templateRegistration.content().length > 0) {
            file.url(this.contentURI(element, templateRegistration.content()[0], layerBuilder, templateRegistration, "content").toString());
            for (int i = 1; i < templateRegistration.content().length; ++i) {
                layerBuilder.file(string2 + TemplateProcessor.basename(templateRegistration.content()[i])).url(this.contentURI(element, templateRegistration.content()[i], layerBuilder, templateRegistration, "content").toString()).position(0).write();
            }
        }
        if (!templateRegistration.scriptEngine().isEmpty()) {
            file.stringvalue("javax.script.ScriptEngine", templateRegistration.scriptEngine());
        }
        if (templateRegistration.category().length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : templateRegistration.category()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string3);
            }
            file.stringvalue("templateCategory", stringBuilder.toString());
        }
        file.boolvalue("requireProject", templateRegistration.requireProject());
        file.write();
    }

    private static String basename(String string) {
        return string.replaceFirst(".+/", "").replaceFirst("[.]template$", "");
    }

    private URI contentURI(Element element, String string, LayerBuilder layerBuilder, TemplateRegistration templateRegistration, String string2) throws LayerGenerationException {
        String string3 = LayerBuilder.absolutizeResource((Element)element, (String)string);
        layerBuilder.validateResource(string3, element, (Annotation)templateRegistration, string2, false);
        try {
            return new URI("nbresloc", "/" + string3, null).normalize();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new LayerGenerationException("could not translate " + string3, element, this.processingEnv, (Annotation)templateRegistration);
        }
    }
}

