/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.LocalConnectionDescriptor;
import com.jrockit.mc.browser.attach.internal.ExecuteTunnler;
import com.jrockit.mc.common.jvm.Connectable;
import com.jrockit.mc.common.jvm.JVMArch;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.jvm.JVMType;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.ServerDescriptor;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.monitor.VmIdentifier;
import sun.management.ConnectorAddressLink;
import sun.management.counter.perf.InstrumentationException;
import sun.tools.attach.HotSpotVirtualMachine;

public class LocalJVMToolkit {
    private static long SEQ_NUMBER = 0L;
    private static boolean isErrorMessageSent = false;
    private static boolean m_unconnectableInited = false;
    private static boolean m_showUnconnectable = false;
    private static Map<Object, DiscoveryEntry> last = new WeakHashMap<Object, DiscoveryEntry>();
    static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    static final String JVM_ARGS_PROP = "sun.jvm.args";
    static final String JVM_FLAGS_PROP = "sun.jvm.flags";
    static final String JAVA_COMMAND_PROP = "sun.java.command";

    private LocalJVMToolkit() {
    }

    public static DiscoveryEntry[] getLocalConnections() {
        HashMap<Object, DiscoveryEntry> map = new HashMap<Object, DiscoveryEntry>();
        LocalJVMToolkit.populateAttachableVMs(map);
        LocalJVMToolkit.populateMonitoredVMs(map, LocalJVMToolkit.showUnconnectableJvms());
        last = map;
        ArrayList<DiscoveryEntry> list = new ArrayList<DiscoveryEntry>(map.values());
        return list.toArray(new DiscoveryEntry[list.size()]);
    }

    private static final boolean showUnconnectableJvms() {
        IPreferenceStore store;
        if (!m_unconnectableInited && (store = AttachPlugin.getDefault().getPreferenceStore()) != null) {
            m_showUnconnectable = store.getBoolean("showUnconnectable");
            store.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("showUnconnectable")) {
                        m_showUnconnectable = (Boolean)event.getNewValue();
                    }
                }
            });
            m_unconnectableInited = true;
        }
        return m_showUnconnectable;
    }

    private static void populateMonitoredVMs(HashMap<Object, DiscoveryEntry> map, boolean includeUnconnectables) {
        Set<Integer> vms;
        MonitoredHost host = LocalJVMToolkit.getMonitoredHost();
        try {
            vms = host.activeVms();
        }
        catch (MonitorException mx) {
            throw new InternalError(mx.getMessage());
        }
        for (Integer vmid : vms) {
            if (!(vmid instanceof Integer) || map.containsKey(vmid)) continue;
            DiscoveryEntry connDesc = last.get(vmid);
            if (connDesc == null) {
                connDesc = LocalJVMToolkit.createMonitoredJvmDescriptor(host, vmid);
            }
            if (!includeUnconnectables && (connDesc == null || connDesc.serverDescriptor.getJvmInfo().isUnconnectable().booleanValue())) continue;
            map.put(vmid, connDesc);
        }
    }

    private static DiscoveryEntry createMonitoredJvmDescriptor(MonitoredHost host, Integer vmid) {
        int pid = vmid;
        String name = vmid.toString();
        Connectable connectable = Connectable.NO;
        JVMType type = JVMType.OTHER;
        JVMArch jvmArch = JVMArch.OTHER;
        boolean isDebug = false;
        String address = null;
        String version = null;
        String vmVersion = null;
        try {
            MonitoredVm mvm = host.getMonitoredVm(new VmIdentifier(name));
            try {
                name = MonitoredVmUtil.commandLine(mvm);
                StringMonitor sm = (StringMonitor)mvm.findByName("java.property.java.vm.name");
                if (sm != null) {
                    type = LocalJVMToolkit.getJVMType(sm.stringValue());
                }
                if ((sm = (StringMonitor)mvm.findByName("java.property.java.version")) != null) {
                    version = sm.stringValue();
                }
                if ((sm = (StringMonitor)mvm.findByName("java.property.java.vm.version")) != null) {
                    vmVersion = sm.stringValue();
                    if (version == null) {
                        version = type == JVMType.JROCKIT ? LocalJVMToolkit.decodeJavaVersion(vmVersion) : LocalJVMToolkit.parseJavaVersion(vmVersion);
                    }
                }
                if (version == null) {
                    version = "0";
                }
                if (sm != null) {
                    isDebug = LocalJVMToolkit.isDebug(sm.stringValue());
                }
                jvmArch = LocalJVMToolkit.getArch(vmid);
                JMXServiceURL inMemURL = null;
                try {
                    inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(vmid);
                }
                catch (IOException e) {
                    AttachPlugin.getPluginLogger().log(Level.WARNING, "Got exception when trying to get in-memory url for jvm with PID " + vmid, e);
                }
                if (inMemURL != null) {
                    connectable = Connectable.MGMNT_AGENT_STARTED;
                }
                address = ConnectorAddressLink.importFrom((int)pid);
            }
            finally {
                mvm.detach();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DiscoveryEntry connDesc = LocalJVMToolkit.createDescriptor(name, vmid, connectable, type, jvmArch, address, version, isDebug, vmVersion);
        return connDesc;
    }

    private static JVMArch getArch(Integer vmid) throws IOException {
        JVMArch jvmArch = JVMArch.OTHER;
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (vms != null) {
            for (VirtualMachineDescriptor vmd : vms) {
                if (vmid != Integer.parseInt(vmd.id())) continue;
                try {
                    VirtualMachine vm = VirtualMachine.attach(vmd);
                    try {
                        jvmArch = JVMArch.getJVMArch((Properties)vm.getSystemProperties());
                    }
                    finally {
                        vm.detach();
                    }
                }
                catch (AttachNotSupportedException x) {
                    if (x.getMessage().contains("Unable to attach to 32-bit process")) {
                        jvmArch = JVMArch.BIT32;
                        break;
                    }
                    if (!x.getMessage().contains("Unable to attach to 64-bit process")) break;
                    jvmArch = JVMArch.BIT64;
                }
                break;
            }
        }
        return jvmArch;
    }

    private static JVMType getJVMType(String jvmName) {
        if (ConnectionToolkit.isJRockitJVMName((String)jvmName)) {
            return JVMType.JROCKIT;
        }
        if (ConnectionToolkit.isHotspotJVMName((String)jvmName)) {
            return JVMType.HOTSPOT;
        }
        return JVMType.OTHER;
    }

    private static boolean isDebug(String stringValue) {
        return stringValue.toUpperCase().contains("DEBUG");
    }

    private static void populateAttachableVMs(Map<Object, DiscoveryEntry> map) {
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (vms == null) {
            return;
        }
        for (VirtualMachineDescriptor vmd : vms) {
            try {
                Integer vmid = Integer.valueOf(vmd.id());
                if (map.containsKey(vmid)) continue;
                AttachPlugin.getPluginLogger().finest("Local attach resolving PID " + vmid);
                DiscoveryEntry connDesc = last.get(vmid);
                if (connDesc == null) {
                    connDesc = LocalJVMToolkit.createAttachableJvmDescriptor(vmd);
                }
                if (connDesc == null || connDesc.serverDescriptor.getJvmInfo().isUnconnectable().booleanValue()) continue;
                map.put(vmid, connDesc);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static DiscoveryEntry createAttachableJvmDescriptor(VirtualMachineDescriptor vmd) {
        Connectable connectable;
        DiscoveryEntry connDesc = null;
        boolean isDebug = false;
        JVMType jvmType = JVMType.OTHER;
        JVMArch jvmArch = JVMArch.OTHER;
        String address = null;
        String version = null;
        String commandLine = null;
        String jvmVersion = null;
        try {
            VirtualMachine vm = VirtualMachine.attach(vmd);
            try {
                connectable = Connectable.ATTACHABLE;
                Properties props = null;
                try {
                    props = vm.getSystemProperties();
                }
                catch (IOException e) {
                    AttachPlugin.getPluginLogger().log(Level.FINER, "Got the following exception message when getting system properties from vm with PID " + vmd + ": " + e.getMessage());
                }
                if (props != null) {
                    String vmName = props.getProperty("java.vm.name");
                    jvmType = LocalJVMToolkit.getJVMType(vmName);
                    version = props.getProperty("java.version");
                    jvmVersion = props.getProperty("java.vm.version");
                    isDebug = LocalJVMToolkit.isDebug(jvmVersion);
                    jvmArch = JVMArch.getJVMArch((Properties)props);
                }
                Properties agentProps = vm.getAgentProperties();
                address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                commandLine = LocalJVMToolkit.resolveCommandLine(vm, vmd.displayName(), props, agentProps);
            }
            finally {
                vm.detach();
            }
        }
        catch (AttachNotSupportedException x) {
            connectable = Connectable.NO;
        }
        catch (Throwable t) {
            if (!isErrorMessageSent) {
                AttachPlugin.getPluginLogger().log(Level.FINER, "Scanning using attach/getAgentProperties failed on " + vmd + ". This message will only be printed once, so errors for subsequent PIDs will not be logged...", t);
                isErrorMessageSent = true;
            }
            return null;
        }
        if (connectable.isAttachable()) {
            connDesc = LocalJVMToolkit.createDescriptor(commandLine, Integer.valueOf(vmd.id()), connectable, jvmType, jvmArch, address, version, isDebug, jvmVersion);
        }
        AttachPlugin.getPluginLogger().info("Done resolving PID " + vmd);
        return connDesc;
    }

    private static MonitoredHost getMonitoredHost() {
        try {
            return MonitoredHost.getMonitoredHost(new HostIdentifier(null));
        }
        catch (MonitorException e) {
            throw new InternalError(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static String resolveCommandLine(VirtualMachine vm, String displayName, Properties vmProps, Properties agentProps) {
        String eclipseVmargs;
        if (LocalJVMToolkit.isValidDisplayName(displayName)) {
            return displayName;
        }
        if (vmProps != null && (eclipseVmargs = vmProps.getProperty("eclipse.vmargs")) != null) {
            String[] parts = eclipseVmargs.split("java.class.path=");
            return parts.length == 2 ? parts[1] : eclipseVmargs;
        }
        if (agentProps != null) {
            String jvmCmd = (String)agentProps.get(JAVA_COMMAND_PROP);
            if (jvmCmd == null || jvmCmd.length() == 0) {
                jvmCmd = (String)agentProps.get(JVM_ARGS_PROP);
            }
            if (jvmCmd == null || jvmCmd.length() == 0) {
                jvmCmd = (String)agentProps.get(JVM_FLAGS_PROP);
            }
            if (jvmCmd != null && jvmCmd.length() > 0) {
                return jvmCmd;
            }
        }
        return displayName;
    }

    private static boolean isValidDisplayName(String displayName) {
        return displayName != null && !displayName.equals("") && !displayName.equals("Unknown");
    }

    private static DiscoveryEntry createDescriptor(String commandLine, int pid, Connectable connectable, JVMType type, JVMArch arch, String address, String version, boolean isDebug, String vmVersion) {
        JVMDescriptor jvmInfo = new JVMDescriptor(version, type, arch, commandLine, Integer.valueOf(pid), isDebug, connectable);
        LocalConnectionDescriptor lcd = new LocalConnectionDescriptor(pid, address, connectable == Connectable.ATTACHABLE);
        String guid = "Local-[PID:" + pid + ", seq:" + SEQ_NUMBER++ + "]";
        ServerDescriptor sd = new ServerDescriptor(guid, null, jvmInfo);
        return new DiscoveryEntry((IServerDescriptor)sd, lcd);
    }

    static String decodeJavaVersion(String version) {
        String specVersion = version;
        if (version.startsWith("R") || version.startsWith("P") || version.startsWith("DEBUG-")) {
            specVersion = version.startsWith("DEBUG-") ? version.split("-")[4] : version.split("-")[3];
        }
        return LocalJVMToolkit.parseJavaVersion(specVersion);
    }

    static String parseJavaVersion(String version) {
        int onePointIndex = version.indexOf("1.");
        if (onePointIndex >= 0) {
            int nextPointIndex = version.indexOf(46, onePointIndex + 2);
            if (nextPointIndex >= 0 && LocalJVMToolkit.isNumber(version.substring(onePointIndex + 2, nextPointIndex))) {
                return version.substring(onePointIndex, nextPointIndex);
            }
            return version.substring(onePointIndex);
        }
        return null;
    }

    private static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static synchronized DiscoveryEntry[] getAttachableJVMs() {
        return LocalJVMToolkit.getLocalConnections();
    }

    public static String executeCommandForPid(String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        VirtualMachine vm = VirtualMachine.attach(pid);
        String result = LocalJVMToolkit.executeCommandForPid(vm, pid, command);
        vm.detach();
        return result;
    }

    public static String executeCommandForPid(VirtualMachine vm, String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        int n;
        HotSpotVirtualMachine hvm = (HotSpotVirtualMachine)vm;
        InputStream in = ExecuteTunnler.execute(hvm, "jcmd", new Object[]{command});
        byte[] b = new byte[256];
        StringBuffer buf = new StringBuffer();
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, "UTF-8");
            buf.append(s);
        } while (n > 0);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static JMXServiceURL getInMemoryURLFromPID(int pid) throws IOException {
        JMXServiceURL inMemURL = null;
        String address = null;
        try {
            address = ConnectorAddressLink.importFrom((int)pid);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InstrumentationException instrumentationException) {
            // empty catch block
        }
        if (address != null) {
            inMemURL = new JMXServiceURL(address);
        }
        return inMemURL;
    }

    public static class DiscoveryEntry {
        IServerDescriptor serverDescriptor;
        IConnectionDescriptor connectionDescriptor;

        public DiscoveryEntry(IServerDescriptor serverDescriptor, IConnectionDescriptor descriptor) {
            this.serverDescriptor = serverDescriptor;
            this.connectionDescriptor = descriptor;
        }
    }
}

