/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;

public final class FileOpenServiceImpl
implements FileOpenService {
    static FileOpenServiceImpl _sharedInstance = null;
    static FileSaveServiceImpl _fileSaveServiceImpl;
    private ApiDialog _apiDialog;

    private FileOpenServiceImpl(FileSaveServiceImpl fileSaveServiceImpl) {
        _fileSaveServiceImpl = fileSaveServiceImpl;
        this._apiDialog = new ApiDialog();
    }

    public static synchronized FileOpenService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new FileOpenServiceImpl((FileSaveServiceImpl)FileSaveServiceImpl.getInstance());
        }
        return _sharedInstance;
    }

    public FileContents openFileDialog(final String string, final String[] stringArray) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 8, false, null))[0] != null) {
                            try {
                                _fileSaveServiceImpl.setLastPath(fileArray[0].getPath());
                                return new FileContentsImpl(fileArray[0], FileSaveServiceImpl.computeMaxLength(fileArray[0].length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null);
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    public FileContents[] openMultiFileDialog(final String string, final String[] stringArray) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 8, true, null)) != null && fileArray.length > 0) {
                            FileContents[] fileContentsArray = new FileContents[fileArray.length];
                            for (int i = 0; i < fileArray.length; ++i) {
                                try {
                                    fileContentsArray[i] = new FileContentsImpl(fileArray[i], FileSaveServiceImpl.computeMaxLength(fileArray[i].length()));
                                    _fileSaveServiceImpl.setLastPath(fileArray[i].getPath());
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return fileContentsArray;
                        }
                        return null;
                    }
                }, null);
            }
        };
        try {
            return (FileContents[])Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    synchronized boolean askUser() {
        Object object;
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        final LocalApplicationProperties localApplicationProperties = JNLPUtils.getLocalApplicationProperties();
        if (localApplicationProperties != null && (object = localApplicationProperties.get("jnlp.api.always.FileOpenService.open")) != null) {
            return true;
        }
        object = this._apiDialog.askUser(ResourceManager.getString((String)"api.file.open.title"), ResourceManager.getString((String)"api.file.open.message"), ResourceManager.getString((String)"api.file.open.always"));
        if (object == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    localApplicationProperties.put("jnlp.api.always.FileOpenService.open", "skip");
                    try {
                        localApplicationProperties.store();
                    }
                    catch (Throwable throwable) {
                        Trace.ignored((Throwable)throwable);
                    }
                    return null;
                }
            });
        }
        return object == ApiDialog.DialogResult.OK || object == ApiDialog.DialogResult.ALWAYS;
    }
}

