/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.Collections;
import java.util.List;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;

class ThreadLockCCTNode
extends LockCCTNode {
    private final ThreadInfo ti;
    private final List<ThreadInfo.Monitor> monitors;
    private long allTime;
    private long allCount;

    ThreadLockCCTNode(LockCCTNode lockCCTNode, ThreadInfo threadInfo, List<ThreadInfo.Monitor> list) {
        super(lockCCTNode);
        this.ti = threadInfo;
        this.monitors = list;
    }

    ThreadLockCCTNode(MonitorCCTNode monitorCCTNode, MonitorInfo.ThreadDetail threadDetail) {
        super(monitorCCTNode);
        this.ti = threadDetail.threadInfo;
        this.allTime = threadDetail.waitTime;
        this.allCount = threadDetail.count;
        this.monitors = Collections.EMPTY_LIST;
    }

    @Override
    public String getNodeName() {
        return this.ti.getName();
    }

    @Override
    public long getTime() {
        if (this.allTime == 0L) {
            this.summarize();
        }
        return this.allTime;
    }

    @Override
    public long getWaits() {
        if (this.allCount == 0L) {
            this.summarize();
        }
        return this.allCount;
    }

    @Override
    public boolean isThreadLockNode() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ThreadLockCCTNode) {
            return this.ti.equals(((ThreadLockCCTNode)object).ti);
        }
        return false;
    }

    public int hashCode() {
        return this.ti.hashCode();
    }

    private void summarize() {
        for (ThreadInfo.Monitor monitor : this.monitors) {
            this.allTime += monitor.waitTime;
            this.allCount += monitor.count;
        }
    }

    @Override
    void computeChildren() {
        super.computeChildren();
        for (ThreadInfo.Monitor monitor : this.monitors) {
            this.addChild(new MonitorCCTNode(this, monitor));
        }
    }
}

