/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;

class MonitorInfo {
    private final int monitorId;
    private String className;
    private OpenThread openThread;
    private Map<ThreadInfo, ThreadDetail> threads;

    MonitorInfo(int n) {
        this.monitorId = n;
        this.threads = new HashMap<ThreadInfo, ThreadDetail>();
        this.className = "*unknown*";
    }

    MonitorInfo(int n, String string) {
        this(n);
        this.className = string;
    }

    void setClassName(String string) {
        this.className = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MonitorInfo) {
            MonitorInfo monitorInfo = (MonitorInfo)object;
            return monitorInfo.monitorId == this.monitorId;
        }
        return false;
    }

    public int hashCode() {
        return this.monitorId;
    }

    void openThread(ThreadInfo threadInfo, long l) {
        assert (this.openThread == null);
        this.openThread = new OpenThread(threadInfo, l);
    }

    void closeThread(ThreadInfo threadInfo, long l) {
        assert (this.openThread != null);
        assert (this.openThread.threadInfo.equals(threadInfo));
        long l2 = l - this.openThread.timeStamp;
        this.addThread(threadInfo, l2);
        this.openThread = null;
    }

    private void addThread(ThreadInfo threadInfo, long l) {
        ThreadDetail threadDetail = this.threads.get(threadInfo);
        if (threadDetail == null) {
            this.threads.put(threadInfo, new ThreadDetail(threadInfo, l));
        } else {
            threadDetail.addWait(l);
        }
    }

    void timeAdjust(long l) {
        assert (this.openThread != null);
        this.openThread.timeAdjust(l);
    }

    List<ThreadDetail> cloneThreadDetails() {
        ArrayList<ThreadDetail> arrayList = new ArrayList<ThreadDetail>(this.threads.size());
        for (ThreadDetail threadDetail : this.threads.values()) {
            arrayList.add(new ThreadDetail(threadDetail));
        }
        return arrayList;
    }

    String getName() {
        return new StringBuffer(this.className).append('(').append(Integer.toHexString(this.monitorId)).append(')').toString();
    }

    static class ThreadDetail {
        final ThreadInfo threadInfo;
        long count;
        long waitTime;

        private ThreadDetail(ThreadInfo threadInfo, long l) {
            this.threadInfo = threadInfo;
            this.waitTime = l;
            this.count = 1L;
        }

        ThreadDetail(ThreadDetail threadDetail) {
            this.threadInfo = threadDetail.threadInfo;
            this.count = threadDetail.count;
            this.waitTime = threadDetail.waitTime;
        }

        private void addWait(long l) {
            this.waitTime += l;
            ++this.count;
        }
    }

    private static class OpenThread {
        private final ThreadInfo threadInfo;
        private long timeStamp;

        OpenThread(ThreadInfo threadInfo, long l) {
            this.threadInfo = threadInfo;
            this.timeStamp = l;
        }

        private void timeAdjust(long l) {
            this.timeStamp += l;
        }
    }
}

