/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ExportDataDumper {
    public static final int BUFFER_SIZE = 32000;
    BufferedOutputStream bos;
    IOException caughtEx;
    int numExceptions = 0;

    public ExportDataDumper(FileOutputStream fileOutputStream) {
        this.bos = new BufferedOutputStream(fileOutputStream, 32000);
    }

    public IOException getCaughtException() {
        return this.caughtEx;
    }

    public int getNumExceptions() {
        return this.numExceptions;
    }

    public void dumpData(CharSequence charSequence) {
        if (this.caughtEx != null) {
            return;
        }
        try {
            if (charSequence != null) {
                this.bos.write(charSequence.toString().getBytes());
            }
        }
        catch (IOException iOException) {
            this.caughtEx = iOException;
            System.out.println(charSequence);
            ++this.numExceptions;
            System.err.println(iOException.getMessage());
        }
    }

    public void close() {
        try {
            this.bos.close();
        }
        catch (IOException iOException) {
            this.caughtEx = iOException;
            System.err.println(iOException.getMessage());
        }
    }

    public void dumpDataAndClose(StringBuffer stringBuffer) {
        this.dumpData(stringBuffer);
        this.close();
    }

    public BufferedOutputStream getOutputStream() {
        return this.bos;
    }
}

