/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ComputedSummary;
import org.netbeans.lib.profiler.heap.DominatorTree;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofArrayValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofProxy;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameHprofGCRoot;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.NearestGCRoot;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.StackFrameSegment;
import org.netbeans.lib.profiler.heap.StackTraceSegment;
import org.netbeans.lib.profiler.heap.StringSegment;
import org.netbeans.lib.profiler.heap.Summary;
import org.netbeans.lib.profiler.heap.SyntheticClassField;
import org.netbeans.lib.profiler.heap.SyntheticClassObjectValue;
import org.netbeans.lib.profiler.heap.TagBounds;
import org.netbeans.lib.profiler.heap.ThreadObjectHprofGCRoot;
import org.netbeans.lib.profiler.heap.TreeObject;
import org.netbeans.lib.profiler.heap.Value;

class HprofHeap
implements Heap {
    static final int STRING = 1;
    static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    static final int STACK_FRAME = 4;
    static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    static final int ROOT_UNKNOWN = 255;
    static final int ROOT_JNI_GLOBAL = 1;
    static final int ROOT_JNI_LOCAL = 2;
    static final int ROOT_JAVA_FRAME = 3;
    static final int ROOT_NATIVE_STACK = 4;
    static final int ROOT_STICKY_CLASS = 5;
    static final int ROOT_THREAD_BLOCK = 6;
    static final int ROOT_MONITOR_USED = 7;
    static final int ROOT_THREAD_OBJECT = 8;
    static final int CLASS_DUMP = 32;
    static final int INSTANCE_DUMP = 33;
    static final int OBJECT_ARRAY_DUMP = 34;
    static final int PRIMITIVE_ARRAY_DUMP = 35;
    static final int OBJECT = 2;
    static final int BOOLEAN = 4;
    static final int CHAR = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BYTE = 8;
    static final int SHORT = 9;
    static final int INT = 10;
    static final int LONG = 11;
    private static final boolean DEBUG = false;
    HprofByteBuffer dumpBuffer;
    LongMap idToOffsetMap;
    NearestGCRoot nearestGCRoot;
    private ComputedSummary computedSummary;
    private Map gcRoots;
    private DominatorTree domTree;
    private final Object gcRootLock = new Object();
    private TagBounds allInstanceDumpBounds;
    private TagBounds heapDumpSegment;
    private TagBounds[] heapTagBounds;
    private TagBounds[] tagBounds = new TagBounds[255];
    private boolean instancesCountComputed;
    private boolean referencesComputed;
    private boolean retainedSizeComputed;
    private boolean retainedSizeByClassComputed;
    private int idMapSize;
    private int segment;

    HprofHeap(File file, int n) throws FileNotFoundException, IOException {
        this.dumpBuffer = HprofByteBuffer.createHprofByteBuffer(file);
        this.segment = n;
        this.fillTagBounds(this.dumpBuffer.getHeaderSize());
        this.heapDumpSegment = this.computeHeapDumpStart();
        if (this.heapDumpSegment != null) {
            this.fillHeapTagBounds();
        }
        this.idToOffsetMap = new LongMap(this.idMapSize, this.dumpBuffer.getIDSize(), this.dumpBuffer.getFoffsetSize());
        this.nearestGCRoot = new NearestGCRoot(this);
    }

    @Override
    public List getAllClasses() {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        if (classDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return classDumpSegment.createClassCollection();
    }

    @Override
    public List getBiggestObjectsByRetainedSize(int n) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>(n);
        this.computeRetainedSize();
        long[] lArray = this.idToOffsetMap.getBiggestObjectsByRetainedSize(n);
        for (int i = 0; i < lArray.length; ++i) {
            arrayList.add(this.getInstanceByID(lArray[i]));
        }
        return arrayList;
    }

    @Override
    public GCRoot getGCRoot(Instance instance) {
        Long l = instance.getInstanceId();
        return this.getGCRoot(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.heapDumpSegment == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.gcRoots == null) {
                this.gcRoots = this.computeGCRootsFor(this.heapTagBounds[255]);
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[1]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[2]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[3]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[4]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[5]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[6]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[7]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[8]));
            }
            return this.gcRoots.values();
        }
    }

    @Override
    public Instance getInstanceByID(long l) {
        if (l == 0L) {
            return null;
        }
        this.computeInstances();
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        int n2 = 0;
        LongMap.Entry entry = this.idToOffsetMap.get(l);
        if (entry == null) {
            return null;
        }
        long l2 = entry.getOffset();
        assert (l2 != 0L);
        long[] lArray = new long[]{l2};
        int n3 = this.readDumpTag(lArray);
        if (n3 == 33) {
            n2 = n + 4;
        } else if (n3 == 34) {
            n2 = n + 4 + 4;
        } else if (n3 == 35) {
            n2 = n + 4 + 4;
        }
        if (n3 == 35) {
            ClassDump classDump = classDumpSegment.getPrimitiveArrayClass(this.dumpBuffer.get(l2 + 1L + (long)n2));
            return new PrimitiveArrayDump(classDump, l2);
        }
        long l3 = this.dumpBuffer.getID(l2 + 1L + (long)n2);
        ClassDump classDump = classDumpSegment.getClassDumpByID(l3);
        if (n3 == 33) {
            return new InstanceDump(classDump, l2);
        }
        if (n3 == 34) {
            return new ObjectArrayDump(classDump, l2);
        }
        if (n3 == 32) {
            return new ClassDumpInstance(classDump);
        }
        throw new IllegalArgumentException("Illegal tag " + n3);
    }

    @Override
    public JavaClass getJavaClassByID(long l) {
        return this.getClassDumpSegment().getClassDumpByID(l);
    }

    @Override
    public JavaClass getJavaClassByName(String string) {
        if (this.heapDumpSegment == null) {
            return null;
        }
        return this.getClassDumpSegment().getJavaClassByName(string);
    }

    @Override
    public Collection getJavaClassesByRegExp(String string) {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getClassDumpSegment().getJavaClassesByRegExp(string);
    }

    @Override
    public synchronized HeapSummary getSummary() {
        TagBounds tagBounds = this.tagBounds[7];
        if (tagBounds != null) {
            return new Summary(this.dumpBuffer, tagBounds.startOffset);
        }
        if (this.computedSummary == null) {
            this.computedSummary = new ComputedSummary(this);
        }
        return this.computedSummary;
    }

    @Override
    public Properties getSystemProperties() {
        JavaClass javaClass = this.getJavaClassByName("java.lang.System");
        if (javaClass != null) {
            Instance instance = (Instance)javaClass.getValueOfStaticField("props");
            if (instance == null) {
                instance = (Instance)javaClass.getValueOfStaticField("systemProperties");
            }
            if (instance != null) {
                return HprofProxy.getProperties(instance);
            }
        }
        return null;
    }

    ClassDumpSegment getClassDumpSegment() {
        return (ClassDumpSegment)this.heapTagBounds[32];
    }

    LoadClassSegment getLoadClassSegment() {
        return (LoadClassSegment)this.tagBounds[2];
    }

    StringSegment getStringSegment() {
        return (StringSegment)this.tagBounds[1];
    }

    StackTraceSegment getStackTraceSegment() {
        return (StackTraceSegment)this.tagBounds[5];
    }

    StackFrameSegment getStackFrameSegment() {
        return (StackFrameSegment)this.tagBounds[4];
    }

    TagBounds getAllInstanceDumpBounds() {
        return this.allInstanceDumpBounds;
    }

    int getRetainedSize(Instance instance) {
        this.computeRetainedSize();
        return this.idToOffsetMap.get(instance.getInstanceId()).getRetainedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GCRoot getGCRoot(Long l) {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.getGCRoots();
            }
            return (GCRoot)this.gcRoots.get(l);
        }
    }

    int getValueSize(byte by) {
        switch (by) {
            case 2: {
                return this.dumpBuffer.getIDSize();
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid type " + by);
    }

    synchronized void computeInstances() {
        if (this.instancesCountComputed) {
            return;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        Map map = classDumpSegment.getClassIdToClassMap();
        long l = 0L;
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            int n2 = 0;
            int n3 = 0;
            ClassDump classDump = null;
            long l2 = lArray[0];
            int n4 = this.readDumpTag(lArray);
            LongMap.Entry entry = null;
            if (n4 == 33) {
                n3 = 1;
                n2 = n + 4;
            } else if (n4 == 34) {
                n3 = 1;
                n2 = n + 4 + 4;
            } else if (n4 == 35) {
                byte by = this.dumpBuffer.get(l2 + 1L + (long)n + 4L + 4L);
                n3 = 1;
                classDump = classDumpSegment.getPrimitiveArrayClass(by);
            }
            if (n3 != 0) {
                long l3 = this.dumpBuffer.getID(l2 + (long)n3);
                entry = this.idToOffsetMap.put(l3, l2);
            }
            if (n2 != 0) {
                long l4 = this.dumpBuffer.getID(l2 + 1L + (long)n2);
                classDump = (ClassDump)map.get(new Long(l4));
            }
            if (classDump != null) {
                classDump.registerInstance(l2);
                entry.setIndex(classDump.getInstancesCount());
                classDumpSegment.addInstanceSize(classDump, n4, l2);
            }
            HeapProgress.progress(l, this.allInstanceDumpBounds.startOffset, l2, this.allInstanceDumpBounds.endOffset);
            ++l;
        }
        HeapProgress.progressFinish();
        this.instancesCountComputed = true;
    }

    List findReferencesFor(long l) {
        assert (l != 0L) : "InstanceID is null";
        this.computeReferences();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        List list = this.idToOffsetMap.get(l).getReferences();
        Iterator iterator = list.iterator();
        int n = this.dumpBuffer.getIDSize();
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        long[] lArray = new long[1];
        while (iterator.hasNext()) {
            long l2;
            long l3 = (Long)iterator.next();
            lArray[0] = this.idToOffsetMap.get(l3).getOffset();
            int n2 = 0;
            boolean bl = false;
            long l4 = lArray[0];
            int n3 = this.readDumpTag(lArray);
            if (n3 == 33) {
                Object object2;
                n2 = n + 4;
                int n4 = this.dumpBuffer.getInt(l4 + 1L + (long)n + 4L + (long)n);
                byte[] byArray = new byte[n4];
                this.dumpBuffer.get(l4 + 1L + (long)n + 4L + (long)n + 4L, byArray);
                l2 = this.dumpBuffer.getID(l4 + 1L + (long)n + 4L);
                ClassDump classDump = classDumpSegment.getClassDumpByID(l2);
                InstanceDump instanceDump = new InstanceDump(classDump, l4);
                for (Object object2 : instanceDump.getFieldValues()) {
                    HprofInstanceObjectValue hprofInstanceObjectValue;
                    if (!(object2 instanceof HprofInstanceObjectValue) || (hprofInstanceObjectValue = (HprofInstanceObjectValue)object2).getInstanceId() != l) continue;
                    arrayList.add(hprofInstanceObjectValue);
                }
                if (!arrayList.isEmpty() || l2 != l) continue;
                object2 = new SyntheticClassField(classDump);
                long l5 = l4 + 1L + (long)this.dumpBuffer.getIDSize() + 4L;
                arrayList.add(new SyntheticClassObjectValue(instanceDump, (Field)object2, l5));
                continue;
            }
            if (n3 == 34) {
                int n5 = this.dumpBuffer.getInt(l4 + 1L + (long)n + 4L);
                l2 = l4 + 1L + (long)n + 4L + 4L + (long)n;
                int n6 = 0;
                while (n6 < n5) {
                    if (this.dumpBuffer.getID(l2) == l) {
                        long l6 = this.dumpBuffer.getID(l4 + 1L + (long)n + 4L + 4L);
                        ClassDump classDump = classDumpSegment.getClassDumpByID(l6);
                        arrayList.add(new HprofArrayValue(classDump, l4, n6));
                    }
                    ++n6;
                    l2 += (long)n;
                }
                continue;
            }
            if (n3 != 32) continue;
            ClassDump classDump = classDumpSegment.getClassDumpByID(l3);
            classDump.findStaticReferencesFor(l, arrayList);
        }
        return arrayList;
    }

    synchronized void computeReferences() {
        Object object;
        long l;
        if (this.referencesComputed) {
            return;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        Map map = classDumpSegment.getClassIdToClassMap();
        this.computeInstances();
        long l2 = 0L;
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            Object object2;
            long l3;
            long l4 = lArray[0];
            int n2 = this.readDumpTag(lArray);
            if (n2 == 33) {
                l = this.dumpBuffer.getID(l4 + 1L + (long)n + 4L);
                object = (ClassDump)map.get(new Long(l));
                l3 = this.dumpBuffer.getID(l4 + 1L);
                long l5 = l4 + 1L + (long)n + 4L + (long)n + 4L;
                List list = ((ClassDump)object).getAllInstanceFields();
                object2 = list.iterator();
                while (object2.hasNext()) {
                    LongMap.Entry entry;
                    long l6;
                    HprofField hprofField = (HprofField)object2.next();
                    if (hprofField.getValueType() == 2 && (l6 = this.dumpBuffer.getID(l5)) != 0L && (entry = this.idToOffsetMap.get(l6)) != null) {
                        entry.addReference(l3);
                    }
                    l5 += (long)hprofField.getValueSize();
                }
            } else if (n2 == 34) {
                l = this.dumpBuffer.getID(l4 + 1L);
                int n3 = this.dumpBuffer.getInt(l4 + 1L + (long)n + 4L);
                l3 = l4 + 1L + (long)n + 4L + 4L + (long)n;
                int n4 = 0;
                while (n4 < n3) {
                    long l7 = this.dumpBuffer.getID(l3);
                    if (l7 != 0L && (object2 = this.idToOffsetMap.get(l7)) != null) {
                        ((LongMap.Entry)object2).addReference(l);
                    }
                    ++n4;
                    l3 += (long)n;
                }
            }
            HeapProgress.progress(l2, this.allInstanceDumpBounds.startOffset, l4, this.allInstanceDumpBounds.endOffset);
            ++l2;
        }
        for (ClassDump classDump : this.getClassDumpSegment().createClassCollection()) {
            List list = classDump.getStaticFieldValues();
            for (Object e : list) {
                if (!(e instanceof HprofFieldObjectValue) || (l = ((HprofFieldObjectValue)e).getInstanceID()) == 0L || (object = this.idToOffsetMap.get(l)) == null) continue;
                ((LongMap.Entry)object).addReference(classDump.getJavaClassId());
            }
        }
        this.idToOffsetMap.flush();
        HeapProgress.progressFinish();
        this.referencesComputed = true;
    }

    synchronized void computeRetainedSize() {
        if (this.retainedSizeComputed) {
            return;
        }
        new TreeObject(this, this.nearestGCRoot.getLeaves()).computeTrees();
        this.domTree = new DominatorTree(this, this.nearestGCRoot.getMultipleParents());
        this.domTree.computeDominators();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            LongMap.Entry entry;
            int n;
            int n2 = 0;
            long l = lArray[0];
            int n3 = this.readDumpTag(lArray);
            if (n3 == 33) {
                n2 = 1;
            } else if (n3 == 34) {
                n2 = 1;
            } else {
                if (n3 != 35) continue;
                n2 = 1;
            }
            long l2 = this.dumpBuffer.getID(l + (long)n2);
            LongMap.Entry entry2 = this.idToOffsetMap.get(l2);
            long l3 = this.domTree.getIdomId(l2, entry2);
            boolean bl = entry2.isTreeObj();
            int n4 = 0;
            if (!(bl || entry2.getNearestGCRootPointer() == 0L && this.getGCRoot(new Long(l2)) == null)) {
                n = entry2.getRetainedSize();
                if (n < 0) {
                    n = 0;
                }
                n4 = this.getInstanceByID(l2).getSize();
                entry2.setRetainedSize(n + n4);
            }
            if (l3 == 0L) continue;
            if (bl) {
                n = entry2.getRetainedSize();
            } else {
                assert (n4 != 0);
                n = n4;
            }
            while (l3 != 0L && !(entry = this.idToOffsetMap.get(l3)).isTreeObj()) {
                int n5 = entry.getRetainedSize();
                if (n5 < 0) {
                    n5 = 0;
                }
                entry.setRetainedSize(n5 + n);
                l3 = this.domTree.getIdomId(l3, entry);
            }
        }
        this.retainedSizeComputed = true;
    }

    synchronized void computeRetainedSizeByClass() {
        if (this.retainedSizeByClassComputed) {
            return;
        }
        this.computeRetainedSize();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            long l;
            Instance instance;
            ClassDump classDump;
            int n = 0;
            long l2 = lArray[0];
            int n2 = this.readDumpTag(lArray);
            if (n2 == 33) {
                n = 1;
            } else if (n2 == 34) {
                n = 1;
            } else {
                if (n2 != 35) continue;
                n = 1;
            }
            if ((classDump = (ClassDump)(instance = this.getInstanceByID(l = this.dumpBuffer.getID(l2 + (long)n))).getJavaClass()) == null || this.domTree.hasInstanceInChain(n2, instance)) continue;
            classDump.addSizeForInstance(instance);
        }
        this.domTree = null;
        this.retainedSizeByClassComputed = true;
    }

    int readDumpTag(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.get(l++);
        int n2 = 0;
        long l2 = l;
        int n3 = this.dumpBuffer.getIDSize();
        switch (n) {
            case -1: 
            case 255: {
                n2 = n3;
                n = 255;
                break;
            }
            case 1: {
                n2 = 2 * n3;
                break;
            }
            case 2: {
                n2 = n3 + 8;
                break;
            }
            case 3: {
                n2 = n3 + 8;
                break;
            }
            case 4: {
                n2 = n3 + 4;
                break;
            }
            case 5: {
                n2 = n3;
                break;
            }
            case 6: {
                n2 = n3 + 4;
                break;
            }
            case 7: {
                n2 = n3;
                break;
            }
            case 8: {
                n2 = n3 + 8;
                break;
            }
            case 32: {
                int n4 = n3 + 4 + 6 * n3 + 4;
                lArray[0] = l + (long)n4;
                int n5 = this.readConstantPool(lArray);
                int n6 = this.readStaticFields(lArray);
                int n7 = this.readInstanceFields(lArray);
                n2 = n4 + n5 + n6 + n7;
                break;
            }
            case 33: {
                int n8 = this.dumpBuffer.getInt(l + (long)n3 + 4L + (long)n3);
                n2 = n3 + 4 + n3 + 4 + n8;
                break;
            }
            case 34: {
                int n9 = this.dumpBuffer.getInt(l + (long)n3 + 4L);
                n2 = n3 + 4 + 4 + n3 + n9 * n3;
                break;
            }
            case 35: {
                int n10 = this.dumpBuffer.getInt(l + (long)n3 + 4L);
                byte by = this.dumpBuffer.get(l + (long)n3 + 4L + 4L);
                n2 = n3 + 4 + 4 + 1 + n10 * this.getValueSize(by);
                break;
            }
            case 28: {
                n2 = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid dump tag " + n + " at position " + (l - 1L));
            }
        }
        lArray[0] = l2 + (long)n2;
        return n;
    }

    int readTag(long[] lArray) {
        long l = lArray[0];
        byte by = this.dumpBuffer.get(l);
        long l2 = (long)this.dumpBuffer.getInt(l + 1L + 4L) & 0xFFFFFFFFL;
        lArray[0] = l + 1L + 4L + 4L + l2;
        return by;
    }

    private Map computeGCRootsFor(TagBounds tagBounds) {
        HashMap<Long, ThreadObjectHprofGCRoot> hashMap = new HashMap<Long, ThreadObjectHprofGCRoot>();
        if (tagBounds != null) {
            int n = tagBounds.tag;
            long[] lArray = new long[]{tagBounds.startOffset};
            while (lArray[0] < tagBounds.endOffset) {
                long l = lArray[0];
                if (this.readDumpTag(lArray) != n) continue;
                HprofGCRoot hprofGCRoot = n == 8 ? new ThreadObjectHprofGCRoot(this, l) : (n == 3 ? new JavaFrameHprofGCRoot(this, l) : new HprofGCRoot(this, l));
                hashMap.put(hprofGCRoot.getInstanceId(), (ThreadObjectHprofGCRoot)hprofGCRoot);
            }
        }
        return hashMap;
    }

    private TagBounds computeHeapDumpStart() throws IOException {
        TagBounds tagBounds = this.tagBounds[12];
        if (tagBounds != null) {
            long l = tagBounds.startOffset;
            long[] lArray = new long[]{l};
            int n = 0;
            while (n <= this.segment && l < tagBounds.endOffset) {
                int n2 = this.readTag(lArray);
                if (n2 == 12) {
                    if (n == this.segment) {
                        return new TagBounds(12, l, lArray[0]);
                    }
                    ++n;
                }
                l = lArray[0];
            }
            throw new IOException("Invalid segment " + this.segment);
        }
        TagBounds tagBounds2 = this.tagBounds[28];
        if (tagBounds2 != null) {
            long l = tagBounds2.startOffset;
            long l2 = tagBounds2.endOffset;
            return new TagBounds(12, l, l2);
        }
        return null;
    }

    private void fillHeapTagBounds() {
        if (this.heapTagBounds != null) {
            return;
        }
        this.heapTagBounds = new TagBounds[256];
        long[] lArray = new long[]{this.heapDumpSegment.startOffset + 1L + 4L + 4L};
        long l = 0L;
        while (lArray[0] < this.heapDumpSegment.endOffset) {
            long l2 = lArray[0];
            int n = this.readDumpTag(lArray);
            TagBounds tagBounds = this.heapTagBounds[n];
            long l3 = lArray[0];
            if (tagBounds == null) {
                TagBounds tagBounds2 = n == 32 ? new ClassDumpSegment(this, l2, l3) : new TagBounds(n, l2, l3);
                this.heapTagBounds[n] = tagBounds2;
            } else {
                tagBounds.endOffset = l3;
            }
            if (n == 32 || n == 33 || n == 34 || n == 35) {
                ++this.idMapSize;
            }
            HeapProgress.progress(l, this.heapDumpSegment.startOffset, l2, this.heapDumpSegment.endOffset);
            ++l;
        }
        TagBounds tagBounds = this.heapTagBounds[33];
        TagBounds tagBounds3 = this.heapTagBounds[34];
        TagBounds tagBounds4 = this.heapTagBounds[35];
        this.allInstanceDumpBounds = tagBounds.union(tagBounds3);
        this.allInstanceDumpBounds = this.allInstanceDumpBounds.union(tagBounds4);
        HeapProgress.progressFinish();
    }

    private void fillTagBounds(long l) {
        long[] lArray = new long[]{l};
        while (lArray[0] < this.dumpBuffer.capacity()) {
            long l2 = lArray[0];
            int n = this.readTag(lArray);
            TagBounds tagBounds = this.tagBounds[n];
            long l3 = lArray[0];
            if (tagBounds == null) {
                TagBounds tagBounds2 = n == 2 ? new LoadClassSegment(this, l2, l3) : (n == 1 ? new StringSegment(this, l2, l3) : (n == 5 ? new StackTraceSegment(this, l2, l3) : (n == 4 ? new StackFrameSegment(this, l2, l3) : new TagBounds(n, l2, l3))));
                this.tagBounds[n] = tagBounds2;
                continue;
            }
            tagBounds.endOffset = l3;
        }
    }

    private int readConstantPool(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.getShort(l);
        lArray[0] = lArray[0] + 2L;
        for (int i = 0; i < n; ++i) {
            lArray[0] = lArray[0] + 2L;
            this.readValue(lArray);
        }
        return (int)(lArray[0] - l);
    }

    private int readInstanceFields(long[] lArray) {
        long l = lArray[0];
        short s = this.dumpBuffer.getShort(lArray[0]);
        lArray[0] = lArray[0] + 2L;
        lArray[0] = lArray[0] + (long)(s * (this.dumpBuffer.getIDSize() + 1));
        return (int)(lArray[0] - l);
    }

    private int readStaticFields(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.getShort(l);
        lArray[0] = lArray[0] + 2L;
        int n2 = this.dumpBuffer.getIDSize();
        for (int i = 0; i < n; ++i) {
            lArray[0] = lArray[0] + (long)n2;
            byte by = this.readValue(lArray);
        }
        return (int)(lArray[0] - l);
    }

    private byte readValue(long[] lArray) {
        long l = lArray[0];
        lArray[0] = l + 1L;
        byte by = this.dumpBuffer.get(l);
        lArray[0] = lArray[0] + (long)this.getValueSize(by);
        return by;
    }
}

