/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateProvider;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.wizards.ExportToFileWizardPage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class TemplateExportWizard
extends Wizard
implements IExportWizard {
    private static String WIZARD_KEY = "exportTemplateToFile";
    private ExportToFileWizardPage m_wizardPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)ControlPanel.getDefault().getDialogSettings(), (String)WIZARD_KEY));
        this.setWindowTitle(Messages.EXPORT_TEMPLATE_WIZARD_TITLE);
        this.m_wizardPage = new ExportTemplateToFile(Messages.EXPORT_TEMPLATE_WIZARD_TITLE);
        this.m_wizardPage.setTitle(Messages.EXPORT_TEMPLATE_WIZARD_TITLE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean performFinish() {
        File file = this.m_wizardPage.getFile();
        IRecordingConfiguration template = (IRecordingConfiguration)this.m_wizardPage.getSelectedItems().iterator().next();
        try {
            template.exportToFile(file);
            return true;
        }
        catch (IOException ioe) {
            DialogToolkit.showExceptionDialogAsync((Display)this.m_wizardPage.getControl().getDisplay(), (String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_TITLE, (String)NLS.bind((String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_MESSAGE, (Object)ioe.getLocalizedMessage()), (Throwable)ioe);
            return false;
        }
    }

    private static final class ExportTemplateToFile
    extends ExportToFileWizardPage {
        private List<?> selected;

        private ExportTemplateToFile(String pageName) {
            super(pageName, ".jfc");
        }

        protected Composite createButtonContainer(Composite parent) {
            return null;
        }

        protected Composite createContents(Composite parent) {
            TreeViewer tv = new TreeViewer(parent, 4);
            this.initializeViewer(tv);
            tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    if (!ss.isEmpty()) {
                        ExportTemplateToFile.this.selected = ss.toList();
                    }
                    ExportTemplateToFile.this.updatePageComplete();
                }
            });
            Tree tree = tv.getTree();
            return tree;
        }

        protected void initializeViewer(TreeViewer viewer) {
            RecordingTemplateRepository repository = TemplateRepositoryFactory.create();
            viewer.setAutoExpandLevel(2);
            viewer.setContentProvider((IContentProvider)new TemplateProvider());
            viewer.setInput((Object)repository);
            viewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
            viewer.setSelection(null);
        }

        protected boolean isSelectionValid() {
            return this.selected != null && this.selected.size() == 1;
        }

        public Collection<?> getSelectedItems() {
            return this.selected;
        }
    }
}

