/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.OpenRecordingFileJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public final class DumpRecordingJob
extends Job {
    private final RecordingProvider m_recording;
    private final MCFile m_savePath;
    private Date m_startTime;
    private Date m_endTime;
    private long lastPartInMillis;

    public DumpRecordingJob(RecordingProvider recording, MCFile savePath, long lastPartInMillis) {
        this(recording, savePath);
        this.lastPartInMillis = lastPartInMillis;
    }

    public DumpRecordingJob(RecordingProvider recording, MCFile savePath, Date startTime, Date endTime) {
        this(recording, savePath);
        this.m_startTime = startTime;
        this.m_endTime = endTime;
    }

    public DumpRecordingJob(RecordingProvider recording, MCFile savePath) {
        super(NLS.bind((String)Messages.DUMP_RECORDING_JOB_NAME, (Object)recording.getRecordingDescriptor().getName()));
        this.m_recording = recording;
        this.m_savePath = savePath;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IConnectionHandle connection = null;
        InputStream is = null;
        try {
            this.m_recording.setIsOpening(true);
            connection = this.m_recording.getServerHandle().connect(this.getName());
            boolean removeDone = FlightRecorderUI.getDefault().removeFinishedRecordings();
            IFlightRecorderService flrService = (IFlightRecorderService)connection.getServiceOrDummy(IFlightRecorderService.class);
            if (this.lastPartInMillis > 0L) {
                if (this.m_recording.isStopped()) {
                    IRecordingDescriptor recDesc = this.m_recording.getRecordingDescriptor();
                    Date endTime = new Date(recDesc.getStartTime().getTime() + recDesc.getDuration());
                    Date startTime = new Date(endTime.getTime() - this.lastPartInMillis);
                    is = flrService.openStream(this.m_recording.getRecordingDescriptor(), startTime, endTime, removeDone);
                } else {
                    is = flrService.openStream(this.m_recording.getRecordingDescriptor(), this.lastPartInMillis, removeDone);
                }
            } else {
                is = this.m_startTime != null && this.m_endTime != null ? flrService.openStream(this.m_recording.getRecordingDescriptor(), this.m_startTime, this.m_endTime, removeDone) : flrService.openStream(this.m_recording.getRecordingDescriptor(), removeDone);
            }
            IPath actualSavePath = this.m_savePath.writeStreamToUnique((InputStream)new GZIPInputStream(is), monitor);
            OpenRecordingFileJob openJob = new OpenRecordingFileJob(actualSavePath);
            openJob.schedule();
            this.m_recording.setIsOpening(false);
            iStatus = StatusFactory.createOk((String)Messages.DUMP_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (FlightRecorderException e) {
            IStatus iStatus2 = StatusFactory.createErr((String)NLS.bind((String)Messages.DUMP_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recording.getRecordingDescriptor().getName()), (Throwable)e, (boolean)false);
            IOToolkit.closeSilently(is);
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        catch (IOException e2) {
            IStatus iStatus3 = StatusFactory.createErr((String)NLS.bind((String)Messages.DUMP_RECORDING_JOB_IO_ERROR_MSG, (Object)this.m_recording.getRecordingDescriptor().getName()), (Throwable)e2, (boolean)false);
            {
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(is);
                    IOToolkit.closeSilently(connection);
                    throw throwable;
                }
            }
            IOToolkit.closeSilently(is);
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus3;
        }
        IOToolkit.closeSilently((Closeable)is);
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }
}

