/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.spi;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;

public final class DetailsUtils {
    private static final int MAX_ARRAY_LENGTH = 128;
    private static String LAST_SUBCLASS_INSTANCE;
    private static final LinkedHashMap<String, Boolean> SUBCLASS_CACHE;

    public static boolean isInstanceOf(Instance instance, String string) {
        if (instance == null) {
            return false;
        }
        return instance.getJavaClass().getName().equals(string);
    }

    public static boolean isSubclassOf(Instance instance, String string) {
        if (instance == null) {
            return false;
        }
        JavaClass javaClass = instance.getJavaClass();
        if (!javaClass.getName().equals(LAST_SUBCLASS_INSTANCE)) {
            SUBCLASS_CACHE.clear();
        } else {
            Boolean bl = SUBCLASS_CACHE.get(string);
            if (bl != null) {
                return bl;
            }
        }
        LAST_SUBCLASS_INSTANCE = javaClass.getName();
        boolean bl = false;
        while (javaClass != null) {
            if (javaClass.getName().equals(string)) {
                bl = true;
                break;
            }
            javaClass = javaClass.getSuperClass();
        }
        SUBCLASS_CACHE.put(string, bl);
        return bl;
    }

    public static boolean getBooleanFieldValue(Instance instance, String string, boolean bl) {
        Object object = instance.getValueOfField(string);
        return object instanceof Boolean ? (Boolean)object : bl;
    }

    public static byte getByteFieldValue(Instance instance, String string, byte by) {
        Object object = instance.getValueOfField(string);
        return object instanceof Byte ? (Byte)object : by;
    }

    public static char getCharFieldValue(Instance instance, String string, char c) {
        Object object = instance.getValueOfField(string);
        return object instanceof Character ? ((Character)object).charValue() : c;
    }

    public static double getDoubleFieldValue(Instance instance, String string, double d) {
        Object object = instance.getValueOfField(string);
        return object instanceof Double ? (Double)object : d;
    }

    public static float getFloatFieldValue(Instance instance, String string, float f) {
        Object object = instance.getValueOfField(string);
        return object instanceof Float ? ((Float)object).floatValue() : f;
    }

    public static int getIntFieldValue(Instance instance, String string, int n) {
        Object object = instance.getValueOfField(string);
        return object instanceof Integer ? (Integer)object : n;
    }

    public static long getLongFieldValue(Instance instance, String string, long l) {
        Object object = instance.getValueOfField(string);
        return object instanceof Long ? (Long)object : l;
    }

    public static short getShortFieldValue(Instance instance, String string, short s) {
        Object object = instance.getValueOfField(string);
        return object instanceof Short ? (Short)object : s;
    }

    public static String getPrimitiveArrayFieldString(Instance instance, String string, int n, int n2, String string2, String string3) {
        Object object = instance.getValueOfField(string);
        return object instanceof Instance ? DetailsUtils.getPrimitiveArrayString((Instance)object, n, n2, string2, string3) : null;
    }

    public static String getPrimitiveArrayString(Instance instance, int n, int n2, String string, String string2) {
        List<String> list = DetailsUtils.getPrimitiveArrayValues(instance);
        if (list != null) {
            int n3 = n2 < 0 ? list.size() - n : Math.min(n2, list.size() - n);
            int n4 = string == null ? 0 : string.length();
            int n5 = Math.min(n3 * (2 + n4), 128 + string2.length());
            StringBuilder stringBuilder = new StringBuilder(n5);
            int n6 = n + n3 - 1;
            for (int i = n; i <= n6; ++i) {
                stringBuilder.append(list.get(i));
                if (stringBuilder.length() >= 128) {
                    if (string2 == null) break;
                    stringBuilder.append(string2);
                    break;
                }
                if (string == null || i >= n6) continue;
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static List<String> getPrimitiveArrayFieldValues(Instance instance, String string) {
        Object object = instance.getValueOfField(string);
        if (object instanceof Instance) {
            return DetailsUtils.getPrimitiveArrayValues((Instance)object);
        }
        return null;
    }

    public static List<String> getPrimitiveArrayValues(Instance instance) {
        if (instance instanceof PrimitiveArrayInstance) {
            PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)instance;
            return primitiveArrayInstance.getValues();
        }
        return null;
    }

    public static String getInstanceFieldString(Instance instance, String string, Heap heap) {
        Object object = instance.getValueOfField(string);
        return object instanceof Instance ? DetailsUtils.getInstanceString((Instance)object, heap) : null;
    }

    public static String getInstanceString(Instance instance, Heap heap) {
        return DetailsSupport.getDetailsString(instance, heap);
    }

    public static boolean[] getBooleanArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = Boolean.parseBoolean(list.get(i));
            }
            return blArray;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new boolean[0];
        }
    }

    public static byte[] getByteArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = Byte.parseByte(list.get(i));
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new byte[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new byte[0];
        }
    }

    public static char[] getCharArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = list.get(i).charAt(0);
            }
            return cArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new char[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new char[0];
        }
    }

    public static double[] getDoubleArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = Double.parseDouble(list.get(i));
            }
            return dArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new double[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new double[0];
        }
    }

    public static float[] getFloatArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = Float.parseFloat(list.get(i));
            }
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new float[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new float[0];
        }
    }

    public static int[] getIntArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(list.get(i));
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new int[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new int[0];
        }
    }

    public static long[] getLongArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = Long.parseLong(list.get(i));
            }
            return lArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new long[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new long[0];
        }
    }

    public static short[] getShortArray(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        try {
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = Short.parseShort(list.get(i));
            }
            return sArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new short[0];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return new short[0];
        }
    }

    static {
        SUBCLASS_CACHE = new LinkedHashMap<String, Boolean>(100){

            @Override
            protected boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > 5000;
            }
        };
    }
}

