/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.details.basic.BasicExportAction;
import org.netbeans.modules.profiler.heapwalk.details.basic.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

final class ArrayValueView
extends DetailsProvider.View
implements Scrollable,
BasicExportAction.ExportProvider {
    private static final int MAX_PREVIEW_LENGTH = 256;
    private static final int MAX_ARRAY_ITEMS = 1000;
    private static final int MAX_CHARARRAY_ITEMS = 500000;
    private static final String TRUNCATED = Bundle.ArrayValueView_Truncated();
    private final String className;
    private JTextArea view;
    private JButton all;
    private String caption;
    private List<String> values;
    private String separator;
    private int offset;
    private int count;
    private boolean truncated;
    private boolean chararray;
    private String instanceIdentifier;
    private int type;

    protected ArrayValueView(String string, Instance instance, Heap heap) {
        super(instance, heap);
        this.className = string;
    }

    private ArrayValueView getArrayValueView() {
        return this;
    }

    @Override
    protected void computeView(Instance instance, Heap heap) {
        if ("java.lang.String".equals(this.className)) {
            this.separator = "";
            this.offset = DetailsUtils.getIntFieldValue(instance, "offset", 0);
            this.count = DetailsUtils.getIntFieldValue(instance, "count", -1);
            this.values = DetailsUtils.getPrimitiveArrayFieldValues(instance, "value");
            this.caption = Bundle.ArrayValueView_Value();
            this.type = 1;
        } else if ("java.lang.AbstractStringBuilder+".equals(this.className)) {
            this.separator = "";
            this.offset = 0;
            this.count = DetailsUtils.getIntFieldValue(instance, "count", -1);
            this.values = DetailsUtils.getPrimitiveArrayFieldValues(instance, "value");
            this.caption = Bundle.ArrayValueView_Value();
            this.type = 2;
        } else if (instance instanceof PrimitiveArrayInstance) {
            this.chararray = "char[]".equals(instance.getJavaClass().getName());
            this.separator = this.chararray ? "" : ", ";
            this.offset = 0;
            this.values = DetailsUtils.getPrimitiveArrayValues(instance);
            this.count = this.values == null ? 0 : this.values.size();
            this.caption = Bundle.ArrayValueView_Items();
            this.type = 3;
        }
        this.instanceIdentifier = instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
        final String string = this.getString(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayValueView.this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                ArrayValueView.this.setBackground(UIUtils.getProfilerResultsBackground());
                ArrayValueView.this.setOpaque(true);
                ArrayValueView.this.removeAll();
                JLabel jLabel = new JLabel(ArrayValueView.this.caption, 10);
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                ArrayValueView.this.add((Component)jLabel, "North");
                ArrayValueView.this.view = new JTextArea();
                jLabel.setLabelFor(ArrayValueView.this.view);
                ArrayValueView.this.view.setEditable(false);
                ArrayValueView.this.view.setLineWrap(true);
                ArrayValueView.this.view.setWrapStyleWord(true);
                ArrayValueView.this.view.setText(string);
                JScrollPane jScrollPane = new JScrollPane(ArrayValueView.this.view, 20, 31);
                ArrayValueView.this.add((Component)jScrollPane, "Center");
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setOpaque(false);
                ArrayValueView.this.all = ArrayValueView.htmlButton(Bundle.ArrayValueView_All(), ArrayValueView.this.truncated && ArrayValueView.this.count < (ArrayValueView.this.chararray ? 500000 : 1000), new Runnable(){

                    @Override
                    public void run() {
                        ArrayValueView.this.showAll();
                    }
                });
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 5);
                jPanel.add((Component)ArrayValueView.this.all, gridBagConstraints);
                JButton jButton = ArrayValueView.htmlButton(Bundle.ArrayValueView_Save(), !string.isEmpty(), new Runnable(){

                    @Override
                    public void run() {
                        new BasicExportAction(ArrayValueView.this.getArrayValueView()).actionPerformed(null);
                    }
                });
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                JPanel jPanel2 = new JPanel(null);
                jPanel2.setOpaque(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)jPanel2, gridBagConstraints);
                ArrayValueView.this.add((Component)jPanel, "South");
                ArrayValueView.this.revalidate();
                ArrayValueView.this.doLayout();
                ArrayValueView.this.repaint();
            }
        });
    }

    private void showAll() {
        this.all.setEnabled(false);
        this.view.setEnabled(false);
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                String string = null;
                try {
                    string = ArrayValueView.this.getString(false);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    ProfilerDialogs.displayError((String)Bundle.ArrayValueView_OutOfMemory());
                    return;
                }
                final String string2 = string;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ArrayValueView.this.view.setText(string2);
                            ArrayValueView.this.view.setEnabled(true);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            ProfilerDialogs.displayError((String)Bundle.ArrayValueView_OutOfMemory());
                        }
                    }
                });
            }
        });
    }

    private String getString(boolean bl) {
        if (this.values == null) {
            return "";
        }
        int n = this.count < 0 ? this.values.size() - this.offset : Math.min(this.count, this.values.size() - this.offset);
        int n2 = this.separator == null ? 0 : this.separator.length();
        int n3 = Math.min(n * (2 + n2), 256 + TRUNCATED.length());
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = this.offset + n - 1;
        for (int i = this.offset; i <= n4; ++i) {
            stringBuilder.append(this.values.get(i));
            if (bl && stringBuilder.length() >= 256) {
                stringBuilder.append(TRUNCATED);
                this.truncated = true;
                break;
            }
            if (this.separator == null || i >= n4) continue;
            stringBuilder.append(this.separator);
        }
        return stringBuilder.toString();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        Container container = this.getParent();
        if (container == null || !(container instanceof JViewport)) {
            return 50;
        }
        return (int)((float)((JViewport)container).getHeight() * 0.95f);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        if (container == null || !(container instanceof JViewport)) {
            return false;
        }
        return this.getMinimumSize().height < ((JViewport)container).getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        if (container == null || !(container instanceof JViewport)) {
            return false;
        }
        return this.getMinimumSize().width < ((JViewport)container).getWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    private static JButton htmlButton(final String string, boolean bl, final Runnable runnable) {
        JButton jButton = new JButton(){

            @Override
            public void setEnabled(boolean bl) {
                this.setText(!bl ? string : "<html><nobr><a href='#'>" + string + "</a></nobr></html>");
                this.setCursor(!bl ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
                super.setEnabled(bl);
            }
        };
        jButton.setOpaque(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setEnabled(bl);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        });
        return jButton;
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
        String string = ",";
        if (this.values != null) {
            int n2 = this.count < 0 ? this.values.size() - this.offset : Math.min(this.count, this.values.size() - this.offset);
            int n3 = this.offset + n2 - 1;
            if (n == 1) {
                for (int i = this.offset; i <= n3; ++i) {
                    exportDataDumper.dumpData((CharSequence)this.values.get(i));
                    exportDataDumper.dumpData((CharSequence)string);
                }
            } else if (n == 2) {
                for (int i = this.offset; i <= n3; ++i) {
                    exportDataDumper.dumpData((CharSequence)this.values.get(i));
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        exportDataDumper.close();
    }

    @Override
    public String getViewName() {
        return this.instanceIdentifier;
    }

    @Override
    public boolean hasRawData() {
        return this.type == 3;
    }

    @Override
    public boolean hasText() {
        return this.type < 3 || this.chararray;
    }

    @Override
    public boolean isExportable() {
        return this.hasText() || this.hasRawData();
    }
}

