/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapFactory;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.CompareSnapshotsHelper;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.ClassesListControllerUI;
import org.openide.util.Lookup;

public class ClassesListController
extends AbstractController {
    public static final int FILTER_SUBCLASS = 1001;
    private ClassesController classesController;
    private JavaClass selectedClass;
    private static final NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    public long minDiff;
    public long maxDiff;
    private List diffClasses;
    private boolean comparingSnapshot = false;
    private boolean compareRetained;

    public ClassesListController(ClassesController classesController) {
        this.classesController = classesController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public void setColumnVisibility(int n, boolean bl) {
        ((ClassesListControllerUI)((Object)this.getPanel())).setColumnVisibility(n, bl);
    }

    public Object[][] getData(String[] stringArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, int n3) {
        boolean bl4 = this.isDiff();
        boolean bl5 = this.classesController.getHeapFragmentWalker().getRetainedSizesStatus() == 3;
        long l = this.classesController.getHeapFragmentWalker().getTotalLiveInstances();
        long l2 = this.classesController.getHeapFragmentWalker().getTotalLiveBytes();
        List list = this.getFilteredSortedClasses(stringArray, n, bl, bl2, n2, bl3);
        Object[][] objectArray = new Object[list.size()][n3 + 1];
        this.minDiff = Long.MAX_VALUE;
        this.maxDiff = Long.MIN_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            JavaClass javaClass = (JavaClass)list.get(i);
            int n4 = javaClass.getInstancesCount();
            long l3 = javaClass.getAllInstancesSize();
            long l4 = -1L;
            if (bl5) {
                l4 = javaClass.getRetainedSizeByClass();
            }
            objectArray[i][0] = javaClass.getName();
            if (bl4) {
                this.minDiff = Math.min(this.minDiff, (long)n4);
                this.maxDiff = Math.max(this.maxDiff, (long)n4);
                objectArray[i][1] = new Long(n4);
                objectArray[i][2] = (n4 > 0 ? "+" : "") + numberFormat.format(n4);
                objectArray[i][3] = (l3 > 0L ? "+" : "") + numberFormat.format(l3);
                if (bl5) {
                    objectArray[i][4] = !this.compareRetained ? Bundle.ClassesListController_ResultNotAvailableString() : (l4 > 0L ? "+" : "") + numberFormat.format(l4);
                }
            } else {
                objectArray[i][1] = new Double((double)n4 / (double)l * 100.0);
                objectArray[i][2] = numberFormat.format(n4) + " (" + percentFormat.format((double)n4 / (double)l) + ")";
                Object object = objectArray[i][3] = l3 < 0L ? Bundle.ClassesListController_ResultNotAvailableString() : numberFormat.format(l3) + " (" + percentFormat.format((double)l3 / (double)l2) + ")";
                if (bl5) {
                    objectArray[i][4] = l4 < 0L ? Bundle.ClassesListController_ResultNotAvailableString() : numberFormat.format(l4) + " (" + percentFormat.format((double)l4 / (double)l2) + ")";
                }
            }
            objectArray[i][n3] = bl4 ? ((DiffJavaClass)javaClass).getJavaClass() : javaClass;
        }
        if (this.minDiff > 0L && this.maxDiff > 0L) {
            this.minDiff = 0L;
        } else if (this.minDiff < 0L && this.maxDiff < 0L) {
            this.maxDiff = 0L;
        }
        return objectArray;
    }

    public List getFilteredSortedClasses(String[] stringArray, int n, boolean bl, boolean bl2, int n2, boolean bl3) {
        List list;
        HeapFragmentWalker heapFragmentWalker = this.classesController.getHeapFragmentWalker();
        Heap heap = heapFragmentWalker.getHeapFragment();
        if (n == 1001 && stringArray != null && !stringArray[0].isEmpty()) {
            list = ClassesListController.getFilteredClasses(ClassesListController.getSubclasses(heap, this.diffClasses, stringArray, heapFragmentWalker.getHeapDumpProject()), null, 0, bl, bl2);
        } else {
            List list2 = this.diffClasses == null ? heap.getAllClasses() : this.diffClasses;
            list = ClassesListController.getFilteredClasses(list2, stringArray, n, bl, bl2);
        }
        return ClassesListController.getSortedClasses(list, n2, bl3);
    }

    public JavaClass getSelectedClass() {
        return this.selectedClass;
    }

    public void classSelected(JavaClass javaClass) {
        if (this.selectedClass == javaClass) {
            return;
        }
        this.selectedClass = javaClass;
        this.classesController.classSelected();
    }

    public static boolean matchesFilter(JavaClass javaClass, String[] stringArray, int n, boolean bl, boolean bl2) {
        int n2 = javaClass.getInstancesCount();
        int n3 = javaClass.getInstanceSize();
        if (!bl && n2 == 0) {
            return false;
        }
        if (!(bl2 || n2 != 0 && n3 != 0)) {
            return false;
        }
        if (n == 0 || stringArray == null || stringArray[0].isEmpty()) {
            return true;
        }
        return ClassesListController.passesFilters(javaClass.getName(), stringArray, n);
    }

    public void selectClass(JavaClass javaClass) {
        ((ClassesListControllerUI)((Object)this.getPanel())).selectClass(javaClass);
    }

    public void updateData() {
        ((ClassesListControllerUI)((Object)this.getPanel())).updateData();
    }

    private void showDiffProgress() {
        ((ClassesListControllerUI)((Object)this.getPanel())).showDiffProgress();
    }

    private void hideDiffProgress() {
        ((ClassesListControllerUI)((Object)this.getPanel())).hideDiffProgress();
    }

    public void compareAction() {
        if (this.comparingSnapshot) {
            return;
        }
        this.comparingSnapshot = true;
        BrowserUtils.performTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    try {
                        HeapFragmentWalker heapFragmentWalker = ClassesListController.this.classesController.getHeapFragmentWalker();
                        CompareSnapshotsHelper.Result result = CompareSnapshotsHelper.selectSnapshot(heapFragmentWalker, ((ClassesListControllerUI)((Object)ClassesListController.this.getPanel())).isRetainedVisible());
                        if (result == null) break block8;
                        try {
                            ClassesListController.this.showDiffProgress();
                            Heap heap = heapFragmentWalker.getHeapFragment();
                            Heap heap2 = HeapFactory.createHeap((File)result.getFile());
                            ClassesListController.this.compareRetained = result.compareRetained();
                            ClassesListController.this.diffClasses = ClassesListController.this.createDiffClasses(heap2, heap);
                        }
                        catch (Exception exception) {
                            ProfilerDialogs.displayError((String)Bundle.ClassesListController_CompareFailed());
                            ProfilerLogger.log((Exception)exception);
                        }
                        finally {
                            ClassesListController.this.hideDiffProgress();
                        }
                        ClassesListController.this.updateData();
                    }
                    finally {
                        ClassesListController.this.comparingSnapshot = false;
                    }
                }
            }
        });
    }

    public boolean isDiff() {
        return this.diffClasses != null;
    }

    public boolean compareRetained() {
        return this.compareRetained;
    }

    private List createDiffClasses(Heap heap, Heap heap2) {
        Object object;
        String string;
        Object object22;
        if (this.compareRetained) {
            this.classesController.getHeapFragmentWalker().computeRetainedSizes(false, false);
        }
        HashMap<Object, DiffJavaClass> hashMap = new HashMap<Object, DiffJavaClass>();
        List list = heap.getAllClasses();
        for (Object object22 : list) {
            string = DiffJavaClass.createID((JavaClass)object22);
            object = DiffJavaClass.createExternal((JavaClass)object22, this.compareRetained);
            hashMap.put(string, (DiffJavaClass)object);
        }
        List list2 = heap2.getAllClasses();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            string = (JavaClass)object22.next();
            object = DiffJavaClass.createID((JavaClass)string);
            DiffJavaClass diffJavaClass = DiffJavaClass.createReal((JavaClass)string, this.compareRetained);
            DiffJavaClass diffJavaClass2 = (DiffJavaClass)hashMap.get(object);
            if (diffJavaClass2 != null) {
                diffJavaClass2.diff(diffJavaClass);
                continue;
            }
            hashMap.put(object, diffJavaClass);
        }
        return new ArrayList(hashMap.values());
    }

    public void resetDiffAction() {
        if (this.diffClasses != null) {
            this.diffClasses.clear();
            this.diffClasses = null;
        }
        this.hideDiffProgress();
        this.updateData();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((ClassesListControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new ClassesListControllerUI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getContextSubclasses(Heap heap, String string, Lookup.Provider provider) {
        ProgressHandle progressHandle = null;
        try {
            progressHandle = ProgressHandleFactory.createHandle((String)Bundle.ClassesListController_AnalyzingClassesMsg());
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
            SourceClassInfo sourceClassInfo = ProfilerTypeUtils.resolveClass((String)string, (Lookup.Provider)provider);
            Collection collection = sourceClassInfo != null ? sourceClassInfo.getSubclasses() : Collections.EMPTY_LIST;
            for (SourceClassInfo sourceClassInfo2 : collection) {
                JavaClass javaClass = heap.getJavaClassByName(sourceClassInfo2.getQualifiedName());
                if (javaClass == null || !hashSet.add(javaClass)) continue;
                hashSet.addAll(javaClass.getSubClasses());
            }
            HashSet<JavaClass> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
        }
    }

    private static List getFilteredClasses(List list, String[] stringArray, int n, boolean bl, boolean bl2) {
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (JavaClass javaClass : list) {
            if (!ClassesListController.matchesFilter(javaClass, stringArray, n, bl, bl2)) continue;
            arrayList.add(javaClass);
        }
        return arrayList;
    }

    private static List getSortedClasses(List list, int n, boolean bl) {
        Collections.sort(list, new ClassesComparator(n, bl));
        return list;
    }

    private static List getSubclasses(Heap heap, List list, String[] stringArray, Lookup.Provider provider) {
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].replace(".", "\\.").replace("$", "\\$");
            Collection collection = heap.getJavaClassesByRegExp(string);
            for (JavaClass javaClass : collection) {
                Collection collection2 = javaClass.getSubClasses();
                hashSet.add(javaClass);
                if (collection2.size() > 0) {
                    hashSet.addAll(collection2);
                    continue;
                }
                if (provider == null) continue;
                hashSet.addAll(ClassesListController.getContextSubclasses(heap, stringArray[i], provider));
            }
        }
        if (list != null) {
            ArrayList arrayList = new ArrayList();
            for (Object e : hashSet) {
                int n = list.indexOf(DiffJavaClass.createExternal((JavaClass)e, false));
                if (n == -1) continue;
                arrayList.add(list.get(n));
            }
            return arrayList;
        }
        return new ArrayList(hashSet);
    }

    private static boolean passesFilter(String string, String string2, int n) {
        switch (n) {
            case 20: {
                return string.toLowerCase().contains(string2);
            }
            case 25: {
                return !string.toLowerCase().contains(string2);
            }
            case 50: {
                try {
                    return string.matches(string2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean passesFilters(String string, String[] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ClassesListController.passesFilter(string, stringArray[i], n)) continue;
            return true;
        }
        return false;
    }

    static {
        percentFormat.setMaximumFractionDigits(1);
        percentFormat.setMinimumFractionDigits(0);
    }

    private static final class DiffJavaClass
    implements JavaClass {
        private final String name;
        private String id;
        private long allInstancesSize;
        private int instanceSize;
        private int instancesCount;
        private long retainedSizeByClass;
        private JavaClass real;

        static DiffJavaClass createExternal(JavaClass javaClass, boolean bl) {
            return new DiffJavaClass(javaClass, false, bl);
        }

        static DiffJavaClass createReal(JavaClass javaClass, boolean bl) {
            return new DiffJavaClass(javaClass, true, bl);
        }

        private DiffJavaClass(JavaClass javaClass, boolean bl, boolean bl2) {
            this.name = javaClass.getName();
            if (bl) {
                this.instancesCount = javaClass.getInstancesCount();
                this.instanceSize = javaClass.getInstanceSize();
                this.allInstancesSize = javaClass.getAllInstancesSize();
                this.retainedSizeByClass = bl2 ? javaClass.getRetainedSizeByClass() : -1L;
                this.real = javaClass;
            } else {
                this.instancesCount = -javaClass.getInstancesCount();
                this.instanceSize = -javaClass.getInstanceSize();
                this.allInstancesSize = -javaClass.getAllInstancesSize();
                this.retainedSizeByClass = bl2 ? -javaClass.getRetainedSizeByClass() : -1L;
                this.real = null;
            }
        }

        static String createID(JavaClass javaClass) {
            String string = javaClass.getName();
            try {
                string = string + javaClass.getClassLoader().getJavaClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (javaClass instanceof DiffJavaClass) {
                ((DiffJavaClass)javaClass).setID(string);
            }
            return string;
        }

        private synchronized void setID(String string) {
            this.id = string;
        }

        synchronized String getID() {
            if (this.id == null) {
                DiffJavaClass.createID(this);
            }
            return this.id;
        }

        JavaClass getJavaClass() {
            return this.real;
        }

        void diff(DiffJavaClass diffJavaClass) {
            this.instancesCount += diffJavaClass.instancesCount;
            this.instanceSize += diffJavaClass.instanceSize;
            this.allInstancesSize += diffJavaClass.allInstancesSize;
            this.retainedSizeByClass += diffJavaClass.retainedSizeByClass;
            this.real = diffJavaClass.real;
        }

        public boolean equals(Object object) {
            if (object instanceof DiffJavaClass) {
                return this.getID().equals(((DiffJavaClass)object).getID());
            }
            return false;
        }

        public int hashCode() {
            return this.getID().hashCode();
        }

        public Object getValueOfStaticField(String string) {
            return null;
        }

        public long getAllInstancesSize() {
            return this.allInstancesSize;
        }

        public boolean isArray() {
            return false;
        }

        public Instance getClassLoader() {
            return null;
        }

        public List getFields() {
            return null;
        }

        public int getInstanceSize() {
            return this.instanceSize;
        }

        public List getInstances() {
            return null;
        }

        public int getInstancesCount() {
            return this.instancesCount;
        }

        public long getJavaClassId() {
            return -1L;
        }

        public String getName() {
            return this.name;
        }

        public List getStaticFieldValues() {
            return null;
        }

        public Collection getSubClasses() {
            return null;
        }

        public JavaClass getSuperClass() {
            return null;
        }

        public long getRetainedSizeByClass() {
            return this.retainedSizeByClass;
        }
    }

    private static class ClassesComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public ClassesComparator(int n, boolean bl) {
            this.sortingColumn = n;
            this.sortingOrder = bl;
        }

        public int compare(Object object, Object object2) {
            JavaClass javaClass = this.sortingOrder ? (JavaClass)object : (JavaClass)object2;
            JavaClass javaClass2 = this.sortingOrder ? (JavaClass)object2 : (JavaClass)object;
            switch (this.sortingColumn) {
                case 0: {
                    return javaClass.getName().compareTo(javaClass2.getName());
                }
                case 1: 
                case 2: {
                    return Integer.valueOf(javaClass.getInstancesCount()).compareTo(javaClass2.getInstancesCount());
                }
                case 3: {
                    return Long.valueOf(javaClass.getAllInstancesSize()).compareTo(javaClass2.getAllInstancesSize());
                }
                case 4: {
                    return Long.valueOf(javaClass.getRetainedSizeByClass()).compareTo(javaClass2.getRetainedSizeByClass());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + object + ", " + object2);
        }
    }
}

