/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.security;

import com.jrockit.mc.core.security.ISecurityManager;

public final class SecurityManagerFactory {
    private static ISecurityManager instance;

    static {
        String className = System.getProperty("com.jrockit.mc.common.security.manager");
        try {
            if (className != null) {
                Class<?> c = Class.forName(className);
                instance = (ISecurityManager)c.newInstance();
            }
        }
        catch (Exception e) {
            System.out.println("Could not create Security manager for className. Using default! Exception was:");
            e.printStackTrace();
        }
    }

    public static final synchronized void setDefaultSecurityManager(ISecurityManager manager) {
        if (instance == null) {
            instance = manager;
        }
    }

    public static final synchronized ISecurityManager getSecurityManager() {
        return instance;
    }

    private SecurityManagerFactory() {
        throw new AssertionError((Object)"This class is not to be instantiated!");
    }
}

