/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public final class HeapDumpAction
extends ProfilingAwareAction {
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    private static final String SELECTING_TARGET_CANCELLED = "&*$?CANCELLED?$*&";
    private static final int[] ENABLED_STATES = new int[]{4};
    private static JFileChooser snapshotDirectoryChooser;
    private ChooseHeapdumpTargetPanel heapdumpTargetSelector;

    public static HeapDumpAction getInstance() {
        return Singleton.INSTANCE;
    }

    public HeapDumpAction() {
        this.setIcon(Icons.getIcon((String)"ProfilerIcons.SnapshotHeap"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.SnapshotHeap"));
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.HeapDumpAction_ActionName();
    }

    public void dumpToProject() {
        this.takeHeapDump(false);
    }

    public void performAction() {
        this.takeHeapDump(true);
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    private String getCurrentHeapDumpFilename(String string) {
        try {
            String string2 = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject fileObject = string == null ? ProjectStorage.getSettingsFolder((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (boolean)true) : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
            return FileUtil.toFile((FileObject)fileObject).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)fileObject, (String)string2, (String)"hprof") + "." + "hprof";
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void updateAction() {
        String string;
        boolean bl = false;
        boolean bl2 = this.shouldBeEnabled(Profiler.getDefault());
        if (bl2 && (string = Profiler.getDefault().getTargetAppRunner().getProfilerEngineSettings().getRemoteHost()) != null && !string.isEmpty()) {
            bl = true;
        }
        this.setEnabled(!bl && bl2);
        this.setToolTipText(bl ? Bundle.HeapDumpAction_ToolTipNoRemote() : Bundle.HeapDumpAction_ToolTip());
    }

    private void setToolTipText(String string) {
        Object object = this.getProperty("ShortDescription");
        this.putProperty("ShortDescription", string);
        this.firePropertyChange("ShortDescription", object, string);
    }

    private boolean isHeapDumpSupported() {
        String string;
        int n;
        TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
        String string2 = targetAppRunner.getProfilerEngineSettings().getTargetJDKVersionString();
        if ("jdk16".equals(string2) || "jdk17".equals(string2) || "jdk18".equals(string2)) {
            return true;
        }
        return "jdk15".equals(string2) && (n = Platform.getJDKMinorNumber((String)(string = targetAppRunner.getProfilingSessionStatus().fullTargetJDKVersionString))) >= 12;
    }

    private static JFileChooser getSnapshotDirectoryChooser() {
        if (snapshotDirectoryChooser == null) {
            snapshotDirectoryChooser = new JFileChooser();
            snapshotDirectoryChooser.setFileSelectionMode(1);
            snapshotDirectoryChooser.setMultiSelectionEnabled(false);
            snapshotDirectoryChooser.setDialogType(0);
            snapshotDirectoryChooser.setDialogTitle(Bundle.HeapDumpAction_DirectoryDialogCaption());
        }
        return snapshotDirectoryChooser;
    }

    private ChooseHeapdumpTargetPanel getHeapdumpTargetSelector() {
        if (this.heapdumpTargetSelector == null) {
            this.heapdumpTargetSelector = new ChooseHeapdumpTargetPanel();
        }
        return this.heapdumpTargetSelector;
    }

    private String selectTargetDirectory() {
        ChooseHeapdumpTargetPanel chooseHeapdumpTargetPanel = this.getHeapdumpTargetSelector();
        chooseHeapdumpTargetPanel.updateDefaultLocation(NetBeansProfiler.getDefaultNB().getProfiledProject() != null ? Bundle.HeapDumpAction_LocationProjectString() : Bundle.HeapDumpAction_LocationGlobalString());
        int n = chooseHeapdumpTargetPanel.getDestinationType();
        String string = chooseHeapdumpTargetPanel.getCustomDirectory();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)chooseHeapdumpTargetPanel, Bundle.HeapDumpAction_DestinationDialogCaption(), true, new Object[]{chooseHeapdumpTargetPanel.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (!object.equals(chooseHeapdumpTargetPanel.getOKButton())) {
            chooseHeapdumpTargetPanel.setDestinationType(n);
            chooseHeapdumpTargetPanel.setCustomDirectory(string);
            return SELECTING_TARGET_CANCELLED;
        }
        int n2 = chooseHeapdumpTargetPanel.getDestinationType();
        if (n2 == 0) {
            chooseHeapdumpTargetPanel.setCustomDirectory(string);
            return this.getCurrentHeapDumpFilename(null);
        }
        if (n2 == 1) {
            return this.getCurrentHeapDumpFilename(chooseHeapdumpTargetPanel.getCustomDirectory());
        }
        return null;
    }

    private void takeHeapDump(final boolean bl) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
                if (!targetAppRunner.hasSupportedJDKForHeapDump()) {
                    ProfilerDialogs.displayWarning((String)Bundle.HeapDumpAction_RequiredJdkMsg());
                    return;
                }
                if (targetAppRunner.getProfilingSessionStatus().remoteProfiling) {
                    ProfilerDialogs.displayWarning((String)Bundle.HeapDumpAction_RemoteUnsupportedMsg());
                    return;
                }
                try {
                    String string;
                    String string2 = string = bl ? HeapDumpAction.this.selectTargetDirectory() : HeapDumpAction.this.getCurrentHeapDumpFilename(null);
                    if (string == HeapDumpAction.SELECTING_TARGET_CANCELLED) {
                        return;
                    }
                    if (string == null) {
                        ProfilerDialogs.displayError((String)Bundle.HeapDumpAction_WrongDestinationMsg());
                        return;
                    }
                    boolean bl2 = false;
                    ProgressHandle progressHandle = null;
                    try {
                        progressHandle = ProgressHandleFactory.createHandle((String)Bundle.HeapDumpAction_DumpingHeapText());
                        progressHandle.setInitialDelay(0);
                        progressHandle.start();
                        bl2 = targetAppRunner.getProfilerClient().takeHeapDump(string);
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                    }
                    if (bl2) {
                        if (ProfilerControlPanel2.hasDefault()) {
                            ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                        }
                        if (bl) {
                            if (ProfilerDialogs.displayConfirmationDNSA((String)Bundle.HeapDumpAction_SavedDialogText(), (String)Bundle.HeapDumpAction_SavedDialogCaption(), null, (String)"HeapDumpAction.heapdumpSaved", (boolean)false)) {
                                ResultsManager.getDefault().openSnapshot(new File(string));
                            }
                        } else if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                            ResultsManager.getDefault().openSnapshot(new File(string));
                        }
                    } else {
                        ProfilerDialogs.displayError((String)Bundle.HeapDumpAction_DumpingFailedMsg());
                    }
                }
                catch (Exception exception) {
                    ProfilerDialogs.displayError((String)exception.getMessage());
                    ProfilerLogger.log((Exception)exception);
                }
            }
        });
    }

    private static class ChooseHeapdumpTargetPanel
    extends JPanel
    implements HelpCtx.Provider {
        private static final String HELP_CTX_KEY = "ChooseHeapdumpTargetPanel.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("ChooseHeapdumpTargetPanel.HelpCtx");
        public static final int DESTINATION_DEFAULT = 0;
        public static final int DESTINATION_CUSTOM = 1;
        private JButton customLocationButton;
        private JButton okButton;
        private JLabel chooseDestinationLabel;
        private JRadioButton customLocationRadio;
        private JRadioButton defaultLocationRadio;
        private JTextField customLocationField;

        public ChooseHeapdumpTargetPanel() {
            this.initComponents();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }

        public String getCustomDirectory() {
            return this.customLocationField.getText();
        }

        public void setCustomDirectory(String string) {
            this.customLocationField.setText(string);
        }

        public int getDestinationType() {
            if (this.defaultLocationRadio.isSelected()) {
                return 0;
            }
            return 1;
        }

        public void setDestinationType(int n) {
            this.defaultLocationRadio.setSelected(n == 0);
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public void updateDefaultLocation(String string) {
            this.defaultLocationRadio.setText(string);
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.HeapDumpAction_OkButtonText());
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.chooseDestinationLabel = new JLabel(Bundle.HeapDumpAction_DestinationLabelText());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 8, 5);
            this.add((Component)this.chooseDestinationLabel, gridBagConstraints);
            this.defaultLocationRadio = new JRadioButton(Bundle.HeapDumpAction_DefaultLocationRadioText());
            buttonGroup.add(this.defaultLocationRadio);
            this.defaultLocationRadio.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.defaultLocationRadio, gridBagConstraints);
            this.customLocationRadio = new JRadioButton(Bundle.HeapDumpAction_CustomLocationRadioText());
            buttonGroup.add(this.customLocationRadio);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.customLocationRadio, gridBagConstraints);
            String string = System.getProperty("java.io.tmpdir");
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - File.separator.length());
            }
            this.customLocationField = new JTextField();
            this.customLocationField.setText(string);
            this.customLocationField.setPreferredSize(new Dimension(210, this.customLocationField.getPreferredSize().height));
            this.customLocationField.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.customLocationField, gridBagConstraints);
            this.customLocationButton = new JButton(Bundle.HeapDumpAction_BrowseButtonText());
            this.customLocationButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.customLocationButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), gridBagConstraints);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            };
            this.customLocationField.getDocument().addDocumentListener(documentListener);
            this.defaultLocationRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            });
            this.customLocationRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ChooseHeapdumpTargetPanel.this.customLocationField.setEnabled(ChooseHeapdumpTargetPanel.this.customLocationRadio.isSelected());
                    ChooseHeapdumpTargetPanel.this.customLocationButton.setEnabled(ChooseHeapdumpTargetPanel.this.customLocationRadio.isSelected());
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            });
            this.customLocationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = HeapDumpAction.getSnapshotDirectoryChooser();
                    jFileChooser.setCurrentDirectory(new File(ChooseHeapdumpTargetPanel.this.getCustomDirectory()));
                    if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        ChooseHeapdumpTargetPanel.this.customLocationField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.defaultLocationRadio.isSelected()) {
                this.okButton.setEnabled(true);
            } else if (this.customLocationRadio.isSelected()) {
                File file = new File(this.getCustomDirectory());
                this.okButton.setEnabled(file.exists() && file.isDirectory());
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    private static final class Singleton {
        private static final HeapDumpAction INSTANCE = new HeapDumpAction();

        private Singleton() {
        }
    }
}

