/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.core.multiview.Bundle;
import org.netbeans.core.multiview.MultiViewCloneableTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SplitAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    boolean useSplitName = false;

    public SplitAction() {
        super(Bundle.CTL_SplitDocumentAction());
    }

    public SplitAction(boolean bl) {
        super(Bundle.CTL_SplitDocumentAction());
        this.useSplitName = bl;
    }

    static Action createSplitAction(Map map) {
        if (!SplitAction.isSplitingEnabled()) {
            return null;
        }
        Object v = map.get("displayName");
        if (v == null) {
            return null;
        }
        return new SplitAction(v.toString().equals(Bundle.CTL_SplitAction()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        return this.getSplitMenuItem();
    }

    public JMenuItem getPopupPresenter() {
        return this.getSplitMenuItem();
    }

    private JMenuItem getSplitMenuItem() {
        if (!SplitAction.isSplitingEnabled()) {
            return null;
        }
        UpdatingMenu updatingMenu = new UpdatingMenu();
        String string = this.useSplitName ? Bundle.CTL_SplitAction() : Bundle.CTL_SplitDocumentAction();
        Mnemonics.setLocalizedText((AbstractButton)updatingMenu, (String)string);
        return updatingMenu;
    }

    private static boolean isSplitingEnabled() {
        boolean bl = "true".equals(Bundle.MultiViewElement_Spliting_Enabled());
        return bl;
    }

    static void splitWindow(TopComponent topComponent, int n) {
        if (topComponent instanceof MultiViewTopComponent || topComponent instanceof MultiViewCloneableTopComponent) {
            TopComponent topComponent2 = topComponent instanceof MultiViewTopComponent ? ((MultiViewTopComponent)topComponent).splitComponent(n) : ((MultiViewCloneableTopComponent)topComponent).splitComponent(n);
            topComponent2.open();
            topComponent2.requestActive();
        }
    }

    static void clearSplit(TopComponent topComponent) {
        if (topComponent instanceof MultiViewTopComponent || topComponent instanceof MultiViewCloneableTopComponent) {
            TopComponent topComponent2 = topComponent instanceof MultiViewTopComponent ? ((MultiViewTopComponent)topComponent).clearSplit() : ((MultiViewCloneableTopComponent)topComponent).clearSplit();
            topComponent2.open();
            topComponent2.requestActive();
        }
    }

    private static class ClearSplitAction
    extends AbstractAction {
        private final TopComponent tc;

        public ClearSplitAction(TopComponent topComponent) {
            this.tc = topComponent;
            this.putValue("Name", Bundle.LBL_ClearSplitAction());
            this.putValue("_nb_action_id_", Bundle.LBL_ValueClearSplit());
            if (topComponent instanceof MultiViewTopComponent) {
                this.setEnabled(((MultiViewTopComponent)topComponent).getSplitOrientation() != -1);
            } else if (topComponent instanceof MultiViewCloneableTopComponent) {
                this.setEnabled(((MultiViewCloneableTopComponent)topComponent).getSplitOrientation() != -1);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitAction.clearSplit(this.tc);
        }
    }

    private static class SplitDocumentAction
    extends AbstractAction {
        private final TopComponent tc;
        private final int orientation;

        public SplitDocumentAction(TopComponent topComponent, int n) {
            this.tc = topComponent;
            this.orientation = n;
            this.putValue("Name", n == 0 ? Bundle.LBL_SplitDocumentActionVertical() : Bundle.LBL_SplitDocumentActionHorizontal());
            this.putValue("_nb_action_id_", n == 0 ? Bundle.LBL_ValueSplitVertical() : Bundle.LBL_ValueSplitHorizontal());
            if (topComponent instanceof MultiViewTopComponent) {
                this.setEnabled(((MultiViewTopComponent)topComponent).getSplitOrientation() == -1 || ((MultiViewTopComponent)topComponent).getSplitOrientation() != n);
            } else if (topComponent instanceof MultiViewCloneableTopComponent) {
                this.setEnabled(((MultiViewCloneableTopComponent)topComponent).getSplitOrientation() == -1 || ((MultiViewCloneableTopComponent)topComponent).getSplitOrientation() != n);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitAction.splitWindow(this.tc, this.orientation);
        }
    }

    private static final class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private UpdatingMenu() {
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }

        public JComponent[] getMenuPresenters() {
            assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT";
            this.removeAll();
            TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
            if (topComponent != null) {
                this.setEnabled(true);
                if (topComponent instanceof MultiViewTopComponent || topComponent instanceof MultiViewCloneableTopComponent) {
                    JMenuItem jMenuItem = new JMenuItem(new SplitDocumentAction(topComponent, 0));
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                    jMenuItem = new JMenuItem(new SplitDocumentAction(topComponent, 1));
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                    jMenuItem = new JMenuItem(new ClearSplitAction(topComponent));
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }
    }
}

