/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.openide.filesystems.FileFilterSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class FileChooserBuilder {
    private boolean dirsOnly;
    private BadgeProvider badger;
    private String title;
    private String approveText;
    private static boolean PREVENT_SYMLINK_TRAVERSAL = !Boolean.getBoolean("allow.filechooser.symlink.traversal");
    private final String dirKey;
    private File failoverDir;
    private FileFilter filter;
    private boolean fileHiding;
    private boolean controlButtonsShown = true;
    private String aDescription;
    private boolean filesOnly;
    private static final boolean DONT_STORE_DIRECTORIES = Boolean.getBoolean("forget.recent.dirs");
    private SelectionApprover approver;
    private final List<FileFilter> filters = new ArrayList<FileFilter>(3);
    private boolean useAcceptAllFileFilter = true;
    private boolean force = false;

    public FileChooserBuilder(Class clazz) {
        this(clazz.getName());
    }

    public FileChooserBuilder(String string) {
        Parameters.notNull((CharSequence)"dirKey", (Object)string);
        this.dirKey = string;
    }

    public FileChooserBuilder setDirectoriesOnly(boolean bl) {
        this.dirsOnly = bl;
        assert (!this.filesOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setFilesOnly(boolean bl) {
        this.filesOnly = bl;
        assert (!this.dirsOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setBadgeProvider(BadgeProvider badgeProvider) {
        this.badger = badgeProvider;
        return this;
    }

    public FileChooserBuilder setTitle(String string) {
        this.title = string;
        return this;
    }

    public FileChooserBuilder setApproveText(String string) {
        this.approveText = string;
        return this;
    }

    public FileChooserBuilder setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
        return this;
    }

    public FileChooserBuilder setAcceptAllFileFilterUsed(boolean bl) {
        this.useAcceptAllFileFilter = bl;
        return this;
    }

    public FileChooserBuilder setDefaultWorkingDirectory(File file) {
        this.failoverDir = file;
        return this;
    }

    public FileChooserBuilder setFileHiding(boolean bl) {
        this.fileHiding = bl;
        return this;
    }

    public FileChooserBuilder setControlButtonsAreShown(boolean bl) {
        this.controlButtonsShown = bl;
        return this;
    }

    public FileChooserBuilder setAccessibleDescription(String string) {
        this.aDescription = string;
        return this;
    }

    public JFileChooser createFileChooser() {
        SavedDirFileChooser savedDirFileChooser = new SavedDirFileChooser(this.dirKey, this.failoverDir, this.force, this.approver);
        this.prepareFileChooser(savedDirFileChooser);
        return savedDirFileChooser;
    }

    public FileChooserBuilder forceUseOfDefaultWorkingDirectory(boolean bl) {
        this.force = bl;
        return this;
    }

    private Component findDialogParent() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (component == null) {
            Frame[] frameArray = Frame.getFrames();
            component = frameArray.length == 0 ? null : frameArray[frameArray.length - 1];
        }
        return component;
    }

    public File[] showMultiOpenDialog() {
        JFileChooser jFileChooser = this.createFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this.findDialogParent());
        if (0 == n) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            return fileArray == null ? new File[]{} : fileArray;
        }
        return null;
    }

    public File showOpenDialog() {
        FileDialog fileDialog;
        JFileChooser jFileChooser = this.createFileChooser();
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(jFileChooser.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 0);
        }
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this.findDialogParent());
        if (0 == n) {
            File file = jFileChooser.getSelectedFile();
            if (file != null && !file.exists()) {
                file = null;
            }
            return file;
        }
        return null;
    }

    public File showSaveDialog() {
        FileDialog fileDialog;
        JFileChooser jFileChooser = this.createFileChooser();
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(jFileChooser.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 1);
        }
        int n = jFileChooser.showSaveDialog(this.findDialogParent());
        if (0 == n) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File showFileDialog(FileDialog fileDialog, int n) {
        String string = System.getProperty("apple.awt.fileDialogForDirectories");
        if (this.dirsOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        fileDialog.setMode(n);
        fileDialog.setVisible(true);
        if (this.dirsOnly) {
            if (null != string) {
                System.setProperty("apple.awt.fileDialogForDirectories", string);
            } else {
                System.clearProperty("apple.awt.fileDialogForDirectories");
            }
        }
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            String string2 = fileDialog.getFile();
            File file = new File(fileDialog.getDirectory());
            return new File(file, string2);
        }
        return null;
    }

    private void prepareFileChooser(JFileChooser jFileChooser) {
        jFileChooser.setFileSelectionMode(this.dirsOnly ? 1 : (this.filesOnly ? 0 : 2));
        jFileChooser.setFileHidingEnabled(this.fileHiding);
        jFileChooser.setControlButtonsAreShown(this.controlButtonsShown);
        jFileChooser.setAcceptAllFileFilterUsed(this.useAcceptAllFileFilter);
        if (this.title != null) {
            jFileChooser.setDialogTitle(this.title);
        }
        if (this.approveText != null) {
            jFileChooser.setApproveButtonText(this.approveText);
        }
        if (this.badger != null) {
            jFileChooser.setFileView(new CustomFileView(new BadgeIconProvider(this.badger), jFileChooser.getFileSystemView()));
        }
        if (PREVENT_SYMLINK_TRAVERSAL) {
            FileUtil.preventFileChooserSymlinkTraversal(jFileChooser, jFileChooser.getCurrentDirectory());
        }
        if (this.filter != null) {
            jFileChooser.setFileFilter(this.filter);
        }
        if (this.aDescription != null) {
            jFileChooser.getAccessibleContext().setAccessibleDescription(this.aDescription);
        }
        if (!this.filters.isEmpty()) {
            for (FileFilter fileFilter : this.filters) {
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
        }
    }

    private FileDialog createFileDialog(File file) {
        if (this.badger != null) {
            return null;
        }
        if (!Boolean.getBoolean("nb.native.filechooser")) {
            return null;
        }
        if (this.dirsOnly && !Utilities.isMac()) {
            return null;
        }
        Component component = this.findDialogParent();
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        FileDialog fileDialog = new FileDialog(frame);
        if (this.title != null) {
            fileDialog.setTitle(this.title);
        }
        if (null != file) {
            fileDialog.setDirectory(file.getAbsolutePath());
        }
        return fileDialog;
    }

    public FileChooserBuilder addFileFilter(FileFilter fileFilter) {
        this.filters.add(fileFilter);
        return this;
    }

    public FileChooserBuilder addDefaultFileFilters() {
        this.filters.addAll(FileFilterSupport.findRegisteredFileFilters());
        return this;
    }

    public FileChooserBuilder setSelectionApprover(SelectionApprover selectionApprover) {
        this.approver = selectionApprover;
        return this;
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            assert (icon != null);
            assert (icon2 != null);
            this.icon1 = icon;
            this.icon2 = icon2;
            if (n == -1) {
                n = icon.getIconWidth() - icon2.getIconWidth();
            }
            if (n2 == -1) {
                n2 = icon.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = n;
            this.yMerge = n2;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2);
            this.icon2.paintIcon(component, graphics, n + this.xMerge, n2 + this.yMerge);
        }
    }

    private static final class CustomFileView
    extends FileView {
        private final IconProvider provider;
        private final FileSystemView view;

        CustomFileView(IconProvider iconProvider, FileSystemView fileSystemView) {
            this.provider = iconProvider;
            this.view = fileSystemView;
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = this.view.getSystemIcon(file);
            icon = this.provider.getIcon(file, icon);
            return icon;
        }
    }

    private static final class BadgeIconProvider
    implements IconProvider {
        private final BadgeProvider badger;

        public BadgeIconProvider(BadgeProvider badgeProvider) {
            this.badger = badgeProvider;
        }

        @Override
        public Icon getIcon(File file, Icon icon) {
            Icon icon2 = this.badger.getBadge(file);
            if (icon2 != null && icon != null) {
                return new MergedIcon(icon, icon2, this.badger.getXOffset(), this.badger.getYOffset());
            }
            return icon;
        }
    }

    public static interface BadgeProvider {
        public Icon getBadge(File var1);

        public int getXOffset();

        public int getYOffset();
    }

    static interface IconProvider {
        public Icon getIcon(File var1, Icon var2);
    }

    private static final class SavedDirFileChooser
    extends JFileChooser {
        private final String dirKey;
        private final SelectionApprover approver;

        SavedDirFileChooser(String string, File file, boolean bl, SelectionApprover selectionApprover) {
            this.dirKey = string;
            this.approver = selectionApprover;
            if (bl && file != null && file.exists() && file.isDirectory()) {
                this.setCurrentDirectory(file);
            } else {
                String string2;
                String string3 = string2 = DONT_STORE_DIRECTORIES ? null : NbPreferences.forModule(FileChooserBuilder.class).get(string, null);
                if (string2 != null) {
                    File file2 = new File(string2);
                    if (file2.exists() && file2.isDirectory()) {
                        this.setCurrentDirectory(file2);
                    } else if (file != null) {
                        this.setCurrentDirectory(file);
                    }
                } else if (file != null) {
                    this.setCurrentDirectory(file);
                }
            }
        }

        @Override
        public void approveSelection() {
            if (this.approver != null) {
                boolean bl;
                File[] fileArray = this.getSelectedFiles();
                File file = this.getSelectedFile();
                if ((fileArray == null || fileArray.length == 0) && file != null) {
                    fileArray = new File[]{file};
                }
                if (bl = this.approver.approve(fileArray)) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }

        @Override
        public int showOpenDialog(Component component) throws HeadlessException {
            int n = super.showOpenDialog(component);
            if (n == 0) {
                this.saveCurrentDir();
            }
            return n;
        }

        @Override
        public int showSaveDialog(Component component) throws HeadlessException {
            int n = super.showSaveDialog(component);
            if (n == 0) {
                this.saveCurrentDir();
            }
            return n;
        }

        private void saveCurrentDir() {
            File file = super.getCurrentDirectory();
            if (!DONT_STORE_DIRECTORIES && file != null && file.exists() && file.isDirectory()) {
                NbPreferences.forModule(FileChooserBuilder.class).put(this.dirKey, file.getPath());
            }
        }
    }

    public static interface SelectionApprover {
        public boolean approve(File[] var1);
    }
}

