/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.DeepListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

final class FileChangeImpl
extends WeakReference<FileChangeListener>
implements FileChangeListener,
Runnable {
    private static final Map<FileChangeListener, Map<File, FileChangeImpl>> holders = new WeakHashMap<FileChangeListener, Map<File, FileChangeImpl>>();
    private final File path;
    private FileObject current;
    private File currentF;
    private boolean isOnTarget = false;

    public FileChangeImpl(FileChangeListener fileChangeListener, File file) {
        super(fileChangeListener, Utilities.activeReferenceQueue());
        assert (file != null);
        this.path = file;
    }

    void locateCurrent() {
        FileObject fileObject;
        block4: {
            fileObject = this.current;
            this.currentF = FileUtil.normalizeFile(this.path);
            do {
                this.current = FileUtil.toFileObject(this.currentF);
                if (this.current != null) break block4;
                this.currentF = this.currentF.getParentFile();
            } while (this.currentF != null);
            return;
        }
        this.isOnTarget = this.path.equals(this.currentF);
        assert (this.current != null);
        if (this.current != fileObject) {
            if (fileObject != null) {
                fileObject.removeFileChangeListener(this);
            }
            this.current.addFileChangeListener(this);
            this.current.getChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someChange() {
        FileObject fileObject;
        boolean bl;
        FileChangeListener fileChangeListener;
        FileChangeImpl fileChangeImpl = this;
        synchronized (fileChangeImpl) {
            if (this.current == null) {
                return;
            }
            fileChangeListener = (FileChangeListener)this.get();
            if (fileChangeListener == null) {
                return;
            }
            bl = this.isOnTarget;
            this.locateCurrent();
            fileObject = this.current;
        }
        if (this.isOnTarget && !bl) {
            if (fileObject.isFolder()) {
                fileChangeListener.fileFolderCreated(new FileEvent(fileObject));
            } else {
                fileChangeListener.fileDataCreated(new FileEvent(fileObject));
            }
        }
    }

    @Override
    public void fileChanged(FileEvent fileEvent) {
        if (fileEvent.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                if (fileChangeListener instanceof DeepListener) {
                    ((DeepListener)fileChangeListener).fileChanged(fileEvent, true);
                } else if (fileChangeListener != null) {
                    fileChangeListener.fileChanged(fileEvent);
                }
            } else {
                this.someChange();
            }
        }
    }

    @Override
    public void fileDeleted(FileEvent fileEvent) {
        if (fileEvent.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                if (fileChangeListener instanceof DeepListener) {
                    ((DeepListener)fileChangeListener).fileDeleted(fileEvent, true);
                } else if (fileChangeListener != null) {
                    fileChangeListener.fileDeleted(fileEvent);
                }
            }
            this.someChange();
        }
    }

    @Override
    public void fileDataCreated(FileEvent fileEvent) {
        if (fileEvent.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                if (fileChangeListener instanceof DeepListener) {
                    ((DeepListener)fileChangeListener).fileDataCreated(fileEvent, true);
                } else if (fileChangeListener != null) {
                    fileChangeListener.fileDataCreated(fileEvent);
                }
            } else {
                this.someChange();
            }
        }
    }

    @Override
    public void fileFolderCreated(FileEvent fileEvent) {
        if (fileEvent.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                if (fileChangeListener instanceof DeepListener) {
                    ((DeepListener)fileChangeListener).fileFolderCreated(fileEvent, true);
                } else if (fileChangeListener != null) {
                    fileChangeListener.fileFolderCreated(fileEvent);
                }
            } else {
                this.someChange();
            }
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (fileRenameEvent.getSource() == this.current) {
            if (this.isOnTarget) {
                FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                if (fileChangeListener instanceof DeepListener) {
                    ((DeepListener)fileChangeListener).fileRenamed(fileRenameEvent, true);
                } else if (fileChangeListener != null) {
                    fileChangeListener.fileRenamed(fileRenameEvent);
                }
            }
            this.someChange();
        }
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        FileChangeListener fileChangeListener;
        if (fileAttributeEvent.getSource() == this.current && this.isOnTarget && (fileChangeListener = (FileChangeListener)this.get()) != null) {
            fileChangeListener.fileAttributeChanged(fileAttributeEvent);
        }
    }

    @Override
    public synchronized void run() {
        if (this.current != null) {
            this.current.removeFileChangeListener(this);
            this.current = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFileChangeListenerImpl(Logger logger, FileChangeListener fileChangeListener, File file) {
        assert (FileUtil.assertNormalized(file));
        logger.log(Level.FINE, "addFileChangeListener {0} @ {1}", new Object[]{fileChangeListener, file});
        Map<FileChangeListener, Map<File, FileChangeImpl>> map = holders;
        synchronized (map) {
            FileChangeImpl fileChangeImpl;
            Map<File, FileChangeImpl> map2 = holders.get(fileChangeListener);
            if (map2 == null) {
                map2 = new HashMap<File, FileChangeImpl>();
                holders.put(fileChangeListener, map2);
            }
            if ((fileChangeImpl = map2.get(file)) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Already listening to ").append(file);
                stringBuilder.append("\nnew listener   : ").append(fileChangeListener);
                stringBuilder.append("\nholder listener: ").append(fileChangeImpl.get());
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            FileChangeImpl fileChangeImpl2 = new FileChangeImpl(fileChangeListener, file);
            map2.put(file, fileChangeImpl2);
            fileChangeImpl2.locateCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileChangeListener removeFileChangeListenerImpl(Logger logger, FileChangeListener fileChangeListener, File file) {
        assert (file.equals(FileUtil.normalizeFile(file))) : "Need to normalize " + FileUtil.toDebugString(file) + "!";
        logger.log(Level.FINE, "removeFileChangeListener {0} @ {1}", new Object[]{fileChangeListener, file});
        Map<FileChangeListener, Map<File, FileChangeImpl>> map = holders;
        synchronized (map) {
            Map<File, FileChangeImpl> map2 = holders.get(fileChangeListener);
            if (map2 == null) {
                throw new IllegalArgumentException("Was not listening to " + file);
            }
            if (!map2.containsKey(file)) {
                throw new IllegalArgumentException(fileChangeListener + " was not listening to " + file + "; only to " + map2.keySet());
            }
            FileChangeImpl fileChangeImpl = map2.remove(file);
            if (map2.isEmpty()) {
                holders.remove(fileChangeListener);
            }
            fileChangeImpl.run();
            return (FileChangeListener)fileChangeImpl.get();
        }
    }

    static DeepListener addRecursiveListener(FileChangeListener fileChangeListener, File file, FileFilter fileFilter, Callable<Boolean> callable) {
        DeepListener deepListener = new DeepListener(fileChangeListener, file, fileFilter, callable);
        deepListener.init();
        FileChangeImpl.addFileChangeListenerImpl(DeepListener.LOG, deepListener, file);
        return deepListener;
    }

    static void removeRecursiveListener(FileChangeListener fileChangeListener, File file) {
        DeepListener deepListener = new DeepListener(fileChangeListener, file, null, null);
        DeepListener deepListener2 = (DeepListener)FileChangeImpl.removeFileChangeListenerImpl(DeepListener.LOG, deepListener, file);
        deepListener2.run();
    }
}

