/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.sw.SWRTTexture;
import com.sun.prism.sw.SWResourceFactory;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicInteger;

final class SWPresentable
extends SWRTTexture
implements Presentable {
    private final PresentableState pState;
    private Pixels pixels;
    private IntBuffer pixBuf;
    private final AtomicInteger uploadCount = new AtomicInteger(0);

    public SWPresentable(PresentableState presentableState, SWResourceFactory sWResourceFactory) {
        super(sWResourceFactory, presentableState.getWidth(), presentableState.getHeight());
        this.pState = presentableState;
    }

    @Override
    public boolean lockResources(PresentableState presentableState) {
        return this.getPhysicalWidth() != presentableState.getWidth() || this.getPhysicalHeight() != presentableState.getHeight();
    }

    @Override
    public boolean prepare(Rectangle rectangle) {
        if (!this.pState.isViewClosed()) {
            int n = this.getPhysicalWidth();
            int n2 = this.getPhysicalHeight();
            if (this.pixels == null || this.uploadCount.get() > 0) {
                this.pixBuf = IntBuffer.allocate(n * n2);
                this.pixels = Application.GetApplication().createPixels(n, n2, this.pixBuf);
            }
            IntBuffer intBuffer = this.getSurface().getDataIntBuffer();
            assert (intBuffer.hasArray());
            System.arraycopy(intBuffer.array(), 0, this.pixBuf.array(), 0, n * n2);
            return true;
        }
        return false;
    }

    @Override
    public boolean present() {
        this.uploadCount.incrementAndGet();
        this.pState.uploadPixels(this.pixels, this.uploadCount);
        return true;
    }

    @Override
    public float getPixelScaleFactor() {
        return 1.0f;
    }

    @Override
    public int getContentWidth() {
        return this.pState.getWidth();
    }

    @Override
    public int getContentHeight() {
        return this.pState.getHeight();
    }

    @Override
    public boolean isAntiAliasing() {
        return super.isAntiAliasing();
    }
}

