/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class TreeViewSkin<T>
extends VirtualContainerBase<TreeView<T>, TreeViewBehavior<T>, TreeCell<T>> {
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.scene.control.skin.TreeViewSkin.pannable"));
    private boolean needCellsRebuilt = true;
    private boolean needCellsReconfigured = false;
    private EventHandler<TreeItem.TreeModificationEvent<T>> rootListener = treeModificationEvent -> {
        if (treeModificationEvent.wasAdded() && treeModificationEvent.wasRemoved() && treeModificationEvent.getAddedSize() == treeModificationEvent.getRemovedSize()) {
            this.rowCountDirty = true;
            ((TreeView)this.getSkinnable()).requestLayout();
        } else if (treeModificationEvent.getEventType().equals(TreeItem.valueChangedEvent())) {
            this.needCellsRebuilt = true;
            ((TreeView)this.getSkinnable()).requestLayout();
        } else {
            for (EventType<? extends Event> eventType = treeModificationEvent.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                this.rowCountDirty = true;
                ((TreeView)this.getSkinnable()).requestLayout();
                break;
            }
        }
    };
    private WeakEventHandler<TreeItem.TreeModificationEvent<T>> weakRootListener;
    private WeakReference<TreeItem<T>> weakRoot;

    public TreeViewSkin(TreeView treeView) {
        super(treeView, new TreeViewBehavior(treeView));
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setCreateCell(virtualFlow -> this.createCell());
        this.flow.setFixedCellSize(treeView.getFixedCellSize());
        this.getChildren().add(this.flow);
        this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        EventHandler<MouseEvent> eventHandler = mouseEvent -> {
            if (treeView.getEditingItem() != null) {
                treeView.edit(null);
            }
            if (treeView.isFocusTraversable()) {
                treeView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        ((TreeViewBehavior)this.getBehavior()).setOnFocusPreviousRow(() -> this.onFocusPreviousCell());
        ((TreeViewBehavior)this.getBehavior()).setOnFocusNextRow(() -> this.onFocusNextCell());
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToLastCell(() -> this.onMoveToLastCell());
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageDown(bl -> this.onScrollPageDown((boolean)bl));
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageUp(bl -> this.onScrollPageUp((boolean)bl));
        ((TreeViewBehavior)this.getBehavior()).setOnSelectPreviousRow(() -> this.onSelectPreviousCell());
        ((TreeViewBehavior)this.getBehavior()).setOnSelectNextRow(() -> this.onSelectNextCell());
        this.registerChangeListener(treeView.rootProperty(), "ROOT");
        this.registerChangeListener(treeView.showRootProperty(), "SHOW_ROOT");
        this.registerChangeListener(treeView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(treeView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
        this.updateRowCount();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ROOT".equals(string)) {
            this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        } else if ("SHOW_ROOT".equals(string)) {
            if (!((TreeView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
            }
            this.updateRowCount();
        } else if ("CELL_FACTORY".equals(string)) {
            this.flow.recreateCells();
        } else if ("FIXED_CELL_SIZE".equals(string)) {
            this.flow.setFixedCellSize(((TreeView)this.getSkinnable()).getFixedCellSize());
        }
    }

    private TreeItem<T> getRoot() {
        return this.weakRoot == null ? null : (TreeItem)this.weakRoot.get();
    }

    private void setRoot(TreeItem<T> treeItem) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRoot = new WeakReference<TreeItem<TreeItem<T>>>(treeItem);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem.TreeModificationEvent<TreeItem.TreeModificationEvent<T>>>(this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.updateRowCount();
    }

    @Override
    public int getItemCount() {
        return ((TreeView)this.getSkinnable()).getExpandedItemCount();
    }

    @Override
    protected void updateRowCount() {
        int n = this.getItemCount();
        this.flow.setCellCount(n);
        this.needCellsRebuilt = true;
        ((TreeView)this.getSkinnable()).requestLayout();
    }

    @Override
    public TreeCell<T> createCell() {
        TreeCell<T> treeCell = ((TreeView)this.getSkinnable()).getCellFactory() != null ? ((TreeView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : this.createDefaultCellImpl();
        if (treeCell.getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((String[])new String[]{"arrow"});
            stackPane.getChildren().add(stackPane2);
            treeCell.setDisclosureNode(stackPane);
        }
        treeCell.updateTreeView((TreeView)this.getSkinnable());
        return treeCell;
    }

    private TreeCell<T> createDefaultCellImpl() {
        return new TreeCell<T>(){
            private HBox hbox;
            private WeakReference<TreeItem<T>> treeItemRef;
            private InvalidationListener treeItemGraphicListener = observable -> this.updateDisplay(this.getItem(), this.isEmpty());
            private InvalidationListener treeItemListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TreeItem treeItem;
                    TreeItem treeItem2;
                    TreeItem treeItem3 = treeItem2 = treeItemRef == null ? null : (TreeItem)treeItemRef.get();
                    if (treeItem2 != null) {
                        treeItem2.graphicProperty().removeListener(weakTreeItemGraphicListener);
                    }
                    if ((treeItem = this.getTreeItem()) != null) {
                        treeItem.graphicProperty().addListener(weakTreeItemGraphicListener);
                        treeItemRef = new WeakReference(treeItem);
                    }
                }
            };
            private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicListener);
            private WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(this.treeItemListener);
            {
                this.treeItemProperty().addListener(this.weakTreeItemListener);
                if (this.getTreeItem() != null) {
                    this.getTreeItem().graphicProperty().addListener(this.weakTreeItemGraphicListener);
                }
            }

            private void updateDisplay(T t, boolean bl) {
                if (t == null || bl) {
                    this.hbox = null;
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    TreeItem treeItem = this.getTreeItem();
                    if (treeItem != null && treeItem.getGraphic() != null) {
                        if (t instanceof Node) {
                            this.setText(null);
                            if (this.hbox == null) {
                                this.hbox = new HBox(3.0);
                            }
                            this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)t});
                            this.setGraphic(this.hbox);
                        } else {
                            this.hbox = null;
                            this.setText(t.toString());
                            this.setGraphic(treeItem.getGraphic());
                        }
                    } else {
                        this.hbox = null;
                        if (t instanceof Node) {
                            this.setText(null);
                            this.setGraphic((Node)t);
                        } else {
                            this.setText(t.toString());
                            this.setGraphic(null);
                        }
                    }
                }
            }

            @Override
            public void updateItem(T t, boolean bl) {
                super.updateItem(t, bl);
                this.updateDisplay(t, bl);
            }
        };
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return this.computePrefHeight(-1.0, d2, d3, d4, d5) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return 400.0;
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        super.layoutChildren(d, d2, d3, d4);
        if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsReconfigured = false;
        this.flow.resizeRelocate(d, d2, d3, d4);
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onSelectNextCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        this.flow.show(this.getItemCount());
        this.flow.setPosition(1.0);
    }

    public int onScrollPageDown(boolean bl) {
        int n;
        TreeCell treeCell = (TreeCell)this.flow.getLastVisibleCellWithinViewPort();
        if (treeCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = treeCell.getIndex();
        boolean bl2 = false;
        if (bl) {
            bl2 = treeCell.isFocused() || focusModel.isFocused(n2);
        } else {
            boolean bl3 = bl2 = treeCell.isSelected() || multipleSelectionModel.isSelected(n2);
        }
        if (bl2) {
            int n3 = n = bl && focusModel.getFocusedIndex() == n2 || !bl && multipleSelectionModel.getSelectedIndex() == n2 ? 1 : 0;
            if (n != 0) {
                this.flow.showAsFirst(treeCell);
                TreeCell treeCell2 = (TreeCell)this.flow.getLastVisibleCellWithinViewPort();
                treeCell = treeCell2 == null ? treeCell : treeCell2;
            }
        }
        n = treeCell.getIndex();
        this.flow.show(treeCell);
        return n;
    }

    public int onScrollPageUp(boolean bl) {
        int n;
        TreeCell treeCell = (TreeCell)this.flow.getFirstVisibleCellWithinViewPort();
        if (treeCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = treeCell.getIndex();
        boolean bl2 = false;
        if (bl) {
            bl2 = treeCell.isFocused() || focusModel.isFocused(n2);
        } else {
            boolean bl3 = bl2 = treeCell.isSelected() || multipleSelectionModel.isSelected(n2);
        }
        if (bl2) {
            int n3 = n = bl && focusModel.getFocusedIndex() == n2 || !bl && multipleSelectionModel.getSelectedIndex() == n2 ? 1 : 0;
            if (n != 0) {
                this.flow.showAsLast(treeCell);
                TreeCell treeCell2 = (TreeCell)this.flow.getFirstVisibleCellWithinViewPort();
                treeCell = treeCell2 == null ? treeCell : treeCell2;
            }
        }
        n = treeCell.getIndex();
        this.flow.show(treeCell);
        return n;
    }
}

