/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.ConversionDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import sun.net.www.ParseUtil;
import sun.plugin.liveconnect.JavaScriptProtectionDomain;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.liveconnect.ArgumentHelper;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.JavaClass;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.client.MessagePassingJSObject;
import sun.plugin2.main.client.MessagePassingOneWayJSObject;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaReplyMessage;
import sun.plugin2.message.JavaScriptReleaseObjectMessage;
import sun.plugin2.message.Pipe;
import sun.plugin2.util.SystemUtil;

public class LiveConnectSupport {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private static Pipe pipe;
    private static int jvmID;
    private static ReferenceQueue queue;
    private static volatile boolean shouldStop;
    private static Thread cleanupThread;
    private static Vector bsoRefs;
    private static Map exportedObjectMap;
    private static Map objectIDMap;
    private static int nextObjectID;
    private static Map appletInfoMap;

    private LiveConnectSupport() {
    }

    public static void initialize(Pipe pipe, int n) {
        LiveConnectSupport.pipe = pipe;
        jvmID = n;
        cleanupThread = new BrowserSideObjectCleanupThread();
        cleanupThread.start();
    }

    public static void shutdown() {
        shouldStop = true;
        cleanupThread.interrupt();
    }

    public static synchronized void appletStarted(int n, Plugin2Manager plugin2Manager) {
        appletInfoMap.put(new Integer(n), new PerAppletInfo(n, plugin2Manager));
    }

    public static synchronized void appletStopped(int n) {
        PerAppletInfo perAppletInfo = (PerAppletInfo)appletInfoMap.remove(new Integer(n));
        if (perAppletInfo != null) {
            perAppletInfo.stop();
        }
    }

    public static Object exportObject(Object object, int n, boolean bl, boolean bl2) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object) && !bl) {
            return object;
        }
        if (object instanceof MessagePassingJSObject) {
            return ((MessagePassingJSObject)object).getBrowserSideObject();
        }
        return LiveConnectSupport.exportRemoteObject(object, n, bl2);
    }

    public static Object importObject(Object object, int n) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object)) {
            return object;
        }
        if (object instanceof BrowserSideObject) {
            BrowserSideObject browserSideObject = (BrowserSideObject)object;
            MessagePassingJSObject messagePassingJSObject = new MessagePassingJSObject(browserSideObject, n, pipe);
            LiveConnectSupport.track(messagePassingJSObject);
            return messagePassingJSObject;
        }
        if (object instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)object);
        }
        throw new IllegalArgumentException("Unsupported argument type " + object.getClass().getName());
    }

    public static Object importOneWayJSObject(Object object, int n, Plugin2Manager plugin2Manager) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object)) {
            return object;
        }
        if (object instanceof BrowserSideObject) {
            BrowserSideObject browserSideObject = (BrowserSideObject)object;
            MessagePassingJSObject messagePassingJSObject = new MessagePassingJSObject(browserSideObject, n, pipe, plugin2Manager);
            MessagePassingOneWayJSObject messagePassingOneWayJSObject = new MessagePassingOneWayJSObject(messagePassingJSObject);
            LiveConnectSupport.track2(messagePassingOneWayJSObject);
            return messagePassingOneWayJSObject;
        }
        if (object instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)object);
        }
        throw new IllegalArgumentException("Unsupported argument type " + object.getClass().getName());
    }

    public static void doObjectOp(JavaObjectOpMessage javaObjectOpMessage) throws IOException {
        RemoteJavaObject remoteJavaObject = javaObjectOpMessage.getObject();
        PerAppletInfo perAppletInfo = LiveConnectSupport.getInfo(remoteJavaObject.getAppletID());
        if (perAppletInfo != null) {
            if (javaObjectOpMessage.getConversation() == null) {
                perAppletInfo.enqueue(javaObjectOpMessage);
            } else {
                perAppletInfo.doObjectOp(javaObjectOpMessage);
            }
        } else {
            pipe.send(new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, "Applet ID " + remoteJavaObject.getAppletID() + " is not registered in this JVM instance"));
        }
    }

    public static synchronized void releaseRemoteObject(RemoteJavaObject remoteJavaObject) {
        Integer n = new Integer(remoteJavaObject.getObjectID());
        Object v = objectIDMap.remove(n);
        if (v != null) {
            exportedObjectMap.remove(v);
        }
    }

    private static void track(MessagePassingJSObject messagePassingJSObject) {
        bsoRefs.add(new BrowserSideObjectReference(messagePassingJSObject, queue, messagePassingJSObject.getBrowserSideObject(), messagePassingJSObject.getAppletID()));
    }

    private static void track2(MessagePassingOneWayJSObject messagePassingOneWayJSObject) {
        bsoRefs.add(new BrowserSideObjectReference(messagePassingOneWayJSObject, queue, messagePassingOneWayJSObject.getBrowserSideObject(), messagePassingOneWayJSObject.getAppletID()));
    }

    private static synchronized RemoteJavaObject exportRemoteObject(Object object, int n, boolean bl) {
        RemoteJavaObject remoteJavaObject = (RemoteJavaObject)exportedObjectMap.get(object);
        if (remoteJavaObject != null && !LiveConnectSupport.isAppletRunning(remoteJavaObject.getAppletID())) {
            LiveConnectSupport.releaseRemoteObject(remoteJavaObject);
            remoteJavaObject = null;
        }
        if (remoteJavaObject == null) {
            int n2 = ++nextObjectID;
            remoteJavaObject = new RemoteJavaObject(jvmID, n, n2, bl);
            exportedObjectMap.put(object, remoteJavaObject);
            objectIDMap.put(new Integer(n2), object);
        }
        return remoteJavaObject;
    }

    private static synchronized Object importRemoteObject(RemoteJavaObject remoteJavaObject) {
        return objectIDMap.get(new Integer(remoteJavaObject.getObjectID()));
    }

    private static synchronized void releaseRemoteObjects(int n) {
        ArrayList<RemoteJavaObject> arrayList = new ArrayList<RemoteJavaObject>();
        for (RemoteJavaObject remoteJavaObject : exportedObjectMap.values()) {
            if (remoteJavaObject.getAppletID() != n) continue;
            arrayList.add(remoteJavaObject);
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            LiveConnectSupport.releaseRemoteObject((RemoteJavaObject)iterator.next());
        }
    }

    private static synchronized PerAppletInfo getInfo(int n) {
        return (PerAppletInfo)appletInfoMap.get(new Integer(n));
    }

    private static boolean isAppletRunning(int n) {
        return LiveConnectSupport.getInfo(n) != null;
    }

    public static synchronized Bridge getBridge(Object object) {
        for (PerAppletInfo perAppletInfo : appletInfoMap.values()) {
            if (!perAppletInfo.hostsApplet(object)) continue;
            return perAppletInfo.getBridge();
        }
        return null;
    }

    private static AccessControlContext createContext(URL uRL) {
        try {
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{LiveConnectSupport.getJSProtectionDomain(uRL)};
            return new AccessControlContext(protectionDomainArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ProtectionDomain getJSProtectionDomain(URL uRL) throws MalformedURLException {
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        Plugin2ClassLoader.addDefaultPermissions(permissionCollection);
        if (uRL != null) {
            Permission permission;
            String string = null;
            try {
                permission = uRL.openConnection().getPermission();
            }
            catch (IOException iOException) {
                permission = null;
            }
            if (permission instanceof FilePermission) {
                string = permission.getName();
            } else if (permission == null && uRL.getProtocol().equals("file")) {
                string = uRL.getFile().replace('/', File.separatorChar);
                string = ParseUtil.decode(string);
            } else if (permission instanceof SocketPermission) {
                String string2 = uRL.getHost();
                URL uRL2 = uRL;
                if (string2 == null || string2.equals("")) {
                    try {
                        uRL2 = new URL(uRL.getFile());
                        string2 = uRL2.getHost();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (string2 != null && !string2.equals("")) {
                    SandboxSecurity.addConnectPermission((PermissionCollection)permissionCollection, (URL)uRL2);
                    permissionCollection.add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)uRL)));
                    Trace.println((String)("Grant liveconnect connect perm for " + uRL + " : " + permissionCollection), (TraceLevel)TraceLevel.SECURITY);
                }
            }
            if (string != null) {
                if (string.endsWith(File.separator)) {
                    string = string + "-";
                } else {
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n != -1) {
                        string = string.substring(0, n + 1) + "-";
                    }
                }
                permissionCollection.add(new FilePermission(string, "read"));
            }
            if ("chrome".equals(uRL.getProtocol())) {
                CeilingPolicy.addTrustedPermissions((PermissionCollection)permissionCollection);
            }
        }
        return new JavaScriptProtectionDomain(permissionCollection);
    }

    private static String getOpName(int n) {
        switch (n) {
            case 1: {
                return "CALL_METHOD";
            }
            case 2: {
                return "GET_FIELD";
            }
            case 3: {
                return "SET_FIELD";
            }
            case 4: {
                return "HAS_FIELD";
            }
            case 5: {
                return "HAS_METHOD";
            }
            case 6: {
                return "HAS_FIELD_OR_METHOD";
            }
        }
        throw new IllegalArgumentException("Invalid operation kind " + n);
    }

    static {
        queue = new ReferenceQueue();
        bsoRefs = new Vector();
        exportedObjectMap = new IdentityHashMap();
        objectIDMap = new HashMap();
        appletInfoMap = new HashMap();
    }

    private static class BridgeImpl
    implements Bridge {
        private volatile PerAppletInfo info;

        private BridgeImpl(PerAppletInfo perAppletInfo) {
            this.info = perAppletInfo;
        }

        public void register(InvocationDelegate invocationDelegate) {
            this.getInfo().register(invocationDelegate);
        }

        public void unregister(InvocationDelegate invocationDelegate) {
            this.getInfo().unregister(invocationDelegate);
        }

        public void register(ConversionDelegate conversionDelegate) {
            this.getInfo().register(conversionDelegate);
        }

        public void unregister(ConversionDelegate conversionDelegate) {
            this.getInfo().unregister(conversionDelegate);
        }

        public int conversionCost(Object object, Object object2) {
            return this.getInfo().conversionCost(object, object2);
        }

        public Object convert(Object object, Object object2) throws Exception {
            return this.getInfo().convert(object, object2);
        }

        public void stop() {
            this.info = null;
        }

        private PerAppletInfo getInfo() {
            PerAppletInfo perAppletInfo = this.info;
            if (perAppletInfo == null) {
                throw new IllegalStateException("Applet has already terminated");
            }
            return perAppletInfo;
        }
    }

    private static class BrowserSideObjectCleanupThread
    extends Thread {
        public BrowserSideObjectCleanupThread() {
            super("Browser Side Object Cleanup Thread");
        }

        public void run() {
            while (!shouldStop) {
                try {
                    if (DEBUG) {
                        Trace.println((String)"Waiting to GC browser side object ...", (TraceLevel)TraceLevel.LIVECONNECT);
                    }
                    BrowserSideObjectReference browserSideObjectReference = (BrowserSideObjectReference)queue.remove();
                    if (DEBUG) {
                        Trace.println((String)("About to GC browser side object " + browserSideObjectReference.getObject().getNativeObjectReference()), (TraceLevel)TraceLevel.LIVECONNECT);
                    }
                    bsoRefs.remove(browserSideObjectReference);
                    pipe.send(new JavaScriptReleaseObjectMessage(null, browserSideObjectReference.getObject(), browserSideObjectReference.getAppletId()));
                }
                catch (IOException iOException) {
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static class BrowserSideObjectReference
    extends PhantomReference {
        private final BrowserSideObject bso;
        private final int appletId;

        public BrowserSideObjectReference(Object object, ReferenceQueue referenceQueue, BrowserSideObject browserSideObject, int n) {
            super(object, referenceQueue);
            this.bso = browserSideObject;
            this.appletId = n;
        }

        public BrowserSideObject getObject() {
            return this.bso;
        }

        public int getAppletId() {
            return this.appletId;
        }
    }

    private static class PerAppletInfo {
        private int appletID;
        private Plugin2Manager manager;
        private LiveConnectWorker worker;
        private BridgeImpl bridge;
        private boolean fetchedDocumentBase;
        private URL documentBase;
        private AccessControlContext context;
        private List invocationDelegates = Collections.synchronizedList(new ArrayList());
        private List conversionDelegates = Collections.synchronizedList(new ArrayList());
        private Map classes = new HashMap();
        private Set notJavaClasses = new HashSet();
        DeploymentRuleSet docbaseDRS = null;
        DeploymentRuleSet mainAppletDRS = null;

        public PerAppletInfo(int n, Plugin2Manager plugin2Manager) {
            this.appletID = n;
            this.manager = plugin2Manager;
            this.bridge = new BridgeImpl(this);
            this.register(new DefaultInvocationDelegate());
            this.register(new DefaultConversionDelegate());
            this.worker = new LiveConnectWorker();
            plugin2Manager.startWorkerThread("Applet " + n + " LiveConnect Worker Thread", this.worker);
        }

        public boolean hostsApplet(Object object) {
            return this.manager != null && this.manager.getApplet2Adapter().getLiveConnectObject() == object;
        }

        public Bridge getBridge() {
            return this.bridge;
        }

        public void register(InvocationDelegate invocationDelegate) {
            this.invocationDelegates.add(0, invocationDelegate);
        }

        public void unregister(InvocationDelegate invocationDelegate) {
            this.invocationDelegates.remove(invocationDelegate);
        }

        public void register(ConversionDelegate conversionDelegate) {
            this.conversionDelegates.add(0, conversionDelegate);
        }

        public void unregister(ConversionDelegate conversionDelegate) {
            this.conversionDelegates.remove(conversionDelegate);
        }

        public int conversionCost(final Object object, final Object object2) {
            final int[] nArray = new int[1];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (ConversionDelegate conversionDelegate : PerAppletInfo.this.conversionDelegates) {
                        int n = conversionDelegate.conversionCost(object, object2);
                        if (n < 0) continue;
                        nArray[0] = n;
                        return null;
                    }
                    nArray[0] = -1;
                    return null;
                }
            }, this.getContext());
            return nArray[0];
        }

        public Object convert(final Object object, final Object object2) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object[] objectArray = new Object[1];
                    for (ConversionDelegate conversionDelegate : PerAppletInfo.this.conversionDelegates) {
                        if (!conversionDelegate.convert(object, object2, objectArray)) continue;
                        return objectArray[0];
                    }
                    throw PerAppletInfo.inconvertible(object, object2);
                }
            }, this.getContext());
        }

        public void enqueue(JavaObjectOpMessage javaObjectOpMessage) {
            this.worker.enqueue(javaObjectOpMessage);
        }

        public void stop() {
            this.bridge.stop();
            this.worker.stop();
            LiveConnectSupport.releaseRemoteObjects(this.appletID);
        }

        public void doObjectOp(final JavaObjectOpMessage javaObjectOpMessage) throws IOException {
            JavaReplyMessage javaReplyMessage = null;
            if (DEBUG) {
                System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " \"" + javaObjectOpMessage.getMemberName() + "\"");
            }
            if (!this.isLiveconnectCallAllowed(javaObjectOpMessage)) {
                RemoteJavaObject remoteJavaObject = javaObjectOpMessage.getObject();
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, "Liveconnect call for Applet ID " + remoteJavaObject.getAppletID() + " is not allowed in this JVM instance");
                pipe.send(javaReplyMessage);
                return;
            }
            try {
                this.waitForAppletStartOrError();
                if (this.manager.hasErrorOccurred()) {
                    if (this.manager.getErrorMessage() != null) {
                        throw new RuntimeException(this.manager.getErrorMessage());
                    }
                    if (this.manager.getErrorException() != null) {
                        throw (IOException)new IOException().initCause(this.manager.getErrorException());
                    }
                }
                final Object object = LiveConnectSupport.importObject(javaObjectOpMessage.getObject(), this.appletID);
                final Object[] objectArray = javaObjectOpMessage.getArguments();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = LiveConnectSupport.importObject(objectArray[i], this.appletID);
                    }
                }
                Result result = null;
                final boolean bl = javaObjectOpMessage.getObject().isApplet();
                boolean bl2 = false;
                switch (javaObjectOpMessage.getOperationKind()) {
                    case 1: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                Result[] resultArray = new Result[1];
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).invoke(javaObjectOpMessage.getMemberName(), object, objectArray, false, bl, resultArray)) {
                                }
                                return resultArray[0];
                            }
                        }, this.getContext());
                        if (result.value() != Void.TYPE) break;
                        bl2 = true;
                        result = null;
                        break;
                    }
                    case 2: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                Result[] resultArray = new Result[1];
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).getField(javaObjectOpMessage.getMemberName(), object, false, bl, resultArray)) {
                                }
                                return resultArray[0];
                            }
                        }, this.getContext());
                        break;
                    }
                    case 3: {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).setField(javaObjectOpMessage.getMemberName(), object, objectArray[0], false, bl)) {
                                }
                                return null;
                            }
                        }, this.getContext());
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                boolean[] blArray;
                                block2: {
                                    InvocationDelegate invocationDelegate;
                                    Object object2;
                                    blArray = new boolean[1];
                                    boolean bl2 = false;
                                    if (bl && (((String)(object2 = javaObjectOpMessage.getMemberName().toLowerCase())).equals("width") || ((String)object2).equals("height"))) {
                                        blArray[0] = false;
                                        bl2 = true;
                                    }
                                    if (bl2) break block2;
                                    object2 = PerAppletInfo.this.invocationDelegates.iterator();
                                    while (object2.hasNext() && !(invocationDelegate = (InvocationDelegate)object2.next()).hasField(javaObjectOpMessage.getMemberName(), object, false, bl, blArray)) {
                                    }
                                }
                                return blArray[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 5: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                boolean[] blArray = new boolean[1];
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).hasMethod(javaObjectOpMessage.getMemberName(), object, false, bl, blArray)) {
                                }
                                return blArray[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 6: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                boolean[] blArray = new boolean[1];
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).hasFieldOrMethod(javaObjectOpMessage.getMemberName(), object, false, bl, blArray)) {
                                }
                                return blArray[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error: unknown Java object operation " + javaObjectOpMessage.getOperationKind());
                    }
                }
                Object object2 = null;
                boolean bl3 = false;
                if (result != null) {
                    object2 = result.value();
                    bl3 = result.skipUnboxing();
                }
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), LiveConnectSupport.exportObject(object2, this.appletID, bl3, false), bl2, null);
                if (DEBUG) {
                    System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " \"" + javaObjectOpMessage.getMemberName() + "\": returning result " + object2);
                }
            }
            catch (Throwable throwable) {
                String string = "Throwable";
                if (throwable instanceof PrivilegedActionException) {
                    string = "PrivilegedActionException";
                }
                if (throwable instanceof InvocationTargetException) {
                    string = "InvocationTargetException";
                }
                if (DEBUG) {
                    System.out.println("Exception occurred during " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " " + javaObjectOpMessage.getMemberName() + " : " + string);
                }
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, string);
            }
            pipe.send(javaReplyMessage);
        }

        private DeploymentRuleSet getDeploymentRuleSet() {
            final Plugin2Manager plugin2Manager = this.manager;
            if (plugin2Manager != null) {
                try {
                    return (DeploymentRuleSet)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (PerAppletInfo.this.mainAppletDRS == null) {
                                PerAppletInfo.this.mainAppletDRS = plugin2Manager.getMainDeploymentRuleSet();
                            }
                            if (PerAppletInfo.this.docbaseDRS == null) {
                                AppRef appRef = new AppRef(AppRef.Type.DOCBASE, null, PerAppletInfo.this.getDocumentBase(), null, (URL)null);
                                PerAppletInfo.this.docbaseDRS = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, new CodeRef(null, null)));
                            }
                            if (PerAppletInfo.this.mainAppletDRS.isRuleRun()) {
                                if (PerAppletInfo.this.docbaseDRS.isLiveConnectAllowedUnchecked()) {
                                    return PerAppletInfo.this.docbaseDRS;
                                }
                                return new BlockRule(null, null);
                            }
                            return PerAppletInfo.this.docbaseDRS;
                        }
                    });
                }
                catch (Exception exception) {
                    Trace.ignored((Throwable)exception);
                    return new BlockRule(null, exception);
                }
            }
            return DeploymentRuleSet.getDefault();
        }

        private boolean isLiveconnectCallAllowed(JavaObjectOpMessage javaObjectOpMessage) {
            DeploymentRuleSet deploymentRuleSet = this.getDeploymentRuleSet();
            if (deploymentRuleSet.isRuleBlock()) {
                Trace.println((String)"LiveConnect (JavaScript) blocked due to Deployment Rule Set.", (TraceLevel)TraceLevel.SECURITY);
                return false;
            }
            boolean bl = false;
            Plugin2Manager plugin2Manager = this.manager;
            if (plugin2Manager != null) {
                bl = true;
                int n = javaObjectOpMessage.getOperationKind();
                if (!javaObjectOpMessage.getObject().isApplet() || n == 1 || n == 2 || n == 3) {
                    try {
                        plugin2Manager.checkUntrustedAccess(deploymentRuleSet);
                    }
                    catch (SecurityException securityException) {
                        bl = false;
                    }
                }
            }
            return bl;
        }

        private AccessControlContext getContext() {
            if (this.context == null) {
                this.context = LiveConnectSupport.createContext(this.getDocumentBase());
            }
            return this.context;
        }

        private URL getDocumentBase() {
            if (!this.fetchedDocumentBase) {
                this.documentBase = this.manager.getDocumentBase();
                this.fetchedDocumentBase = true;
            }
            return this.documentBase;
        }

        private InvocationDelegate getDelegate(Object object, boolean bl) {
            if (bl) {
                return this.getJavaClass((Class)object);
            }
            return this.getJavaClass(object.getClass());
        }

        private synchronized JavaClass getJavaClass(Class clazz) {
            JavaClass javaClass = (JavaClass)this.classes.get(clazz);
            if (javaClass == null) {
                javaClass = new JavaClass(clazz, this.getBridge());
                this.classes.put(clazz, javaClass);
            }
            return javaClass;
        }

        private void waitForAppletStartOrError() throws IOException {
            if (this.manager.isForDummyApplet()) {
                return;
            }
            if (this.manager.getApplet2Adapter().isInstantiated() || this.manager.hasErrorOccurred()) {
                this.manager.waitUntilAppletStartDone();
                return;
            }
            throw new IOException("LiveConnect operation without existing applet");
        }

        private static IllegalArgumentException inconvertible(Object object, Object object2) {
            return new IllegalArgumentException("Object " + object + " can not be converted to " + object2);
        }

        private static IllegalArgumentException inconvertible(Class clazz, Class clazz2) {
            return PerAppletInfo.inconvertible(clazz, clazz2, null);
        }

        private static IllegalArgumentException inconvertible(Class clazz, Class clazz2, Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Class " + clazz.getName() + " can not be converted to " + clazz2.getName());
            if (exception != null) {
                illegalArgumentException.initCause(exception);
            }
            return illegalArgumentException;
        }

        class DefaultConversionDelegate
        implements ConversionDelegate {
            private Class jsObjectClass = JSObject.class;
            private static final int TOSTRING_CONVERSION_PENALTY = 50;
            private static final int JSOBJECT_CONVERSION_PENALTY = 2500;

            DefaultConversionDelegate() {
            }

            public int conversionCost(Object object, Object object2) {
                if (!(object2 instanceof Class)) {
                    return -1;
                }
                Class clazz = (Class)object2;
                if (object == null) {
                    if (clazz.isPrimitive()) {
                        return -1;
                    }
                    return 0;
                }
                Class<?> clazz2 = object.getClass();
                if (clazz2 == clazz || clazz == this.jsObjectClass && clazz.isAssignableFrom(clazz2)) {
                    return 0;
                }
                if (clazz.isAssignableFrom(clazz2)) {
                    return this.conversionDistance(clazz2, clazz);
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) && this.canConvert((JSObject)object, clazz)) {
                    return 2500;
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) || this.jsObjectClass.isAssignableFrom(clazz)) {
                    return -1;
                }
                if (clazz == String.class) {
                    return 50;
                }
                if (clazz.isPrimitive()) {
                    clazz = this.getBoxingClass(clazz);
                }
                if (Number.class.isAssignableFrom(clazz) || clazz == Character.class || clazz == Boolean.class) {
                    if (clazz == clazz2) {
                        return 0;
                    }
                    if (clazz2 == String.class || Number.class.isAssignableFrom(clazz2) || clazz2 == Character.class || clazz2 == Boolean.class) {
                        return 1;
                    }
                }
                return -1;
            }

            public boolean convert(Object object, Object object2, Object[] objectArray) throws Exception {
                if (object == null) {
                    return true;
                }
                if (!(object2 instanceof Class)) {
                    throw PerAppletInfo.inconvertible(object, object2);
                }
                Class clazz = (Class)object2;
                Class<?> clazz2 = object.getClass();
                if (clazz.isAssignableFrom(clazz2)) {
                    objectArray[0] = object;
                    return true;
                }
                if (clazz == String.class) {
                    if (object instanceof Number) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance();
                        try {
                            objectArray[0] = numberFormat.parse(object.toString()).toString();
                            return true;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    objectArray[0] = object.toString();
                    return true;
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) && clazz.isArray()) {
                    try {
                        JSObject jSObject = (JSObject)object;
                        Class<?> clazz3 = clazz.getComponentType();
                        int n = ((Number)jSObject.getMember("length")).intValue();
                        Object object3 = Array.newInstance(clazz3, n);
                        Object[] objectArray2 = new Object[1];
                        for (int i = 0; i < n; ++i) {
                            Object object4 = null;
                            try {
                                object4 = jSObject.getSlot(i);
                            }
                            catch (JSException jSException) {
                                // empty catch block
                            }
                            if (object4 == null) continue;
                            this.convert(object4, clazz3, objectArray2);
                            Array.set(object3, i, objectArray2[0]);
                        }
                        objectArray[0] = object3;
                        return true;
                    }
                    catch (Exception exception) {
                        throw PerAppletInfo.inconvertible(clazz2, clazz, exception);
                    }
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) || this.jsObjectClass.isAssignableFrom(clazz)) {
                    throw PerAppletInfo.inconvertible(clazz2, clazz);
                }
                if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz == Character.class || clazz == Boolean.class) {
                    boolean bl = object instanceof Number;
                    if (!(bl || object instanceof String || object instanceof Character || object instanceof Boolean)) {
                        throw PerAppletInfo.inconvertible(clazz2, clazz);
                    }
                    if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                        if (clazz2 == Boolean.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        if (bl) {
                            double d = ((Number)object).doubleValue();
                            objectArray[0] = Double.isNaN(d) || d == 0.0 ? Boolean.FALSE : Boolean.TRUE;
                            return true;
                        }
                        objectArray[0] = ((String)object).length() == 0 ? Boolean.FALSE : Boolean.TRUE;
                        return true;
                    }
                    if (clazz == Byte.TYPE || clazz == Byte.class) {
                        if (clazz2 == Byte.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Byte(((Number)object).byteValue()) : Byte.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Short.TYPE || clazz == Short.class) {
                        if (clazz2 == Short.class || clazz2 == Byte.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Short(((Number)object).shortValue()) : Short.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Integer.TYPE || clazz == Integer.class) {
                        if (clazz2 == Integer.class || clazz2 == Character.class || clazz2 == Short.class || clazz2 == Byte.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Integer(((Number)object).intValue()) : Integer.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Long.TYPE || clazz == Long.class) {
                        if (clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Character.class || clazz2 == Short.class || clazz2 == Byte.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Long(((Number)object).longValue()) : Long.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        if (clazz2 == Float.class || clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Character.class || clazz2 == Short.class || clazz2 == Byte.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Float(((Number)object).floatValue()) : Float.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        if (clazz2 == Double.class || clazz2 == Float.class || clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Character.class || clazz2 == Short.class || clazz2 == Byte.class) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Double(((Number)object).doubleValue()) : Double.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Character.TYPE || clazz == Character.class) {
                        objectArray[0] = bl ? new Character((char)((Number)object).shortValue()) : new Character((char)Short.decode((String)object).shortValue());
                        return true;
                    }
                }
                throw PerAppletInfo.inconvertible(clazz2, clazz);
            }

            private boolean canConvert(JSObject jSObject, Class clazz) {
                if (clazz == String.class) {
                    return true;
                }
                if (clazz.isArray()) {
                    try {
                        jSObject.getMember("length");
                        return true;
                    }
                    catch (JSException jSException) {
                        // empty catch block
                    }
                }
                return false;
            }

            private int conversionDistance(Class clazz, Class clazz2) {
                if (clazz2.isInterface() || clazz2.isArray()) {
                    return 1;
                }
                int n = 0;
                while (clazz != null && clazz != clazz2) {
                    ++n;
                    clazz = clazz.getSuperclass();
                }
                if (clazz != clazz2) {
                    return 1;
                }
                return n;
            }

            private Class getBoxingClass(Class clazz) {
                if (clazz == Boolean.TYPE) {
                    return Boolean.class;
                }
                if (clazz == Byte.TYPE) {
                    return Byte.class;
                }
                if (clazz == Short.TYPE) {
                    return Short.class;
                }
                if (clazz == Character.TYPE) {
                    return Character.class;
                }
                if (clazz == Integer.TYPE) {
                    return Integer.class;
                }
                if (clazz == Long.TYPE) {
                    return Long.class;
                }
                if (clazz == Float.TYPE) {
                    return Float.class;
                }
                if (clazz == Double.TYPE) {
                    return Double.class;
                }
                throw new IllegalArgumentException("Not a primitive type class");
            }
        }

        class DefaultInvocationDelegate
        implements InvocationDelegate {
            DefaultInvocationDelegate() {
            }

            public boolean invoke(String string, Object object, Object[] objectArray, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.invoke(string, bl ? null : object, objectArray, false, bl2, resultArray);
            }

            public boolean getField(String string, Object object, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.getField(string, bl ? null : object, false, bl2, resultArray);
            }

            public boolean setField(String string, Object object, Object object2, boolean bl, boolean bl2) throws Exception {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.setField(string, bl ? null : object, object2, false, bl2);
            }

            public boolean hasField(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.hasField(string, bl ? null : object, false, bl2, blArray);
            }

            public boolean hasMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.hasMethod(string, bl ? null : object, false, bl2, blArray);
            }

            public boolean hasFieldOrMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.hasFieldOrMethod(string, bl ? null : object, false, bl2, blArray);
            }

            public Object findClass(String string) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(string, false, classLoader);
                }
                catch (ClassFormatError classFormatError) {
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
            }

            public Object newInstance(Object object, Object[] objectArray) throws Exception {
                JavaClass javaClass = PerAppletInfo.this.getJavaClass((Class)object);
                return javaClass.newInstance(null, objectArray);
            }
        }

        private class LiveConnectWorker
        implements Runnable {
            private volatile boolean shouldStop;
            private Object lock = new Object();
            private LinkedList workQueue = new LinkedList();

            private LiveConnectWorker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enqueue(JavaObjectOpMessage javaObjectOpMessage) {
                Object object = this.lock;
                synchronized (object) {
                    this.workQueue.add(javaObjectOpMessage);
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop() {
                this.shouldStop = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(PerAppletInfo.this.manager);
                try {
                    while (!this.shouldStop) {
                        Object object = this.lock;
                        synchronized (object) {
                            while (!this.shouldStop && this.workQueue.isEmpty()) {
                                try {
                                    this.lock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                        while (!this.shouldStop && !this.workQueue.isEmpty()) {
                            object = null;
                            Object object2 = this.lock;
                            synchronized (object2) {
                                object = (JavaObjectOpMessage)this.workQueue.removeFirst();
                            }
                            PerAppletInfo.this.doObjectOp((JavaObjectOpMessage)object);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

