/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.memory;

import com.sun.tools.visualvm.application.jvm.HeapHistogram;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemoryView;
import com.sun.tools.visualvm.sampler.memory.ThreadsMemory;
import com.sun.tools.visualvm.sampler.memory.ThreadsMemoryInfo;
import com.sun.tools.visualvm.sampler.memory.ThreadsMemoryView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.MemoryMXBean;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.openide.util.NbBundle;

public abstract class MemorySamplerSupport
extends AbstractSamplerSupport {
    private final Jvm jvm;
    private final MemoryMXBean memoryBean;
    private final ThreadsMemory threadsMemory;
    private final HeapDumper heapDumper;
    private final SnapshotDumper snapshotDumper;
    private Timer processor;
    private javax.swing.Timer heapTimer;
    private AbstractSamplerSupport.Refresher heapRefresher;
    private MemoryView heapView;
    private javax.swing.Timer permgenTimer;
    private AbstractSamplerSupport.Refresher permgenRefresher;
    private MemoryView permgenView;
    private javax.swing.Timer threadAllocTimer;
    private AbstractSamplerSupport.Refresher threadAllocRefresher;
    private ThreadsMemoryView threadAllocView;
    private DataViewComponent.DetailsView[] detailsViews;

    public MemorySamplerSupport(Jvm jvm, ThreadsMemory mem, MemoryMXBean memoryBean, SnapshotDumper snapshotDumper, HeapDumper heapDumper) {
        this.jvm = jvm;
        this.threadsMemory = mem;
        this.memoryBean = memoryBean;
        this.heapDumper = heapDumper;
        this.snapshotDumper = snapshotDumper;
    }

    @Override
    public DataViewComponent.DetailsView[] getDetailsView() {
        if (this.detailsViews == null) {
            this.initialize();
            this.detailsViews = this.createViews();
        }
        this.heapView.initSession();
        this.permgenView.initSession();
        return (DataViewComponent.DetailsView[])this.detailsViews.clone();
    }

    @Override
    public boolean startSampling(ProfilingSettings settings, int samplingRate, int refreshRate) {
        this.heapRefresher.setRefreshRate(samplingRate);
        this.permgenRefresher.setRefreshRate(samplingRate);
        if (this.threadAllocRefresher != null) {
            this.threadAllocRefresher.setRefreshRate(samplingRate);
        }
        if (this.heapView != null && this.permgenView != null) {
            this.doRefreshImpl(this.heapTimer, this.heapView, this.permgenView);
        }
        return true;
    }

    @Override
    public synchronized void stopSampling() {
        this.heapTimer.stop();
        this.permgenTimer.stop();
        if (this.threadAllocTimer != null) {
            this.threadAllocTimer.stop();
        }
        if (this.heapView != null && this.permgenView != null) {
            this.doRefreshImplImpl(this.snapshotDumper.lastHistogram, this.heapView, this.permgenView);
        }
    }

    @Override
    public synchronized void terminate() {
        if (this.heapView != null) {
            this.heapView.terminate();
        }
        if (this.permgenView != null) {
            this.permgenView.terminate();
        }
    }

    private void initialize() {
        int defaultRefresh = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        this.processor = this.getTimer();
        this.heapTimer = new javax.swing.Timer(defaultRefresh, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySamplerSupport.this.heapRefresher.refresh();
            }
        });
        this.heapRefresher = new AbstractSamplerSupport.Refresher(){

            @Override
            public final boolean checkRefresh() {
                if (!MemorySamplerSupport.this.heapTimer.isRunning()) {
                    return false;
                }
                return MemorySamplerSupport.this.heapView.isShowing() || MemorySamplerSupport.this.permgenTimer.getDelay() == MemorySamplerSupport.this.heapTimer.getDelay() && MemorySamplerSupport.this.permgenView.isShowing();
            }

            @Override
            public final void doRefresh() {
                if (MemorySamplerSupport.this.heapView.isShowing()) {
                    MemorySamplerSupport.this.doRefreshImpl(MemorySamplerSupport.this.heapTimer, new MemoryView[]{MemorySamplerSupport.this.heapView});
                } else if (MemorySamplerSupport.this.permgenTimer.getDelay() == MemorySamplerSupport.this.heapTimer.getDelay() && MemorySamplerSupport.this.permgenView.isShowing()) {
                    MemorySamplerSupport.this.doRefreshImpl(MemorySamplerSupport.this.heapTimer, new MemoryView[]{MemorySamplerSupport.this.permgenView});
                }
            }

            @Override
            public final void setRefreshRate(int refreshRate) {
                MemorySamplerSupport.this.heapTimer.setDelay(refreshRate);
                MemorySamplerSupport.this.heapTimer.setInitialDelay(refreshRate);
                MemorySamplerSupport.this.heapTimer.restart();
            }

            @Override
            public final int getRefreshRate() {
                return MemorySamplerSupport.this.heapTimer.getDelay();
            }
        };
        this.permgenTimer = new javax.swing.Timer(defaultRefresh, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySamplerSupport.this.permgenRefresher.refresh();
            }
        });
        this.permgenRefresher = new AbstractSamplerSupport.Refresher(){

            @Override
            public final boolean checkRefresh() {
                if (!MemorySamplerSupport.this.permgenTimer.isRunning()) {
                    return false;
                }
                if (MemorySamplerSupport.this.permgenTimer.getDelay() == MemorySamplerSupport.this.heapTimer.getDelay()) {
                    return false;
                }
                return MemorySamplerSupport.this.permgenView.isShowing();
            }

            @Override
            public final void doRefresh() {
                MemorySamplerSupport.this.doRefreshImpl(MemorySamplerSupport.this.permgenTimer, new MemoryView[]{MemorySamplerSupport.this.permgenView});
            }

            @Override
            public final void setRefreshRate(int refreshRate) {
                MemorySamplerSupport.this.permgenTimer.setDelay(refreshRate);
                MemorySamplerSupport.this.permgenTimer.setInitialDelay(refreshRate);
                MemorySamplerSupport.this.permgenTimer.restart();
            }

            @Override
            public final int getRefreshRate() {
                return MemorySamplerSupport.this.permgenTimer.getDelay();
            }
        };
        if (this.threadsMemory != null) {
            this.threadAllocTimer = new javax.swing.Timer(defaultRefresh, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MemorySamplerSupport.this.threadAllocRefresher.refresh();
                }
            });
            this.threadAllocRefresher = new AbstractSamplerSupport.Refresher(){

                @Override
                public final boolean checkRefresh() {
                    if (!MemorySamplerSupport.this.threadAllocTimer.isRunning()) {
                        return false;
                    }
                    return MemorySamplerSupport.this.threadAllocView.isShowing();
                }

                @Override
                public final void doRefresh() {
                    MemorySamplerSupport.this.doRefreshImpl(MemorySamplerSupport.this.threadAllocTimer, MemorySamplerSupport.this.threadAllocView);
                }

                @Override
                public final void setRefreshRate(int refreshRate) {
                    MemorySamplerSupport.this.threadAllocTimer.setDelay(refreshRate);
                    MemorySamplerSupport.this.threadAllocTimer.setInitialDelay(refreshRate);
                    MemorySamplerSupport.this.threadAllocTimer.restart();
                }

                @Override
                public final int getRefreshRate() {
                    return MemorySamplerSupport.this.threadAllocTimer.getDelay();
                }
            };
        }
    }

    private DataViewComponent.DetailsView[] createViews() {
        DataViewComponent.DetailsView[] details = new DataViewComponent.DetailsView[this.threadAllocRefresher != null ? 3 : 2];
        this.heapView = new MemoryView(this.heapRefresher, 1, this.memoryBean, this.snapshotDumper, this.heapDumper);
        details[0] = new DataViewComponent.DetailsView(NbBundle.getMessage(MemorySamplerSupport.class, (String)"LBL_Heap_histogram"), null, 10, (JComponent)this.heapView, null);
        this.permgenView = new MemoryView(this.permgenRefresher, 2, this.memoryBean, null, this.heapDumper);
        details[1] = new DataViewComponent.DetailsView(NbBundle.getMessage(MemorySamplerSupport.class, (String)"LBL_PermGen_histogram"), null, 20, (JComponent)this.permgenView, null);
        if (this.threadAllocRefresher != null) {
            this.threadAllocView = new ThreadsMemoryView(this.threadAllocRefresher, this.memoryBean, this.heapDumper);
            details[2] = new DataViewComponent.DetailsView(NbBundle.getMessage(MemorySamplerSupport.class, (String)"LBL_ThreadAlloc"), null, 30, (JComponent)this.threadAllocView, null);
        }
        return details;
    }

    private void doRefreshImpl(final javax.swing.Timer timer, final ThreadsMemoryView view) {
        if (!timer.isRunning() || view.isPaused()) {
            return;
        }
        try {
            this.processor.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (!timer.isRunning()) {
                            return;
                        }
                        MemorySamplerSupport.this.doRefreshImplImpl(MemorySamplerSupport.this.threadsMemory.getThreadsMemoryInfo(), view);
                    }
                    catch (Exception e) {
                        MemorySamplerSupport.this.terminate();
                    }
                }
            }, 0L);
        }
        catch (Exception e) {
            this.terminate();
        }
    }

    private void doRefreshImpl(final javax.swing.Timer timer, final MemoryView ... views) {
        if (!timer.isRunning() || views.length == 1 && views[0].isPaused()) {
            return;
        }
        try {
            this.processor.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (!timer.isRunning()) {
                            return;
                        }
                        MemorySamplerSupport.this.doRefreshImplImpl(MemorySamplerSupport.this.jvm.takeHeapHistogram(), views);
                    }
                    catch (Exception e) {
                        MemorySamplerSupport.this.terminate();
                    }
                }
            }, 0L);
        }
        catch (Exception e) {
            this.terminate();
        }
    }

    private void doRefreshImplImpl(final HeapHistogram heapHistogram, final MemoryView ... views) {
        if (heapHistogram != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemorySamplerSupport.this.snapshotDumper.lastHistogram = heapHistogram;
                    for (MemoryView view : views) {
                        view.refresh(heapHistogram);
                    }
                }
            });
        }
    }

    private void doRefreshImplImpl(final ThreadsMemoryInfo info, final ThreadsMemoryView view) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                view.refresh(info);
            }
        });
    }

    public static abstract class SnapshotDumper {
        private volatile HeapHistogram lastHistogram;

        public abstract void takeSnapshot(boolean var1);

        public AllocMemoryResultsSnapshot createSnapshot(long time) {
            HeapHistogram histogram = this.lastHistogram;
            if (histogram != null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                DataOutputStream dos = new DataOutputStream(output);
                try {
                    AllocMemoryResultsSnapshot result = new AllocMemoryResultsSnapshot();
                    Set classes = histogram.getHeapHistogram();
                    dos.writeInt(1);
                    dos.writeLong(histogram.getTime().getTime());
                    dos.writeLong(time);
                    dos.writeInt(classes.size());
                    for (HeapHistogram.ClassInfo info : classes) {
                        dos.writeUTF(info.getName());
                        dos.writeLong(info.getBytes());
                    }
                    dos.writeBoolean(false);
                    dos.writeInt(classes.size());
                    for (HeapHistogram.ClassInfo info : classes) {
                        dos.writeInt((int)info.getInstancesCount());
                    }
                    dos.close();
                    result.readFromStream(new DataInputStream(new ByteArrayInputStream(output.toByteArray())));
                    return result;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }
    }

    public static abstract class HeapDumper {
        public abstract void takeHeapDump(boolean var1);
    }
}

