/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.util.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSerializerToolkit {
    public static final String COMPONENT_TAG_AttributeDescriptor = "AttributeName";

    private XmlSerializerToolkit() {
        throw new AssertionError((Object)"You should not instantiate this class!");
    }

    public static Element exportToXml(MRI descriptor, Element parentNode) {
        Element element = XmlToolkit.createElement((Element)parentNode, (String)COMPONENT_TAG_AttributeDescriptor);
        XmlToolkit.setStringValue((Element)element, (String)descriptor.getQualifiedName());
        return element;
    }

    public static MRI createAttributeDescriptorFromXml(Element parentNode) {
        String qualifiedName = XmlToolkit.getStringValue((Element)parentNode);
        return MRI.createFromQualifiedName(qualifiedName);
    }

    public static void exportToRJMXPreferences(XmlEnabled enabled, String key) {
        try {
            Document doc = XmlToolkit.createNewDocument((String)key);
            enabled.exportToXml(doc.getDocumentElement());
            String data = XmlToolkit.prettyPrint((Element)doc.getDocumentElement());
            RJMXPlugin.getDefault().getRJMXPreferences().put(key, data);
        }
        catch (IOException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not read settings for " + key);
        }
    }

    public static void importFromRJMXPreferences(XmlEnabled enabled, String key) {
        try {
            String value = RJMXPlugin.getDefault().getRJMXPreferences().get(key, null);
            Document doc = null;
            if (value == null || value.length() == 0) {
                RJMXPlugin.getDefault().getLogger().log(Level.INFO, "Reading empty settings for " + key);
                doc = XmlToolkit.createNewDocument((String)enabled.getComponentTag());
            } else {
                doc = XmlToolkit.loadDocumentFromString((String)value);
            }
            enabled.initializeFromXml(doc.getDocumentElement());
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not read settings for " + key);
        }
    }
}

