/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.ITriggerConstraint;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.INotificationFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class TriggerConstraintHolder
implements ITriggerConstraint {
    private static final String XML_COMPONENT_TAG = "constraints";
    private static final String XML_ELEMENT_CONSTRAINT_CLASS = "constraint_class";
    private final List<ITriggerConstraint> m_constraintList = Collections.synchronizedList(new ArrayList(1));
    private String m_name;

    public TriggerConstraintHolder() {
        this.setName("New constraint collection");
    }

    public TriggerConstraintHolder(String name, ITriggerConstraint constraint) {
        this.setName(name);
        this.addConstraint(constraint);
    }

    public List<ITriggerConstraint> getConstraintList() {
        return this.m_constraintList;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void addConstraint(ITriggerConstraint constraint) {
        List<ITriggerConstraint> list = this.getConstraintList();
        if (!list.contains(constraint)) {
            this.getConstraintList().add(constraint);
        }
    }

    public void removeConstraint(ITriggerConstraint constraint) {
        this.getConstraintList().remove(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(TriggerEvent e) {
        List<ITriggerConstraint> list;
        List<ITriggerConstraint> list2 = list = this.getConstraintList();
        synchronized (list2) {
            ITriggerConstraint constraint;
            Iterator<ITriggerConstraint> iter = this.getConstraintList().iterator();
            do {
                if (iter.hasNext()) continue;
                return true;
            } while ((constraint = iter.next()).isValid(e));
            return false;
        }
    }

    @Override
    public String getDescription() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        List<ITriggerConstraint> list = this.getConstraintList();
        buf.append(this.getName());
        List<ITriggerConstraint> list2 = list;
        synchronized (list2) {
            for (ITriggerConstraint constraint : this.getConstraintList()) {
                buf.append('\t');
                buf.append(constraint.getName());
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public void initializeFromXml(Element node, INotificationFactory factory) {
        NodeList constraints = node.getElementsByTagName("constraint");
        int i = 0;
        while (i < constraints.getLength()) {
            Element constraintNode = (Element)constraints.item(i);
            String className = XmlToolkit.getSetting((Element)constraintNode, (String)XML_ELEMENT_CONSTRAINT_CLASS, null);
            assert (className != null);
            ITriggerConstraint constraint = null;
            try {
                constraint = factory.createConstraint(className);
                constraint.initializeFromXml(constraintNode);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error instantiating NotificationConstraint.", e);
                return;
            }
            this.addConstraint(constraint);
            ++i;
        }
    }

    public void exportToXml(Element parentNode) {
        Element constraintsNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        int i = 0;
        while (i < this.getConstraintList().size()) {
            ITriggerConstraint constraint = this.getConstraintList().get(i);
            Element constraintElement = XmlToolkit.createElement((Element)constraintsNode, (String)"constraint");
            XmlToolkit.setSetting((Element)constraintElement, (String)XML_ELEMENT_CONSTRAINT_CLASS, (String)constraint.getClass().getName());
            constraint.exportToXml(constraintElement);
            ++i;
        }
    }

    public String getComponentTag() {
        return XML_COMPONENT_TAG;
    }

    public void initializeFromXml(Element node) throws Exception {
    }
}

