/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AbstractSyntheticNotification;
import com.jrockit.mc.rjmx.subscription.internal.SyntheticAttributeToolkit;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class HotSpotGcNotification
extends AbstractSyntheticNotification {
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection;
    private MRI[] m_notificationDescriptors = null;
    private CompositeData m_lastValue;
    private String m_lastMessage;
    private final NotificationListener m_listener = this.createListener();

    @Override
    public void init(MBeanServerConnection connection, String type, String message) {
        super.init(connection, type, message);
        this.m_connection = connection;
        Set<ObjectName> garbageCollectorMxBeans = SyntheticAttributeToolkit.lookupMxBeans(this.m_connection, "java.lang", "GarbageCollector");
        this.m_notificationDescriptors = SyntheticAttributeToolkit.createNotificationDescriptors(this.m_connection, garbageCollectorMxBeans, COM_SUN_MANAGEMENT_GC_NOTIFICATION);
        SyntheticAttributeToolkit.subscribeToNotifications(this.m_connection, this.m_listener, this.m_notificationDescriptors);
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                HotSpotGcNotification hotSpotGcNotification = HotSpotGcNotification.this;
                synchronized (hotSpotGcNotification) {
                    HotSpotGcNotification.this.m_lastValue = (CompositeData)notification.getUserData();
                    HotSpotGcNotification.this.m_lastMessage = notification.getMessage();
                }
                HotSpotGcNotification.this.triggerNotification();
            }
        };
    }

    @Override
    protected String getMessage() {
        return this.m_lastMessage;
    }

    @Override
    public Object getValue() {
        return this.m_lastValue;
    }

    @Override
    public void stop() {
        SyntheticAttributeToolkit.unsubscribeFromNotifications(this.m_connection, this.m_listener, this.m_notificationDescriptors);
    }
}

