/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IPropertySyntheticAttribute;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AbstractSyntheticAttribute;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;

public abstract class AbstractPropertySyntheticAttribute
extends AbstractSyntheticAttribute
implements IPropertySyntheticAttribute {
    private Map<String, Object> m_properties;

    @Override
    public void setProperties(Map<String, Object> values) {
        this.m_properties = values;
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) {
    }

    protected <T> T getPropertyAttribute(MBeanServerConnection connection, String key) throws NullPointerException {
        Object value = this.m_properties.get(key);
        if (value == null) {
            return null;
        }
        MRI attribute = MRI.createFromQualifiedName(value.toString());
        try {
            Object t = AttributeValueToolkit.getAttribute(connection, attribute);
            return (T)t;
        }
        catch (Exception e) {
            NullPointerException npe = new NullPointerException("Value " + attribute + " could not be accessed!");
            npe.initCause(e);
            throw npe;
        }
    }

    protected Map<String, Object> getPropertyAttributes(MBeanServerConnection connection, String[] keys) throws ReflectionException, MBeanException {
        Map<MRI, Object> values;
        HashMap<MRI, String> attributeKeyMap = new HashMap<MRI, String>();
        ArrayList<MRI> attributes = new ArrayList<MRI>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            MRI attribute = this.lookupAttribute(key);
            if (attribute != null) {
                attributeKeyMap.put(attribute, key);
                attributes.add(attribute);
            }
            ++n2;
        }
        try {
            values = AttributeValueToolkit.getAttributes(connection, attributes);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : values.entrySet()) {
            result.put((String)attributeKeyMap.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    private MRI lookupAttribute(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return MRI.createFromQualifiedName(value.toString());
    }

    protected Object getProperty(String key) {
        return this.m_properties.get(key);
    }
}

