/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ICommercialFeaturesService;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

public class HotSpot23CommercialFeaturesService
implements ICommercialFeaturesService {
    private static final String VM_FLAG_COMMERCIAL_FEATURES = "UnlockCommercialFeatures";
    private static final ObjectName OBJECT_NAME_HS_DIAGNOSTICS;
    private static final String OPERATION_GET_VM_OPTION = "getVMOption";
    private static final String OPERATION_SET_VM_OPTION = "setVMOption";
    private static final String PARAMETER_STRING;
    private static final Logger LOGGER;
    private final IConnectionHandle handle;

    static {
        PARAMETER_STRING = String.class.getName();
        LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
        ObjectName hsName = null;
        try {
            hsName = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "The impossible has happened!", e);
        }
        OBJECT_NAME_HS_DIAGNOSTICS = hsName;
    }

    public HotSpot23CommercialFeaturesService(IConnectionHandle handle) {
        this.handle = handle;
    }

    @Override
    public boolean hasCommercialFeatures() {
        return this.hasVMOption(VM_FLAG_COMMERCIAL_FEATURES);
    }

    @Override
    public boolean isCommercialFeaturesEnabled() {
        try {
            return this.parseEnablement((String)this.getVMOption(VM_FLAG_COMMERCIAL_FEATURES));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setCommercialFeaturesEnabled(boolean enable) throws UnsupportedOperationException {
        try {
            this.setVMOption(VM_FLAG_COMMERCIAL_FEATURES, Boolean.toString(enable));
        }
        catch (Exception e) {
            String message = String.format("Could not %s the commercial features!", enable ? "enable" : "disable");
            throw new UnsupportedOperationException(message, e);
        }
    }

    private boolean parseEnablement(String result) {
        return result != null && result.contains("true");
    }

    private boolean hasVMOption(String flag) {
        try {
            this.getVMOption(flag);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setVMOption(String flag, String value) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        MBeanServerConnection connection = this.handle.getServiceOrDummy(MBeanServerConnection.class);
        connection.invoke(OBJECT_NAME_HS_DIAGNOSTICS, OPERATION_SET_VM_OPTION, new Object[]{flag, value}, new String[]{PARAMETER_STRING, PARAMETER_STRING});
    }

    private Object getVMOption(String flag) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        MBeanServerConnection connection = this.handle.getServiceOrDummy(MBeanServerConnection.class);
        CompositeData data = (CompositeData)connection.invoke(OBJECT_NAME_HS_DIAGNOSTICS, OPERATION_GET_VM_OPTION, new Object[]{flag}, new String[]{PARAMETER_STRING});
        return data.get("value");
    }
}

