/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.IDiagnosticCommandService;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public class DefaultVirtualMachineService
implements IVirtualMachineService {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final IMBeanHelperService connectionHandle;
    private IDiagnosticCommandService diagService;
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");

    public DefaultVirtualMachineService(IConnectionHandle handle) {
        this.connectionHandle = handle.getServiceOrDummy(IMBeanHelperService.class);
    }

    @Override
    public int getAvailableProcessors() throws IOException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        Object val;
        try {
            val = this.connectionHandle.getAttribute(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "AvailableProcessors")).getValue();
        }
        catch (JMException e) {
            return 0;
        }
        return ((Number)val).intValue();
    }

    @Override
    public String getThreadStackDump() throws IOException, UnsupportedOperationException {
        try {
            if (this.diagService == null) {
                try {
                    this.diagService = ((IConnectionHandle)((Object)this.connectionHandle)).getServiceOrDummy(IDiagnosticCommandService.class);
                }
                catch (CouldNotCreateServiceException e) {
                    throw new UnsupportedOperationException("Could not instantiate diagnostic commands service!", e);
                }
            }
            return this.diagService.runCtrlBreakHandlerWithResult("Thread.print");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error getting thread stack dump!", e);
            return null;
        }
    }

    @Override
    public void gc() throws IOException, UnsupportedOperationException {
        this.connectionHandle.invokeMethod(this.connectionHandle.createObjectName("java.lang:type=Memory"), "gc");
    }

    @Override
    public String getVersionString() {
        try {
            return this.connectionHandle.getAttribute(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "VmVersion")).getValue().toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error resolving JVM version attribute!", e);
            return null;
        }
    }

    @Override
    public int getPID() {
        try {
            Object o = this.connectionHandle.getAttribute(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "Name")).getValue();
            if (o != null) {
                String s = o.toString();
                o = s.split("@")[0];
                return Integer.parseInt(o.toString());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not retrieve PID in " + this.getClass().getName(), e);
        }
        return 0;
    }

    @Override
    public long[] getThreadCpuTime(long[] threadIds) throws IOException, UnsupportedOperationException {
        long[] cpuTimes = (long[])this.connectionHandle.invokeMethod(this.connectionHandle.createObjectName("java.lang:type=Threading"), "getThreadCpuTime", new Object[]{threadIds}, new String[]{"[J"});
        if (cpuTimes == null) {
            return EMPTY_LONG_ARRAY;
        }
        return cpuTimes;
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] threadIds) throws IOException, UnsupportedOperationException {
        long[] allocatedBytes = (long[])this.connectionHandle.invokeMethod(this.connectionHandle.createObjectName("java.lang:type=Threading"), "getThreadAllocatedBytes", new Object[]{threadIds}, new String[]{"[J"});
        if (allocatedBytes == null) {
            return EMPTY_LONG_ARRAY;
        }
        return allocatedBytes;
    }
}

