// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

// generated by Fast Light User Interface Designer (fluid) version 1.0106

#include "ct_image_window.h"

inline void parameter_window::cb_OK_i(Fl_Return_Button*, void*) {
  val = 1;
}
void parameter_window::cb_OK(Fl_Return_Button* o, void* v) {
  ((parameter_window*)(o->parent()->user_data()))->cb_OK_i(o,v);
}

inline void parameter_window::cb_Cancel_i(Fl_Button*, void*) {
  val = 0;
}
void parameter_window::cb_Cancel(Fl_Button* o, void* v) {
  ((parameter_window*)(o->parent()->user_data()))->cb_Cancel_i(o,v);
}

parameter_window::parameter_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = param_window = new Fl_Double_Window(391, 105, "Open Slice Parameter");
    w = o;
    o->user_data((void*)(this));
    { Fl_Value_Input* o = width = new Fl_Value_Input(55, 10, 50, 25, "X size :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->maximum(1000);
      o->value(512);
      o->when(FL_WHEN_RELEASE);
    }
    { Fl_Value_Input* o = height = new Fl_Value_Input(55, 40, 50, 25, "Y size :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->maximum(1000);
      o->value(512);
    }
    { Fl_Value_Input* o = depth = new Fl_Value_Input(55, 70, 50, 25, "Z size :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->maximum(1000);
      o->value(400);
    }
    { Fl_Value_Input* o = sizeX = new Fl_Value_Input(170, 10, 50, 25, "Real X :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->maximum(100);
      o->value(0.625);
    }
    { Fl_Value_Input* o = sizeY = new Fl_Value_Input(170, 40, 50, 25, "Real Y :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->maximum(100);
      o->value(0.625);
    }
    { Fl_Value_Input* o = sizeZ = new Fl_Value_Input(170, 70, 50, 25, "Real Z :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->maximum(100);
      o->value(1);
    }
    { Fl_Value_Input* o = offset = new Fl_Value_Input(315, 10, 65, 25, "CT offset :");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(8);
      o->minimum(-2000);
      o->maximum(7999);
    }
    { Fl_Return_Button* o = OK = new Fl_Return_Button(235, 60, 70, 35, "OK");
      o->labelsize(16);
      o->callback((Fl_Callback*)cb_OK);
    }
    { Fl_Button* o = Cancel = new Fl_Button(310, 60, 70, 35, "Cancel");
      o->labelsize(16);
      o->callback((Fl_Callback*)cb_Cancel);
    }
    o->set_modal();
    o->end();
  }
  val = -1;
}

int parameter_window::value() {
  return(val);
}

void parameter_window::hide() {
  param_window->hide();
}

bool parameter_window::show() {
  param_window->show();
  while(value()<0) Fl::wait(0);
  hide( );
  Fl::wait(0);
  return( value( ) ? true : false );
}

inline void ct_image_window::cb_Open_i(Fl_Menu_*, void*) {
  ct_image->read_image( this );
}
void ct_image_window::cb_Open(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Open_i(o,v);
}

inline void ct_image_window::cb_Save_i(Fl_Menu_*, void*) {
  ct_image->write_image( this );
}
void ct_image_window::cb_Save(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Save_i(o,v);
}

inline void ct_image_window::cb_Median_i(Fl_Menu_*, void*) {
  ct_image->median_filter1D( this );
}
void ct_image_window::cb_Median(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Median_i(o,v);
}

inline void ct_image_window::cb_Median1_i(Fl_Menu_*, void*) {
  ct_image->median_filter2D( this );
}
void ct_image_window::cb_Median1(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Median1_i(o,v);
}

inline void ct_image_window::cb_Median2_i(Fl_Menu_*, void*) {
  ct_image->median_filter3D( this );
}
void ct_image_window::cb_Median2(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Median2_i(o,v);
}

inline void ct_image_window::cb_Normalization_i(Fl_Menu_*, void*) {
  ct_image->normalization_filter3D( this );
}
void ct_image_window::cb_Normalization(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Normalization_i(o,v);
}

inline void ct_image_window::cb_Euclidean_i(Fl_Menu_*, void*) {
  ct_image->euclidean_distance_transform( this );
}
void ct_image_window::cb_Euclidean(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Euclidean_i(o,v);
}

inline void ct_image_window::cb_Labeling_i(Fl_Menu_*, void*) {
  ct_image->labeling6( this );
}
void ct_image_window::cb_Labeling(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Labeling_i(o,v);
}

inline void ct_image_window::cb_Labeling1_i(Fl_Menu_*, void*) {
  ct_image->labeling26( this );
}
void ct_image_window::cb_Labeling1(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Labeling1_i(o,v);
}

inline void ct_image_window::cb_Thinning_i(Fl_Menu_*, void*) {
  ct_image->thinning6( this );
}
void ct_image_window::cb_Thinning(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Thinning_i(o,v);
}

inline void ct_image_window::cb_Thinning1_i(Fl_Menu_*, void*) {
  ct_image->thinning26( this );
}
void ct_image_window::cb_Thinning1(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Thinning1_i(o,v);
}

inline void ct_image_window::cb_Erosion_i(Fl_Menu_*, void*) {
  ct_image->erosion( this );
}
void ct_image_window::cb_Erosion(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Erosion_i(o,v);
}

inline void ct_image_window::cb_Dilation_i(Fl_Menu_*, void*) {
  ct_image->dilation( this );
}
void ct_image_window::cb_Dilation(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Dilation_i(o,v);
}

inline void ct_image_window::cb_Opening_i(Fl_Menu_*, void*) {
  ct_image->opening( this );
}
void ct_image_window::cb_Opening(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Opening_i(o,v);
}

inline void ct_image_window::cb_Closing_i(Fl_Menu_*, void*) {
  ct_image->closing( this );
}
void ct_image_window::cb_Closing(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Closing_i(o,v);
}

inline void ct_image_window::cb_Figure_i(Fl_Menu_*, void*) {
  ct_image->figure_decomposition( this );
}
void ct_image_window::cb_Figure(Fl_Menu_* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Figure_i(o,v);
}

Fl_Menu_Item ct_image_window::menu_[] = {
 {"&File", 0,  0, 0, 64, 0, 0, 14, 56},
 {"&Open", 0,  (Fl_Callback*)ct_image_window::cb_Open, 0, 0, 0, 0, 14, 56},
 {"&Save", 0,  (Fl_Callback*)ct_image_window::cb_Save, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {"&Edit", 0,  0, 0, 64, 0, 0, 14, 56},
 {"&Median Filter 1D", 0,  (Fl_Callback*)ct_image_window::cb_Median, 0, 0, 0, 0, 14, 56},
 {"&Median Filter 2D", 0,  (Fl_Callback*)ct_image_window::cb_Median1, 0, 0, 0, 0, 14, 56},
 {"&Median Filter 3D", 0,  (Fl_Callback*)ct_image_window::cb_Median2, 0, 0, 0, 0, 14, 56},
 {"&Normalization Filter 3D", 0,  (Fl_Callback*)ct_image_window::cb_Normalization, 0, 0, 0, 0, 14, 56},
 {"&Euclidean Distance Transform", 0,  (Fl_Callback*)ct_image_window::cb_Euclidean, 0, 0, 0, 0, 14, 56},
 {"Labeling 6", 0,  (Fl_Callback*)ct_image_window::cb_Labeling, 0, 0, 0, 0, 14, 56},
 {"Labeling 26", 0,  (Fl_Callback*)ct_image_window::cb_Labeling1, 0, 0, 0, 0, 14, 56},
 {"Thinning 6", 0,  (Fl_Callback*)ct_image_window::cb_Thinning, 0, 0, 0, 0, 14, 56},
 {"Thinning 26", 0,  (Fl_Callback*)ct_image_window::cb_Thinning1, 0, 0, 0, 0, 14, 56},
 {"Erosion", 0,  (Fl_Callback*)ct_image_window::cb_Erosion, 0, 0, 0, 0, 14, 56},
 {"Dilation", 0,  (Fl_Callback*)ct_image_window::cb_Dilation, 0, 0, 0, 0, 14, 56},
 {"Opening", 0,  (Fl_Callback*)ct_image_window::cb_Opening, 0, 0, 0, 0, 14, 56},
 {"Closing", 0,  (Fl_Callback*)ct_image_window::cb_Closing, 0, 0, 0, 0, 14, 56},
 {"Figure Decomposition", 0,  (Fl_Callback*)ct_image_window::cb_Figure, 0, 0, 0, 0, 14, 56},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

inline void ct_image_window::cb_WL_i(Fl_Value_Slider* o, void*) {
  ct_image->change_window_level( o->value( ) );
}
void ct_image_window::cb_WL(Fl_Value_Slider* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_WL_i(o,v);
}

inline void ct_image_window::cb_WW_i(Fl_Value_Slider* o, void*) {
  ct_image->change_window_width( o->value( ) );
}
void ct_image_window::cb_WW(Fl_Value_Slider* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_WW_i(o,v);
}

inline void ct_image_window::cb_Indx_i(Fl_Value_Slider* o, void*) {
  ct_image->change_index( static_cast< int >( o->value( ) ) );
}
void ct_image_window::cb_Indx(Fl_Value_Slider* o, void* v) {
  ((ct_image_window*)(o->parent()->user_data()))->cb_Indx_i(o,v);
}

ct_image_window::ct_image_window( ) {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = image_window = new Fl_Double_Window(421, 528);
    w = o;
    o->user_data((void*)(this));
    { Fl_Group* o = new Fl_Group(5, 30, 410, 410);
      o->box(FL_PLASTIC_DOWN_FRAME);
      { ct_draw_area* o = ct_image = new ct_draw_area(10, 35, 400, 400, "label");
        o->box(FL_FLAT_BOX);
        o->color(FL_DARK3);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_BLACK);
        o->align(FL_ALIGN_CENTER);
        o->when(FL_WHEN_RELEASE);
      }
      o->end();
    }
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(0, 0, 100, 25);
      o->box(FL_FLAT_BOX);
      o->menu(menu_);
    }
    { Fl_Value_Slider* o = WL = new Fl_Value_Slider(40, 470, 375, 20, "WL");
      o->type(1);
      o->box(FL_PLASTIC_THIN_DOWN_BOX);
      o->minimum(-2000);
      o->maximum(7000);
      o->step(1);
      o->value(40);
      o->callback((Fl_Callback*)cb_WL);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Slider* o = WW = new Fl_Value_Slider(40, 495, 375, 20, "WW");
      o->type(1);
      o->box(FL_PLASTIC_THIN_DOWN_BOX);
      o->minimum(1);
      o->maximum(4000);
      o->step(1);
      o->value(300);
      o->callback((Fl_Callback*)cb_WW);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Slider* o = Indx = new Fl_Value_Slider(40, 445, 375, 20, "Indx");
      o->type(1);
      o->box(FL_PLASTIC_THIN_DOWN_BOX);
      o->step(1);
      o->callback((Fl_Callback*)cb_Indx);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Progress* o = progress_bar = new Fl_Progress(115, 5, 300, 20);
      o->box(FL_PLASTIC_THIN_UP_BOX);
      o->selection_color((Fl_Color)1);
      o->hide();
    }
    o->end();
  }
}

void ct_image_window::show() {
  image_window->show();
}
