// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/binary.h
//!
//! @brief oCiZs߂̃NX
//!

#ifndef __INCLUDE_MIST_BINARY_H__
#define __INCLUDE_MIST_BINARY_H__


#ifndef __INCLUDE_MIST_CONF_H__
#include "mist_conf.h"
#endif

#include <iostream>

// mistOԂ̎n܂
_MIST_BEGIN


// MISTŗp̃f[^^


/// @brief oCiZs߂̂
//! 
//! @code oCi摜̍쐬
//! mist::array2< mist::binary > image;
//! @endcode
//! 
class binary
{
public:
	typedef size_t size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef ptrdiff_t difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef bool& reference;				///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef const bool& const_reference;	///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ
	typedef bool value_type;				///< @brief f[^^Dbool Ɠ
	typedef bool* pointer;					///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef const bool* const_pointer;		///< @brief f[^^ const |C^[^Ddata ̏ꍇCconst data * ƂȂ

private:
	bool value_;		///< @brief oCi̊{

public:
	/// @brief ftHgRXgN^ivf false ŏj
	binary( ) : value_( false ){ }

	/// @brief  b ŏ
	binary( const value_type &b ) : value_( b ){ }

	/// @brief ̃oCifpď
	binary( const binary &b ) : value_( b.value_ ){ }


	/// @brief ̃oCif
	const binary &operator  =( const binary &b ){ value_ = b.value_; return( *this ); }

	/// @brief vf b 
	const binary &operator  =( const value_type &b ){ value_ = b; return( *this ); }


	/// @brief _a
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> true
	//! - true  + false -> true
	//! - false + true  -> true
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator +=( const binary &b ){ value_ = value_ || b.value_; return( *this ); }

	/// @brief _
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> false
	//! - true  + false -> true
	//! - false + true  -> false
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator -=( const binary &b ){ value_ = value_ && !b.value_; return( *this ); }

	/// @brief _
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> true
	//! - true  + false -> false
	//! - false + true  -> false
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator *=( const binary &b ){ value_ = value_ && b.value_; return( *this ); }

	/// @brief r_
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> true
	//! - true  + false -> false
	//! - false + true  -> false
	//! - false + false -> true
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator /=( const binary &b ){ value_ = value_ == b.value_; return( *this ); }

	/// @brief _
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> false
	//! - true  + false -> true
	//! - false + true  -> false
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator %=( const binary &b ){ value_ = value_ && !b.value_; return( *this ); }

	/// @brief _a
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> true
	//! - true  + false -> true
	//! - false + true  -> true
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator |=( const binary &b ){ value_ = value_ || b.value_; return( *this ); }

	/// @brief _
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> true
	//! - true  + false -> false
	//! - false + true  -> false
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator &=( const binary &b ){ value_ = value_ && b.value_; return( *this ); }

	/// @brief r_a
	//! 
	//! ȉ̉Zs
	//! - true  + true  -> false
	//! - true  + false -> true
	//! - false + true  -> true
	//! - false + false -> false
	//! 
	//! @param[in] b c EӒl
	//! 
	//! @return Z
	//! 
	const binary &operator ^=( const binary &b ){ value_ = value_ != b.value_; return( *this ); }


	/// @brief _a
	const binary &operator +=( const value_type &b ){ return( operator +=( binary( b ) ) ); }

	/// @brief _
	const binary &operator -=( const value_type &b ){ return( operator -=( binary( b ) ) ); }

	/// @brief _
	const binary &operator *=( const value_type &b ){ return( operator *=( binary( b ) ) ); }

	/// @brief r_
	const binary &operator /=( const value_type &b ){ return( operator /=( binary( b ) ) ); }


	/// @brief ͂ꂽ2̃IuWFNgǂ𔻒肷
	bool operator ==( const binary &b ) const { return( value_ == b.value_ ); }

	/// @brief ͂ꂽ2̃IuWFNgȂǂ𔻒肷
	bool operator !=( const binary &b ) const { return( value_ != b.value_ ); }

	/// @brief ͂ꂽ2̃IuWFNg < ֌W𔻒肷
	bool operator < ( const binary &b ) const { return( value_ <  b.value_ ); }

	/// @brief ͂ꂽ2̃IuWFNg <= ֌W𔻒肷
	bool operator <=( const binary &b ) const { return( value_ <= b.value_ ); }

	/// @brief ͂ꂽ2̃IuWFNg > ֌W𔻒肷
	bool operator > ( const binary &b ) const { return( value_ >  b.value_ ); }

	/// @brief ͂ꂽ2̃IuWFNg >= ֌W𔻒肷
	bool operator >=( const binary &b ) const { return( value_ >= b.value_ ); }


	/// @brief f[^擾
	value_type get_value( ) const { return( value_ ); }

	// boolւ̎LXgZqi댯̂߈ꎞ~j
	//operator bool( ) const { return( value_ ); }
};


/// _Z
inline const binary operator +( const binary &b1, const binary &b2 ){ return( binary( b1 ) += b2 ); }

/// _Z
inline const binary operator -( const binary &b1, const binary &b2 ){ return( binary( b1 ) -= b2 ); }

/// _Z
inline const binary operator *( const binary &b1, const binary &b2 ){ return( binary( b1 ) *= b2 ); }

/// _Z
inline const binary operator /( const binary &b1, const binary &b2 ){ return( binary( b1 ) /= b2 ); }

/// _Z
inline const binary operator %( const binary &b1, const binary &b2 ){ return( binary( b1 ) %= b2 ); }

/// _Z
inline const binary operator |( const binary &b1, const binary &b2 ){ return( binary( b1 ) |= b2 ); }

/// _Z
inline const binary operator &( const binary &b1, const binary &b2 ){ return( binary( b1 ) &= b2 ); }

/// _Z
inline const binary operator ^( const binary &b1, const binary &b2 ){ return( binary( b1 ) ^= b2 ); }


/// _Z
inline const binary operator *( const binary &b1, const binary::value_type &b2 ){ return( binary( b1 ) *= b2 ); }

/// _Z
inline const binary operator *( const binary::value_type &b1, const binary &b2 ){ return( binary( b2 ) *= b1 ); }

/// _Z
inline const binary operator /( const binary &b1, const binary::value_type &b2 ){ return( binary( b1 ) /= b2 ); }


/// _Z
inline const binary operator +( const binary &b1, const binary::value_type &b2 ){ return( binary( b1 ) += b2 ); }

/// _Z
inline const binary operator +( const binary::value_type &b1, const binary &b2 ){ return( binary( b2 ) += b1 ); }

/// _Z
inline const binary operator -( const binary &b1, const binary::value_type &b2 ){ return( binary( b1 ) -= b2 ); }

/// _Z
inline const binary operator -( const binary::value_type &b1, const binary &b2 ){ return( binary( b1 ) -= b2 ); }



/// @brief w肳ꂽXg[ɁCRei̗vf𐮌`ďo͂
//! 
//! @param[in,out] out c ͂Əo͂sXg[
//! @param[in]     b   c oCif
//! 
//! @return ͂ꂽXg[
//! 
//! @code o͗
//! 1
//! @endcode
//! 
inline std::ostream &operator <<( std::ostream &out, const binary &b )
{
	out << b.get_value( );
	return( out );
}


// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_BINARY_H__
