/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.security.PublicKey;
import jdk.internal.event.EventHelper;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.jfr.events.X509CertificateEvent;
import oracle.jrockit.jfr.VMJFR;
import sun.security.util.KeyUtil;
import sun.security.x509.X509CertImpl;

@InstrumentationTarget(value="sun.security.provider.X509Factory")
final class X509FactoryInstrumentor {
    private X509FactoryInstrumentor() {
    }

    @InstrumentationMethod
    private void recordEvent(X509CertImpl x509CertImpl) {
        if (!VMJFR.x509CertificateToken.isEnabled()) {
            this.recordEvent(x509CertImpl);
            return;
        }
        X509CertificateEvent x509CertificateEvent = new X509CertificateEvent(VMJFR.x509CertificateToken);
        if (x509CertificateEvent.shouldWrite() || EventHelper.isLoggingSecurity()) {
            PublicKey publicKey = x509CertImpl.getPublicKey();
            String string = x509CertImpl.getSigAlgName();
            String string2 = x509CertImpl.getSerialNumber().toString(16);
            String string3 = x509CertImpl.getSubjectDN().getName();
            String string4 = x509CertImpl.getIssuerDN().getName();
            String string5 = publicKey.getAlgorithm();
            int n = KeyUtil.getKeySize(publicKey);
            int n2 = x509CertImpl.hashCode();
            long l = x509CertImpl.getNotBefore().getTime();
            long l2 = x509CertImpl.getNotAfter().getTime();
            if (x509CertificateEvent.shouldWrite()) {
                x509CertificateEvent.algorithm = string;
                x509CertificateEvent.serialNumber = string2;
                x509CertificateEvent.subject = string3;
                x509CertificateEvent.issuer = string4;
                x509CertificateEvent.keyType = string5;
                x509CertificateEvent.keyLength = n;
                x509CertificateEvent.certificateId = n2;
                x509CertificateEvent.validFrom = l;
                x509CertificateEvent.validUntil = l2;
                x509CertificateEvent.commit();
            }
            if (EventHelper.isLoggingSecurity()) {
                EventHelper.logX509CertificateEvent(string, string2, string3, string4, string5, n, n2, l, l2);
            }
        }
    }
}

