/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.UI;
import rdj.Validate;

class MySimpleFCFileVisitor
extends SimpleFileVisitor<Path> {
    private final UI ui;
    private final PathMatcher pathMatcher;
    private final boolean verbose;
    private final boolean symlink;
    private final boolean setFCPathlist;
    public FCPath keyFCPath;
    private FCPathList<FCPath> targetFCPathList;
    private boolean negatePattern;
    public long bytesCount = 0L;
    public static boolean running = false;
    private static boolean disabledMAC = false;
    public static final int NOFUNCTION = 0;
    public static final int SCAN = 1;
    public static final int DELETE = 2;
    public static final int BACKUP = 3;
    public static int function = 0;

    public MySimpleFCFileVisitor(UI ui, boolean verbose, int function, boolean symlink, boolean setFCPathlist, FCPath keyFCPath, FCPathList<FCPath> targetFCPathList, String pattern, boolean negatePattern, boolean disabledMAC) {
        this.ui = ui;
        this.pathMatcher = FileSystems.getDefault().getPathMatcher(pattern);
        this.verbose = verbose;
        MySimpleFCFileVisitor.function = function;
        this.symlink = symlink;
        this.setFCPathlist = setFCPathlist;
        this.keyFCPath = keyFCPath;
        this.targetFCPathList = targetFCPathList;
        this.negatePattern = negatePattern;
        MySimpleFCFileVisitor.disabledMAC = disabledMAC;
        this.bytesCount = 0L;
        running = true;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
        if (running) {
            if (function == 2) {
                return FileVisitResult.CONTINUE;
            }
            if (function == 1) {
                if (this.setFCPathlist) {
                    if (Validate.isValidDir(this.ui, path, this.symlink, true)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (function == 3) {
                return FileVisitResult.CONTINUE;
            }
            this.ui.log("Huh? this shouldn't have happened. Neither booleans: delete & returnpathlist are present?\r\n", true, true, false, false, false);
            return FileVisitResult.CONTINUE;
        }
        this.targetFCPathList.clear();
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        if (running) {
            if (path.getFileName() != null && this.negatePattern ^ this.pathMatcher.matches(path.getFileName())) {
                if (function == 2) {
                    this.ui.log("Delete: \"" + path + "\"\r\n", true, true, true, false, false);
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: visitFile(.. ) Failed file: " + path.toAbsolutePath().toString() + " due to: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    }
                    if (this.keyFCPath != null && this.keyFCPath.isValidKeyDir) {
                        Path autoKeyPath1 = Paths.get(this.keyFCPath.path.toAbsolutePath().toString(), path.toAbsolutePath().toString().replace(":", ""));
                        Path autoKeyPath2 = Paths.get(this.keyFCPath.path.toAbsolutePath().toString(), path.toAbsolutePath().toString().replace(":", "") + ".bit");
                        if (Files.exists(autoKeyPath1, LinkOption.NOFOLLOW_LINKS)) {
                            this.ui.log("Delete: \"" + autoKeyPath1 + "\"\r\n", true, true, true, false, false);
                            try {
                                Files.delete(autoKeyPath1);
                            }
                            catch (IOException ex) {
                                this.ui.log("Error: visitFile(.. ) Failed file: " + autoKeyPath1.toAbsolutePath().toString() + " due to: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                            }
                        }
                        if (Files.exists(autoKeyPath2, LinkOption.NOFOLLOW_LINKS)) {
                            this.ui.log("Delete: \"" + autoKeyPath2 + "\"\r\n", true, true, true, false, false);
                            try {
                                Files.delete(autoKeyPath2);
                            }
                            catch (IOException ex) {
                                this.ui.log("Error: visitFile(.. ) Failed file: " + autoKeyPath2.toAbsolutePath().toString() + " due to: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                            }
                        }
                    }
                } else if (function == 1) {
                    if (this.setFCPathlist) {
                        FCPath fcPath = Validate.getFCPath(this.ui, "", path, false, this.keyFCPath.path, disabledMAC, true);
                        this.targetFCPathList.add(fcPath);
                    }
                } else if (function != 3) {
                    this.ui.log("Huh? this shouldn't have happened. Neither booleans: delete & returnpathlist are present?\r\n", true, true, false, false, false);
                }
            }
            return FileVisitResult.CONTINUE;
        }
        this.targetFCPathList.clear();
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException exc) {
        if (running) {
            FCPath fcPath = Validate.getFCPath(this.ui, "", path, false, this.keyFCPath.path, disabledMAC, true);
            this.targetFCPathList.add(fcPath);
            return FileVisitResult.SKIP_SIBLINGS;
        }
        this.targetFCPathList.clear();
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException exc) {
        if (running) {
            if (function == 2) {
                Path autoKeyDir;
                this.ui.log("Delete: \"" + path + "\"\r\n", true, true, true, false, false);
                try {
                    Files.delete(path);
                }
                catch (IOException ex) {
                    this.ui.log("Error: postVisitDirectory: " + path.toAbsolutePath().toString() + " due to: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
                if (this.keyFCPath != null && this.keyFCPath.isValidKeyDir && Files.exists(autoKeyDir = Paths.get(this.keyFCPath.path.toAbsolutePath().toString(), path.toAbsolutePath().toString().replace(":", "")), LinkOption.NOFOLLOW_LINKS)) {
                    this.ui.log("Delete: \"" + autoKeyDir + "\"\r\n", true, true, true, false, false);
                    try {
                        Files.delete(autoKeyDir);
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: visitFile(.. ) Failed dir: " + autoKeyDir.toAbsolutePath().toString() + " due to: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    }
                }
            } else if (function == 1) {
                if (this.setFCPathlist) {
                    // empty if block
                }
            } else if (function != 3) {
                this.ui.log("Huh? this shouldn't have happened. Neither booleans: delete & returnpathlist are present?\r\n", true, true, false, false, false);
            }
            return FileVisitResult.CONTINUE;
        }
        this.targetFCPathList.clear();
        return FileVisitResult.TERMINATE;
    }
}

