/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.util.ArrayList;
import rdj.DeviceController;
import rdj.FCPath;
import rdj.GPT;
import rdj.UI;

public class GPT_PMBR {
    private final long ABSTRACT_LBA = 0L;
    private String DESCSTRING;
    private final long LENGTH = DeviceController.bytesPerSector * 1L;
    private byte[] bootcodeBytes;
    private byte[] diskSignatureBytes;
    private byte[] reservedBytes;
    private byte[] bootIndicatorBytes;
    private byte[] startingCHSBytes;
    private byte[] osTypeBytes;
    private byte[] endingCHSBytes;
    private byte[] startingLBABytes;
    private byte[] sizeInLBABytes;
    private byte[] partition2Bytes;
    private byte[] partition3Bytes;
    private byte[] partition4Bytes;
    private byte[] magicNumberBytes;
    private UI ui;

    public GPT_PMBR(UI ui) {
        this.ui = ui;
        this.bootcodeBytes = new byte[440];
        this.diskSignatureBytes = new byte[4];
        this.reservedBytes = new byte[2];
        this.bootIndicatorBytes = new byte[1];
        this.startingCHSBytes = new byte[3];
        this.osTypeBytes = new byte[1];
        this.endingCHSBytes = new byte[3];
        this.startingLBABytes = new byte[4];
        this.sizeInLBABytes = new byte[4];
        this.partition2Bytes = new byte[16];
        this.partition3Bytes = new byte[16];
        this.partition4Bytes = new byte[16];
        this.magicNumberBytes = new byte[2];
        this.clear();
    }

    public void clear() {
        this.bootcodeBytes = GPT.getZeroBytes(440);
        this.diskSignatureBytes = GPT.hex2Bytes("00 00 00 00");
        this.reservedBytes = GPT.hex2Bytes("00 00");
        this.bootIndicatorBytes = GPT.hex2Bytes("00");
        this.startingCHSBytes = GPT.hex2Bytes("000000");
        this.osTypeBytes = GPT.hex2Bytes("00");
        this.endingCHSBytes = GPT.hex2Bytes("000000");
        this.startingLBABytes = GPT.hex2Bytes("00 00 00 00");
        this.sizeInLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(0L, 4));
        this.partition2Bytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.partition3Bytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.partition4Bytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.magicNumberBytes = GPT.hex2Bytes("00 00");
        this.setDesc();
    }

    public void read(FCPath fcPath) {
        byte[] bytes = new byte[(int)this.LENGTH];
        new DeviceController(this.ui);
        bytes = DeviceController.readLBA(fcPath, 0L, this.LENGTH);
        this.bootcodeBytes = GPT.getBytesPart(bytes, 0, 440);
        this.diskSignatureBytes = GPT.getBytesPart(bytes, 440, 4);
        this.reservedBytes = GPT.getBytesPart(bytes, 444, 2);
        this.bootIndicatorBytes = GPT.getBytesPart(bytes, 446, 1);
        this.startingCHSBytes = GPT.getBytesPart(bytes, 447, 3);
        this.osTypeBytes = GPT.getBytesPart(bytes, 450, 1);
        this.endingCHSBytes = GPT.getBytesPart(bytes, 451, 3);
        this.startingLBABytes = GPT.getBytesPart(bytes, 454, 4);
        this.sizeInLBABytes = GPT.getBytesPart(bytes, 458, 4);
        this.partition2Bytes = GPT.getBytesPart(bytes, 462, 16);
        this.partition3Bytes = GPT.getBytesPart(bytes, 478, 16);
        this.partition4Bytes = GPT.getBytesPart(bytes, 494, 16);
        this.magicNumberBytes = GPT.getBytesPart(bytes, 510, 2);
        this.setDesc();
    }

    public void create(FCPath fcPath) {
        this.bootcodeBytes = GPT.getZeroBytes(440);
        this.diskSignatureBytes = GPT.hex2Bytes("00 00 00 00");
        this.reservedBytes = GPT.hex2Bytes("00 00");
        this.bootIndicatorBytes = GPT.hex2Bytes("00");
        this.startingCHSBytes = GPT.hex2Bytes("000100");
        this.osTypeBytes = GPT.hex2Bytes("EE");
        this.endingCHSBytes = GPT.hex2Bytes("FEFFFF");
        this.startingLBABytes = GPT.hex2Bytes("01 00 00 00");
        this.sizeInLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian((fcPath.size - DeviceController.bytesPerSector) / DeviceController.bytesPerSector, 4));
        this.partition2Bytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.partition3Bytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.partition4Bytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.magicNumberBytes = GPT.hex2Bytes("55 AA");
        this.setDesc();
    }

    public void write(FCPath fcPath) {
        new DeviceController(this.ui);
        DeviceController.writeLBA(this.getDesc(), this.getBytes(), fcPath, 0L);
    }

    public byte[] getBytes(int off, int length) {
        return GPT.getBytesPart(this.getBytes(), off, length);
    }

    public byte[] getBytes() {
        ArrayList<Byte> definitiveByteList = new ArrayList<Byte>();
        for (byte mybyte : this.bootcodeBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.diskSignatureBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.reservedBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.bootIndicatorBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.startingCHSBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.osTypeBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.endingCHSBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.startingLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.sizeInLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.partition2Bytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.partition3Bytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.partition4Bytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.magicNumberBytes) {
            definitiveByteList.add(mybyte);
        }
        return GPT.byteListToByteArray(definitiveByteList);
    }

    public void print() {
        this.ui.log(this.toString(), true, true, true, false, false);
    }

    private void setDesc() {
        this.DESCSTRING = "[ LBA 0 - Protective MBR (" + this.getBytes().length + " Bytes) Storage: " + GPT.getLBAHumanSize(this.sizeInLBABytes, 1) + " ]";
    }

    private String getDesc() {
        return this.DESCSTRING;
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + "\r\n";
        returnString = returnString + "========================================================================\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + this.DESCSTRING + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + String.format("%-25s", "BootCode");
        returnString = returnString + GPT.getHexAndDecimal(this.bootcodeBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "Disk Signature");
        returnString = returnString + GPT.getHexAndDecimal(this.diskSignatureBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "Reserved");
        returnString = returnString + GPT.getHexAndDecimal(this.reservedBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "BootIndicator");
        returnString = returnString + GPT.getHexAndDecimal(this.bootIndicatorBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "StartCHS");
        returnString = returnString + GPT.getHexAndDecimal(this.startingCHSBytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "OSType");
        returnString = returnString + GPT.getHexAndDecimal(this.osTypeBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "EndingCHS");
        returnString = returnString + GPT.getHexAndDecimal(this.endingCHSBytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "StartingLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.startingLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "SizeInLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.sizeInLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "Partition2");
        returnString = returnString + GPT.getHexAndDecimal(this.partition2Bytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "Partition3");
        returnString = returnString + GPT.getHexAndDecimal(this.partition3Bytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "Partition4");
        returnString = returnString + GPT.getHexAndDecimal(this.partition4Bytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "MagicNumber");
        returnString = returnString + GPT.getHexAndDecimal(this.magicNumberBytes, false) + "\r\n";
        return returnString;
    }
}

